/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectFrameworkImpl;
import org.eclipse.wst.common.project.facet.core.internal.RuntimeComponentTypeRef;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultFacetsExtensionPoint {
    public static final String EXTENSION_POINT_ID = "defaultFacets";
    private static final String ATTR_ID = "id";
    private static final String ATTR_VERSION = "version";
    private static final String EL_CONTEXT = "context";
    private static final String EL_DEFAULT_FACETS = "default-facets";
    private static final String EL_FACET = "facet";
    private static final String EL_FIXED_FACET = "fixed-facet";
    private static final String EL_RUNTIME_COMPONENT = "runtime-component";
    private static List<DefaultFacetsExtension> extensions = null;

    public static Set<IProjectFacetVersion> getDefaultFacets(IFacetedProjectBase fproj) throws CoreException {
        DefaultFacetsExtensionPoint.readExtensions();
        Set<IProjectFacet> fixed = fproj.getFixedProjectFacets();
        IRuntime runtime = fproj.getPrimaryRuntime();
        HashMap<IProjectFacet, IProjectFacetVersion> facets = new HashMap<IProjectFacet, IProjectFacetVersion>();
        for (DefaultFacetsExtension extension : extensions) {
            if (!extension.match(fproj)) continue;
            for (IProjectFacetVersion iProjectFacetVersion : extension.getProjectFacets()) {
                facets.put(iProjectFacetVersion.getProjectFacet(), iProjectFacetVersion);
            }
        }
        HashSet<IProjectFacet> toRemove = new HashSet<IProjectFacet>();
        for (IProjectFacetVersion fv : facets.values()) {
            if (fv.isValidFor(fixed)) continue;
            toRemove.add(fv.getProjectFacet());
        }
        for (IProjectFacet f : toRemove) {
            facets.remove(f);
        }
        HashMap<IProjectFacet, IProjectFacetVersion> toadd = null;
        for (IProjectFacet iProjectFacet : fixed) {
            if (facets.containsKey(iProjectFacet)) continue;
            if (toadd == null) {
                toadd = new HashMap<IProjectFacet, IProjectFacetVersion>();
            }
            IProjectFacetVersion fv = runtime != null ? iProjectFacet.getLatestSupportedVersion(runtime) : iProjectFacet.getDefaultVersion();
            toadd.put(iProjectFacet, fv);
        }
        if (toadd != null) {
            facets.putAll(toadd);
        }
        return Collections.unmodifiableSet(new HashSet(facets.values()));
    }

    private static synchronized void readExtensions() {
        if (extensions != null) {
            return;
        }
        extensions = new ArrayList<DefaultFacetsExtension>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", EXTENSION_POINT_ID))) {
            if (!element.getName().equals(EL_DEFAULT_FACETS)) continue;
            try {
                DefaultFacetsExtensionPoint.readExtension(element);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    private static void readExtension(IConfigurationElement config) throws PluginUtil.InvalidExtensionException {
        String pluginId = config.getContributor().getName();
        DefaultFacetsExtension extension = new DefaultFacetsExtension();
        IConfigurationElement[] iConfigurationElementArray = config.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String childName = child.getName();
            if (childName.equals(EL_RUNTIME_COMPONENT)) {
                RuntimeComponentTypeRef rctRef = RuntimeComponentTypeRef.read(child);
                if (rctRef == null) {
                    throw new PluginUtil.InvalidExtensionException();
                }
                extension.addContext(rctRef);
            } else if (childName.equals(EL_CONTEXT)) {
                IConfigurationElement[] iConfigurationElementArray2 = child.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement contextChild = iConfigurationElementArray2[n4];
                    String contextChildName = contextChild.getName();
                    if (contextChildName.equals(EL_RUNTIME_COMPONENT)) {
                        RuntimeComponentTypeRef rctRef = RuntimeComponentTypeRef.read(contextChild);
                        if (rctRef == null) {
                            throw new PluginUtil.InvalidExtensionException();
                        }
                        extension.addContext(rctRef);
                    } else if (contextChildName.equals(EL_FIXED_FACET)) {
                        String fid = contextChild.getAttribute(ATTR_ID);
                        if (!ProjectFacetsManager.isProjectFacetDefined(fid)) {
                            FacetedProjectFrameworkImpl.reportMissingFacet(fid, pluginId);
                            throw new PluginUtil.InvalidExtensionException();
                        }
                        IProjectFacet f = ProjectFacetsManager.getProjectFacet(fid);
                        extension.addContext(f);
                    }
                    ++n4;
                }
            } else if (childName.equals(EL_FACET)) {
                String fid = child.getAttribute(ATTR_ID);
                if (!ProjectFacetsManager.isProjectFacetDefined(fid)) {
                    PluginUtil.reportMissingAttribute(child, ATTR_ID);
                    throw new PluginUtil.InvalidExtensionException();
                }
                IProjectFacet f = ProjectFacetsManager.getProjectFacet(fid);
                String ver = child.getAttribute(ATTR_VERSION);
                if (ver == null) {
                    PluginUtil.reportMissingAttribute(child, ATTR_VERSION);
                    throw new PluginUtil.InvalidExtensionException();
                }
                if (!f.hasVersion(ver)) {
                    String msg = NLS.bind((String)FacetedProjectFrameworkImpl.Resources.facetVersionNotDefined, (Object)f.getId(), (Object)ver);
                    msg = String.valueOf(msg) + NLS.bind((String)FacetedProjectFrameworkImpl.Resources.usedInPlugin, (Object)pluginId);
                    FacetCorePlugin.log(msg);
                    throw new PluginUtil.InvalidExtensionException();
                }
                extension.addProjectFacet(f.getVersion(ver));
            }
            ++n2;
        }
        extensions.add(extension);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultFacetsExtension {
        private Set<IProjectFacet> contextFixedFacets = new HashSet<IProjectFacet>();
        private Set<RuntimeComponentTypeRef> contextRuntimeComponentTypes = new HashSet<RuntimeComponentTypeRef>();
        private final Set<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>();

        private DefaultFacetsExtension() {
        }

        public void addContext(IProjectFacet facet) {
            this.contextFixedFacets.add(facet);
        }

        public void addContext(RuntimeComponentTypeRef runtimeComponentTypeRef) {
            this.contextRuntimeComponentTypes.add(runtimeComponentTypeRef);
        }

        public Set<IProjectFacetVersion> getProjectFacets() {
            return this.facets;
        }

        public void addProjectFacet(IProjectFacetVersion fv) {
            this.facets.add(fv);
        }

        public boolean match(IFacetedProjectBase fproj) {
            Set<IProjectFacet> fixedFacets;
            if (!this.contextFixedFacets.isEmpty() && !(fixedFacets = fproj.getFixedProjectFacets()).containsAll(this.contextFixedFacets)) {
                return false;
            }
            if (!this.contextRuntimeComponentTypes.isEmpty()) {
                IRuntime runtime = fproj.getPrimaryRuntime();
                if (runtime == null) {
                    return false;
                }
                for (RuntimeComponentTypeRef rctRef : this.contextRuntimeComponentTypes) {
                    boolean found = false;
                    for (IRuntimeComponent rc : runtime.getRuntimeComponents()) {
                        if (!rctRef.check(Collections.singleton(rc.getRuntimeComponentVersion()))) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

