/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.runtime.internal;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;
import org.eclipse.wst.common.project.facet.core.util.internal.UnknownVersion;
import org.eclipse.wst.common.project.facet.core.util.internal.Versionable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeComponentVersion
implements IRuntimeComponentVersion {
    private String plugin;
    private IRuntimeComponentType type;
    private String version;
    private final Map<String, Object> adapterFactories = new HashMap<String, Object>();
    private Map<IRuntimeComponentVersion, Integer> compTable = null;

    public String getPluginId() {
        return this.plugin;
    }

    void setPluginId(String plugin) {
        this.plugin = plugin;
    }

    @Override
    public IRuntimeComponentType getRuntimeComponentType() {
        return this.type;
    }

    void setRuntimeComponentType(IRuntimeComponentType type) {
        this.type = type;
    }

    @Override
    public String getVersionString() {
        return this.version;
    }

    void setVersionString(String version) {
        this.version = version;
    }

    public Versionable getVersionable() {
        return (Versionable)((Object)this.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAdapterFactory getAdapterFactory(Class type) throws CoreException {
        Map<String, Object> map = this.adapterFactories;
        synchronized (map) {
            Object factory;
            block5: {
                factory = this.adapterFactories.get(type.getName());
                if (factory != null) break block5;
                return null;
            }
            if (factory instanceof PluginAndClass) {
                PluginAndClass ref = (PluginAndClass)factory;
                factory = PluginUtil.instantiate(ref.plugin, ref.clname, IAdapterFactory.class);
                this.adapterFactories.put(type.getName(), factory);
            }
            return (IAdapterFactory)factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAdapterFactory(String type, String plugin, String factory) {
        Map<String, Object> map = this.adapterFactories;
        synchronized (map) {
            this.adapterFactories.put(type, new PluginAndClass(plugin, factory));
        }
    }

    void setComparisonTable(Map<IRuntimeComponentVersion, Integer> compTable) {
        this.compTable = compTable;
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof IRuntimeComponentVersion) {
            IRuntimeComponentVersion rcv = (IRuntimeComponentVersion)obj;
            if (rcv.getRuntimeComponentType() != this.type) {
                String msg = Resources.bind(Resources.cannotCompareVersionsOfDifferentTypes, this.type.getId(), this.version, rcv.getRuntimeComponentType().getId(), rcv.getVersionString());
                throw new RuntimeException(msg);
            }
            return this.compTable.get(rcv);
        }
        if (obj instanceof UnknownVersion) {
            try {
                Comparator<String> comp = this.type.getVersionComparator();
                return comp.compare(this.version, ((IVersion)obj).getVersionString());
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return String.valueOf(this.type.getId()) + " " + this.version;
    }

    private static final class PluginAndClass {
        public final String plugin;
        public final String clname;

        public PluginAndClass(String plugin, String clname) {
            this.plugin = plugin;
            this.clname = clname;
        }
    }

    private static final class Resources
    extends NLS {
        public static String cannotCompareVersionsOfDifferentTypes;

        static {
            Resources.initializeMessages((String)RuntimeComponentVersion.class.getName(), Resources.class);
        }

        private Resources() {
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3});
        }

        public static String bind(String template, Object arg1, Object arg2, Object arg3, Object arg4) {
            return NLS.bind((String)template, (Object[])new Object[]{arg1, arg2, arg3, arg4});
        }
    }
}

