/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.metadata.internal.ResourceBundleHelper;
import org.eclipse.jst.jsf.common.metadata.internal.StandardMetaDataSourceFileLocator;
import org.osgi.framework.Bundle;

public class PluginRelativeStandardMetaDataSourceFileLocator
extends StandardMetaDataSourceFileLocator {
    private ResourceBundle resourceBundle;

    public InputStream getInputStream() throws IOException {
        URL url = this.getURL();
        if (url != null) {
            return url.openStream();
        }
        String fileName = String.valueOf(Path.fromOSString((String)this.fileInfo.getLocation()).toString()) + " (Plugin: " + this.fileInfo.getBundleId() + ")";
        throw new FileNotFoundException("Metadata file not found: " + fileName);
    }

    public URL getURL() {
        return FileLocator.find((Bundle)Platform.getBundle((String)this.fileInfo.getBundleId()), (IPath)Path.fromOSString((String)this.fileInfo.getLocation()), null);
    }

    public ResourceBundle getResourceBundle() throws IOException, MalformedURLException {
        if (this.resourceBundle == null) {
            URL bundleURL = this.getStandardMetaDataSourceFileBasenameURL();
            if (bundleURL == null) {
                return null;
            }
            this.resourceBundle = ResourceBundleHelper.getResourceBundle(bundleURL);
        }
        return this.resourceBundle;
    }

    private URL getStandardMetaDataSourceFileBasenameURL() {
        IPath propertiesLocation;
        IPath annotationPath = Path.fromOSString((String)this.fileInfo.getLocation());
        IPath annotationFolder = annotationPath.removeLastSegments(1);
        IPath propertiesFile = annotationFolder.append(propertiesLocation = annotationPath.removeFirstSegments(annotationPath.segmentCount() - 1).removeFileExtension());
        if (propertiesFile.getFileExtension() == null) {
            propertiesFile = propertiesFile.addFileExtension("properties");
        }
        return FileLocator.find((Bundle)Platform.getBundle((String)this.fileInfo.getBundleId()), (IPath)propertiesFile, null);
    }
}

