/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jst.j2ee.ejb.internal.operations.CreateEnterpriseBeanTemplateModel;
import org.eclipse.jst.j2ee.ejb.internal.operations.DestinationType;
import org.eclipse.jst.j2ee.internal.common.operations.Method;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateMessageDrivenBeanTemplateModel
extends CreateEnterpriseBeanTemplateModel {
    public static final String QUALIFIED_ACTIVATION_CONFIG_PROPERTY = "javax.ejb.ActivationConfigProperty";
    public static final String QUALIFIED_TRANSACTION_MANAGEMENT = "javax.ejb.TransactionManagement";
    public static final String QUALIFIED_TRANSACTION_MANAGEMENT_TYPE = "javax.ejb.TransactionManagementType";
    public static final String QUALIFIED_JSM_MESSAGE = "javax.jms.Message";
    public static final String QUALIFIED_MESSAGE_DRIVEN = "javax.ejb.MessageDriven";
    public static final String ATT_ACTIVATION_CONFIG = "activationConfig";
    public static final String ON_MESSAGE = "onMessage";
    public static final String ON_MESSAGE_SIGNATURE = "(Ljavax/jms/Message;)V";

    public CreateMessageDrivenBeanTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    public Collection<String> getImports() {
        Collection collection = super.getImports();
        collection.add(QUALIFIED_MESSAGE_DRIVEN);
        if (this.isJMS()) {
            collection.add(QUALIFIED_ACTIVATION_CONFIG_PROPERTY);
            collection.add("javax.jms.MessageListener");
            collection.add(QUALIFIED_JSM_MESSAGE);
        }
        if (!this.isContainerType()) {
            collection.add(QUALIFIED_TRANSACTION_MANAGEMENT);
            collection.add(QUALIFIED_TRANSACTION_MANAGEMENT_TYPE);
        }
        return collection;
    }

    public Map<String, String> getClassAnnotationParams() {
        String mappedName;
        String dispName;
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isJMS()) {
            if (this.dataModel.getProperty("INewMessageDrivenBeanClassDataModelProperties.DESTINATION_TYPE") == DestinationType.QUEUE) {
                result.put(ATT_ACTIVATION_CONFIG, "javax.jms.Queue");
            } else {
                result.put(ATT_ACTIVATION_CONFIG, "javax.jms.Topic");
            }
        }
        if (!(dispName = this.getProperty("INewEnterpriseBeanClassDataModelProperties.EJB_NAME")).equals(this.getClassName())) {
            result.put("name", "\"" + dispName + "\"");
        }
        if ((mappedName = this.getProperty("INewEnterpriseBeanClassDataModelProperties.MAPPED_NAME").trim()) != null && mappedName.length() > 0) {
            result.put("mappedName", "\"" + mappedName + "\"");
        }
        return result;
    }

    public boolean isJMS() {
        return this.dataModel.getBooleanProperty("INewMessageDrivenBeanClassDataModelProperties.JMS");
    }

    public Collection<Method> getUnimplementedMethods() {
        Collection unimplementedMethods = super.getUnimplementedMethods();
        Iterator iterator = unimplementedMethods.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!ON_MESSAGE.equals(method.getName()) || !ON_MESSAGE_SIGNATURE.equals(method.getSignature())) continue;
            iterator.remove();
        }
        return unimplementedMethods;
    }
}

