/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterface;
import org.eclipse.jst.j2ee.ejb.internal.operations.CreateEnterpriseBeanTemplateModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSessionBeanTemplateModel
extends CreateEnterpriseBeanTemplateModel {
    public static final String QUALIFIED_STATELESS = "javax.ejb.Stateless";
    public static final String QUALIFIED_STATEFUL = "javax.ejb.Stateful";
    public static final String QUALIFIED_LOCAL = "javax.ejb.Local";
    public static final String QUALIFIED_REMOTE = "javax.ejb.Remote";
    public static final String QUALIFIED_REMOTE_HOME = "javax.ejb.RemoteHome";
    public static final String QUALIFIED_LOCAL_HOME = "javax.ejb.LocalHome";
    public static final String QUALIFIED_TRANSACTION_MANAGEMENT = "javax.ejb.TransactionManagement";
    public static final String QUALIFIED_TRANSACTION_MANAGEMENT_TYPE = "javax.ejb.TransactionManagementType";
    public static final String STATELESS_ANNOTATION = "@Stateless";
    public static final String STATEFUL_ANNOTATION = "@Stateful";
    protected BusinessInterface currentBusinessInterface = null;
    protected String localHomeClassName = null;
    protected String remoteHomeClassName = null;

    public CreateSessionBeanTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    public Collection<String> getImports() {
        Collection collection = super.getImports();
        int stateType = this.dataModel.getIntProperty("INewSessionBeanClassDataModelProperties.STATE_TYPE");
        if (stateType == 0) {
            collection.add(QUALIFIED_STATELESS);
        } else if (stateType == 1) {
            collection.add(QUALIFIED_STATEFUL);
        } else {
            throw new IllegalStateException("illegal state type: " + stateType);
        }
        if (!this.isContainerType()) {
            collection.add(QUALIFIED_TRANSACTION_MANAGEMENT);
            collection.add(QUALIFIED_TRANSACTION_MANAGEMENT_TYPE);
        }
        if (this.isRemoteHomeChecked()) {
            collection.add(QUALIFIED_REMOTE_HOME);
            collection.add(this.remoteHomeClassName);
        }
        if (this.isLocalHomeChecked()) {
            collection.add(QUALIFIED_LOCAL_HOME);
            collection.add(this.localHomeClassName);
        }
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            if (iface.isLocal() && iface.exists()) {
                collection.add(QUALIFIED_LOCAL);
                continue;
            }
            if (!iface.isRemote() || !iface.exists()) continue;
            collection.add(QUALIFIED_REMOTE);
        }
        return collection;
    }

    public List<String> getQualifiedInterfaces() {
        ArrayList<String> result = new ArrayList<String>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            result.add(iface.getFullyQualifiedName());
        }
        return result;
    }

    public String getClassAnnotation() {
        String beanType;
        int stateType = this.dataModel.getIntProperty("INewSessionBeanClassDataModelProperties.STATE_TYPE");
        if (stateType == 0) {
            beanType = STATELESS_ANNOTATION;
        } else if (stateType == 1) {
            beanType = STATEFUL_ANNOTATION;
        } else {
            throw new IllegalStateException("illegal state type: " + stateType);
        }
        return beanType;
    }

    public List<BusinessInterface> getBusinessInterfaces() {
        return (List)this.dataModel.getProperty("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
    }

    public List<BusinessInterface> getExistingLocalBusinessInterfaces() {
        ArrayList<BusinessInterface> result = new ArrayList<BusinessInterface>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            if (!iface.isLocal() || !iface.exists()) continue;
            result.add(iface);
        }
        return result;
    }

    public List<BusinessInterface> getExistingRemoteBusinessInterfaces() {
        ArrayList<BusinessInterface> result = new ArrayList<BusinessInterface>();
        List<BusinessInterface> interfaces = this.getBusinessInterfaces();
        for (BusinessInterface iface : interfaces) {
            if (!iface.isRemote() || !iface.exists()) continue;
            result.add(iface);
        }
        return result;
    }

    public boolean isLocalHomeChecked() {
        return this.dataModel.getBooleanProperty("INewSessionBeanClassDataModelProperties.LOCAL_HOME");
    }

    public boolean isRemoteHomeChecked() {
        return this.dataModel.getBooleanProperty("INewSessionBeanClassDataModelProperties.REMOTE_HOME");
    }

    public Map<String, String> getClassAnnotationParams() {
        String mappedName;
        Hashtable<String, String> result = new Hashtable<String, String>();
        String dispName = this.getProperty("INewEnterpriseBeanClassDataModelProperties.EJB_NAME");
        if (!dispName.equals(this.getClassName())) {
            result.put("name", dispName);
        }
        if ((mappedName = this.getProperty("INewEnterpriseBeanClassDataModelProperties.MAPPED_NAME").trim()) != null && mappedName.length() > 0) {
            result.put("mappedName", mappedName);
        }
        return result;
    }

    public void setCurrentBusinessInterface(BusinessInterface newBI) {
        this.currentBusinessInterface = newBI;
    }

    public String getBusinessInterfaceJavaPackageName() {
        String packageName = null;
        if (this.currentBusinessInterface != null) {
            packageName = Signature.getQualifier((String)this.currentBusinessInterface.getFullyQualifiedName());
        }
        return packageName;
    }

    public String getBusinessInterfaceClassName() {
        String className = null;
        if (this.currentBusinessInterface != null) {
            className = this.currentBusinessInterface.getSimpleName();
        }
        return className;
    }

    public String getLocalHomePackage() {
        return Signature.getQualifier((String)this.localHomeClassName);
    }

    public String getLocalHomeClassSimpleName() {
        return Signature.getSimpleName((String)this.localHomeClassName);
    }

    public void setLocalHomeClassName(String localHomeClassName) {
        this.localHomeClassName = localHomeClassName;
    }

    public String getRemoteHomePackage() {
        return Signature.getQualifier((String)this.remoteHomeClassName);
    }

    public String getRemoteHomeClassSimpleName() {
        return Signature.getSimpleName((String)this.remoteHomeClassName);
    }

    public void setRemoteHomeClassName(String remoteHomeClassName) {
        this.remoteHomeClassName = remoteHomeClassName;
    }
}

