/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.ejb.internal.operations.AddSessionBeanOperation;
import org.eclipse.jst.j2ee.ejb.internal.operations.BusinessInterface;
import org.eclipse.jst.j2ee.ejb.internal.operations.NewEnterpriseBeanClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewSessionBeanClassDataModelProvider
extends NewEnterpriseBeanClassDataModelProvider {
    public static final int STATE_TYPE_STATELESS_INDEX = 0;
    public static final int STATE_TYPE_STATEFUL_INDEX = 1;
    private static final String LOCAL_SUFFIX = "Local";
    private static final String REMOTE_SUFFIX = "Remote";
    private static final String LOCAL_HOME_SUFFIX = "LocalHome";
    private static final String REMOTE_HOME_SUFFIX = "Home";

    public IDataModelOperation getDefaultOperation() {
        return new AddSessionBeanOperation(this.getDataModel());
    }

    @Override
    public Set<String> getPropertyNames() {
        Set<String> propertyNames = super.getPropertyNames();
        propertyNames.add("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL");
        propertyNames.add("INewSessionBeanClassDataModelProperties.STATE_TYPE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE_HOME");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL_HOME");
        propertyNames.add("INewSessionBeanClassDataModelProperties.REMOTE_HOME_INTERFACE");
        propertyNames.add("INewSessionBeanClassDataModelProperties.LOCAL_HOME_INTERFACE");
        return propertyNames;
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE_HOME")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL_HOME")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.STATE_TYPE")) {
            return 0;
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES")) {
            ArrayList<BusinessInterface> listResult = new ArrayList<BusinessInterface>();
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            if (((Boolean)this.getProperty("INewSessionBeanClassDataModelProperties.REMOTE")).booleanValue() && className.length() > 0) {
                BusinessInterface remoteInterface = new BusinessInterface(this.getStringProperty("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE"), BusinessInterface.BusinessInterfaceType.REMOTE);
                listResult.add(remoteInterface);
            }
            if (((Boolean)this.getProperty("INewSessionBeanClassDataModelProperties.LOCAL")).booleanValue() && className.length() > 0) {
                BusinessInterface localInterface = new BusinessInterface(this.getStringProperty("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE"), BusinessInterface.BusinessInterfaceType.LOCAL);
                listResult.add(localInterface);
            }
            return listResult;
        }
        if ("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            return String.valueOf(className) + REMOTE_SUFFIX;
        }
        if ("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            return String.valueOf(className) + LOCAL_SUFFIX;
        }
        if ("INewSessionBeanClassDataModelProperties.REMOTE_HOME_INTERFACE".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            return String.valueOf(className) + REMOTE_HOME_SUFFIX;
        }
        if ("INewSessionBeanClassDataModelProperties.LOCAL_HOME_INTERFACE".equals(propertyName)) {
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            return String.valueOf(className) + LOCAL_HOME_SUFFIX;
        }
        return super.getDefaultProperty(propertyName);
    }

    @Override
    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean result = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE")) {
            if (!this.getDataModel().isPropertySet("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES")) {
                this.getDataModel().notifyPropertyChange("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES", 2);
                this.getDataModel().notifyPropertyChange("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE", 2);
            } else {
                this.updateBusinessInterfaces("INewSessionBeanClassDataModelProperties.REMOTE");
            }
        }
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL") && !this.getDataModel().isPropertySet("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES")) {
            this.getDataModel().notifyPropertyChange("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES", 2);
            this.getDataModel().notifyPropertyChange("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE", 2);
        }
        if ("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE".equals(propertyName)) {
            this.getRemoteProperty().setFullyQualifiedName(propertyValue.toString());
        } else if ("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE".equals(propertyName)) {
            this.getLocalProperty().setFullyQualifiedName(propertyName);
        } else if ("NewJavaClassDataModel.CLASS_NAME".equals(propertyName) || "NewJavaClassDataModel.JAVA_PACKAGE".equals(propertyName)) {
            BusinessInterface localInterface;
            IDataModel dataModel = this.getDataModel();
            String className = this.getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            BusinessInterface remoteInterface = this.getRemoteProperty();
            if (remoteInterface != null) {
                remoteInterface.setFullyQualifiedName(String.valueOf(className) + REMOTE_SUFFIX);
                dataModel.notifyPropertyChange("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE", 2);
            }
            if ((localInterface = this.getLocalProperty()) != null) {
                localInterface.setFullyQualifiedName(String.valueOf(className) + LOCAL_SUFFIX);
                dataModel.notifyPropertyChange("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE", 2);
            }
            dataModel.notifyPropertyChange("INewSessionBeanClassDataModelProperties.REMOTE_HOME_INTERFACE", 2);
            dataModel.notifyPropertyChange("INewSessionBeanClassDataModelProperties.LOCAL_HOME_INTERFACE", 2);
        }
        return result;
    }

    private void updateBusinessInterfaces(String propertyName) {
        List list = (List)this.getProperty("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
        if (propertyName.equals("INewSessionBeanClassDataModelProperties.REMOTE")) {
            if (this.getBooleanProperty(propertyName)) {
                list.add(new BusinessInterface(this.getStringProperty("INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE"), BusinessInterface.BusinessInterfaceType.REMOTE));
            } else {
                BusinessInterface remoteInterface = this.getRemoteProperty();
                int indexOf = list.indexOf(remoteInterface);
                list.remove(indexOf);
            }
        } else if (propertyName.equals("INewSessionBeanClassDataModelProperties.LOCAL")) {
            if (this.getBooleanProperty(propertyName)) {
                Signature.getSimpleName((String)this.getStringProperty("NewJavaClassDataModel.CLASS_NAME"));
                list.add(new BusinessInterface(this.getStringProperty("INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE"), BusinessInterface.BusinessInterfaceType.LOCAL));
            } else {
                BusinessInterface localInterface = this.getLocalProperty();
                int indexOf = list.indexOf(localInterface);
                list.remove(indexOf);
            }
        }
    }

    private BusinessInterface getRemoteProperty() {
        List businessInterfaces = (List)this.getProperty("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
        for (BusinessInterface iface : businessInterfaces) {
            if (iface.getJavaType() != null || !iface.isRemote()) continue;
            return iface;
        }
        return null;
    }

    private BusinessInterface getLocalProperty() {
        List businessInterfaces = (List)this.getProperty("INewSessionBeanClassDataModelProperties.BUSINESS_INTERFACES");
        for (BusinessInterface iface : businessInterfaces) {
            if (iface.getJavaType() != null || !iface.isLocal()) continue;
            return iface;
        }
        return null;
    }

    @Override
    public IStatus validate(String propertyName) {
        String value;
        IStatus currentStatus = null;
        if (("INewSessionBeanClassDataModelProperties.LOCAL_HOME_INTERFACE".equals(propertyName) || "INewSessionBeanClassDataModelProperties.REMOTE_HOME_INTERFACE".equals(propertyName) || "INewSessionBeanClassDataModelProperties.LOCAL_BUSINESS_INTERFACE".equals(propertyName) || "INewSessionBeanClassDataModelProperties.REMOTE_BUSINESS_INTERFACE".equals(propertyName)) && !(currentStatus = this.validateJavaTypeName(value = this.getStringProperty(propertyName))).isOK()) {
            return currentStatus;
        }
        return super.validate(propertyName);
    }

    protected IStatus validateJavaTypeName(String className) {
        IStatus javaStatus = JavaConventions.validateJavaTypeName((String)className);
        if (javaStatus.getSeverity() == 4) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_CLASS_NAME_INVALID) + javaStatus.getMessage();
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        if (javaStatus.getSeverity() == 2) {
            String msg = String.valueOf(J2EECommonMessages.ERR_JAVA_CLASS_NAME_WARNING) + javaStatus.getMessage();
            return WTPCommonPlugin.createWarningStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

