/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.editors;

import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JpaUiFactory;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaPageComposite;
import org.eclipse.jpt.ui.internal.persistence.JptUiPersistenceMessages;
import org.eclipse.jpt.ui.internal.platform.JpaPlatformUiRegistry;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.FormWidgetFactory;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceEditor
extends FormEditor {
    private TextEditor editor;
    private WritablePropertyValueModel<IFileEditorInput> editorInputHolder;
    private IResourceChangeListener resourceChangeListener;
    private WidgetFactory widgetFactory;

    public PersistenceEditor() {
        this.initialize();
    }

    protected void addPages() {
        this.addPersistenceUnitPages();
        this.addXMLEditorPage();
    }

    private void addPersistenceUnitPages() {
        JpaProject jpaProject = this.jpaProject();
        String platformId = jpaProject.getJpaPlatform().getId();
        JpaPlatformUi jpaPlatformUI = JpaPlatformUiRegistry.instance().jpaPlatform(platformId);
        JpaUiFactory uiFactory = jpaPlatformUI.getJpaUiFactory();
        ListIterator<JpaPageComposite<PersistenceUnit>> pages = uiFactory.createPersistenceUnitComposites(this.buildPersistenceUnitHolder(), this.getContainer(), this.widgetFactory);
        while (pages.hasNext()) {
            JpaPageComposite<PersistenceUnit> page = pages.next();
            try {
                Page formPage = new Page(page);
                this.addPage((IFormPage)formPage);
            }
            catch (PartInitException partInitException) {}
        }
    }

    private void addXMLEditorPage() {
        try {
            this.editor = new StructuredTextEditor();
            int index = this.addPage((IEditorPart)this.editor, (IEditorInput)this.getEditorInput());
            this.setPageText(index, JptUiPersistenceMessages.PersistenceEditor_sourceTab);
        }
        catch (PartInitException partInitException) {}
    }

    private WritablePropertyValueModel<IFileEditorInput> buildEditorInputHolder() {
        return new SimplePropertyValueModel();
    }

    private PropertyValueModel<JpaProject> buildJpaProjectHolder() {
        return new TransformationPropertyValueModel<IFileEditorInput, JpaProject>(this.editorInputHolder){

            protected JpaProject transform_(IFileEditorInput value) {
                return JptCorePlugin.getJpaProject((IProject)value.getFile().getProject());
            }
        };
    }

    private PropertyValueModel<Persistence> buildPersistenceHolder() {
        return new PropertyAspectAdapter<PersistenceXml, Persistence>(this.buildPersistenceXmlHolder(), new String[]{"persistence"}){

            protected Persistence buildValue_() {
                return ((PersistenceXml)this.subject).getPersistence();
            }
        };
    }

    private PropertyValueModel<PersistenceUnit> buildPersistenceUnitHolder() {
        return new ListPropertyValueModelAdapter<PersistenceUnit>(this.buildPersistenceUnitListHolder()){

            protected PersistenceUnit buildValue() {
                return this.listHolder.size() > 0 ? (PersistenceUnit)this.listHolder.get(0) : null;
            }
        };
    }

    private ListValueModel<PersistenceUnit> buildPersistenceUnitListHolder() {
        return new ListAspectAdapter<Persistence, PersistenceUnit>(this.buildPersistenceHolder(), new String[]{"persistenceUnits"}){

            protected ListIterator<PersistenceUnit> listIterator_() {
                return ((Persistence)this.subject).persistenceUnits();
            }

            protected int size_() {
                return ((Persistence)this.subject).persistenceUnitsSize();
            }
        };
    }

    private PropertyValueModel<PersistenceXml> buildPersistenceXmlHolder() {
        return new PropertyAspectAdapter<JpaRootContextNode, PersistenceXml>(this.buildRootContextNodeHolder(), new String[]{"persistenceXml"}){

            protected PersistenceXml buildValue_() {
                return ((JpaRootContextNode)this.subject).getPersistenceXml();
            }
        };
    }

    private IResourceChangeListener buildResourceChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(final IResourceChangeEvent event) {
                if (event.getType() == 2) {
                    SWTUtil.asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchPage[] pages = PersistenceEditor.this.getSite().getWorkbenchWindow().getPages();
                            int index = 0;
                            while (index < pages.length) {
                                IFileEditorInput fileEditorInput = (IFileEditorInput)PersistenceEditor.this.editor.getEditorInput();
                                if (fileEditorInput.getFile().getProject().equals((Object)event.getResource())) {
                                    IEditorPart editorPart = pages[index].findEditor(PersistenceEditor.this.editor.getEditorInput());
                                    pages[index].closeEditor(editorPart, true);
                                }
                                ++index;
                            }
                        }
                    });
                }
            }
        };
    }

    private PropertyValueModel<JpaRootContextNode> buildRootContextNodeHolder() {
        return new TransformationPropertyValueModel<JpaProject, JpaRootContextNode>(this.buildJpaProjectHolder()){

            protected JpaRootContextNode transform_(JpaProject value) {
                return value.getRootContext();
            }
        };
    }

    private WidgetFactory buildWidgetFactory() {
        return new FormWidgetFactory((FormToolkit)new TabbedPropertySheetWidgetFactory());
    }

    public void close(boolean save) {
        super.close(save);
        this.editorInputHolder.setValue(null);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.resourceChangeListener = null;
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(this.getPageCount() - 1).doSave(monitor);
    }

    public void doSaveAs() {
    }

    public IFileEditorInput getEditorInput() {
        return (IFileEditorInput)super.getEditorInput();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        Assert.isLegal((boolean)(editorInput instanceof IFileEditorInput), (String)"Invalid Input: Must be IFileEditorInput");
        super.init(site, editorInput);
        this.editorInputHolder.setValue((Object)this.getEditorInput());
    }

    private void initialize() {
        this.editorInputHolder = this.buildEditorInputHolder();
        this.widgetFactory = this.buildWidgetFactory();
        this.resourceChangeListener = this.buildResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected JpaProject jpaProject() {
        return JptCorePlugin.getJpaProject((IProject)this.getEditorInput().getFile().getProject());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Page
    extends FormPage {
        private final JpaPageComposite<PersistenceUnit> page;

        private Page(JpaPageComposite<PersistenceUnit> page) {
            super((FormEditor)PersistenceEditor.this, page.getClass().getName(), page.getPageText());
            this.page = page;
        }

        protected void createFormContent(IManagedForm managedForm) {
            ScrolledForm form = managedForm.getForm();
            managedForm.getToolkit().decorateFormHeading(form.getForm());
            this.updateForm(form);
            Composite body = form.getBody();
            body.setLayout((Layout)new GridLayout(1, false));
            this.updateGridData(body);
            this.page.getControl().setParent(body);
            this.updateHelpButton();
            form.updateToolBar();
            this.page.populate();
        }

        public void dispose() {
            this.page.dispose();
            super.dispose();
        }

        public void setFocus() {
            this.page.getControl().setFocus();
        }

        private void updateForm(ScrolledForm form) {
            form.setText(this.page.getPageText());
            Image image = this.page.getPageImage();
            if (image != null) {
                form.setImage(image);
            }
        }

        private void updateGridData(Composite container) {
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            container.setLayoutData((Object)gridData);
        }

        private void updateHelpButton() {
            String helpID = this.page.getHelpID();
            if (helpID != null) {
                HelpAction helpAction = new HelpAction(helpID);
                ScrolledForm form = this.getManagedForm().getForm();
                IToolBarManager manager = form.getToolBarManager();
                manager.add((IAction)helpAction);
            }
        }

        private class HelpAction
        extends Action {
            private final String helpID;

            HelpAction(String helpID) {
                super(JptUiPersistenceMessages.PersistenceEditor_page_help, JFaceResources.getImageRegistry().getDescriptor("dialog_help_image"));
                this.helpID = helpID;
            }

            public void run() {
                BusyIndicator.showWhile((Display)Page.this.getManagedForm().getForm().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(HelpAction.this.helpID);
                    }
                });
            }
        }
    }
}

