/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.jface;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jpt.ui.internal.jface.DelegatingTreeContentAndLabelProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProvider;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.NullListValueModel;
import org.eclipse.jpt.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeItemContentProvider<E>
implements TreeItemContentProvider {
    private DelegatingTreeContentAndLabelProvider treeContentProvider;
    private Model model;
    private ListValueModel<E> childrenModel;
    private ListChangeListener childrenListener;

    protected AbstractTreeItemContentProvider(Model model, DelegatingTreeContentAndLabelProvider treeContentProvider) {
        this.model = model;
        this.treeContentProvider = treeContentProvider;
        this.childrenListener = this.buildChildrenListener();
    }

    protected ListChangeListener buildChildrenListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent event) {
                AbstractTreeItemContentProvider.this.treeContentProvider().updateContent(AbstractTreeItemContentProvider.this.model());
            }

            public void itemsMoved(ListChangeEvent event) {
                AbstractTreeItemContentProvider.this.treeContentProvider().updateContent(AbstractTreeItemContentProvider.this.model());
            }

            public void itemsRemoved(ListChangeEvent event) {
                AbstractTreeItemContentProvider.this.treeContentProvider().updateContent(AbstractTreeItemContentProvider.this.model());
                ListIterator stream = event.items();
                while (stream.hasNext()) {
                    AbstractTreeItemContentProvider.this.treeContentProvider().dispose(stream.next());
                }
            }

            public void itemsReplaced(ListChangeEvent event) {
                AbstractTreeItemContentProvider.this.treeContentProvider().updateContent(AbstractTreeItemContentProvider.this.model());
                ListIterator stream = event.replacedItems();
                while (stream.hasNext()) {
                    AbstractTreeItemContentProvider.this.treeContentProvider().dispose(stream.next());
                }
            }

            public void listChanged(ListChangeEvent event) {
                AbstractTreeItemContentProvider.this.treeContentProvider().updateContent(AbstractTreeItemContentProvider.this.model());
            }

            public void listCleared(ListChangeEvent event) {
                AbstractTreeItemContentProvider.this.treeContentProvider().updateContent(AbstractTreeItemContentProvider.this.model());
            }
        };
    }

    protected ListValueModel<E> childrenModel() {
        if (this.childrenModel == null) {
            this.childrenModel = this.buildChildrenModel();
            this.engageChildren();
        }
        return this.childrenModel;
    }

    protected ListValueModel<E> buildChildrenModel() {
        return new NullListValueModel();
    }

    protected ListValueModel<E> buildChildrenModel(CollectionValueModel<E> childrenModel) {
        return new CollectionListValueModelAdapter(childrenModel);
    }

    protected ListValueModel<E> buildChildrenModel(PropertyValueModel<E> childrenModel) {
        return this.buildChildrenModel((CollectionValueModel<E>)new PropertyCollectionValueModelAdapter(childrenModel));
    }

    public Model model() {
        return this.model;
    }

    public DelegatingTreeContentAndLabelProvider treeContentProvider() {
        return this.treeContentProvider;
    }

    @Override
    public Object getParent() {
        return null;
    }

    @Override
    public Object[] getElements() {
        return this.getChildren();
    }

    @Override
    public Object[] getChildren() {
        return CollectionTools.array((Iterator)this.childrenModel().listIterator());
    }

    @Override
    public boolean hasChildren() {
        return this.childrenModel().listIterator().hasNext();
    }

    @Override
    public void dispose() {
        Object[] objectArray = this.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.treeContentProvider().dispose(child);
            ++n2;
        }
        this.disengageChildren();
    }

    protected void engageChildren() {
        this.childrenModel.addListChangeListener("list values", this.childrenListener);
    }

    protected void disengageChildren() {
        if (this.childrenModel != null) {
            this.childrenModel.removeListChangeListener("list values", this.childrenListener);
        }
    }
}

