/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.db;

import java.util.Iterator;
import org.eclipse.jpt.core.JpaNode;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Sequence;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.Tracing;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabaseObjectCombo<T extends JpaNode>
extends AbstractPane<T> {
    private CCombo combo;
    private ConnectionListener connectionListener;

    protected AbstractDatabaseObjectCombo(AbstractPane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected AbstractDatabaseObjectCombo(AbstractPane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected AbstractDatabaseObjectCombo(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    private ConnectionListener buildConnectionListener() {
        return new ConnectionListener(){

            public void aboutToClose(ConnectionProfile profile) {
                AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "aboutToClose");
            }

            public void catalogChanged(ConnectionProfile profile, final Catalog catalog) {
                SWTUtil.asyncExec(new Runnable(){

                    public void run() {
                        AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "catalogChanged: " + catalog.getName());
                        if (!AbstractDatabaseObjectCombo.this.getCombo().isDisposed()) {
                            AbstractDatabaseObjectCombo.this.catalogChanged(catalog);
                        }
                    }
                });
            }

            public void closed(ConnectionProfile profile) {
                SWTUtil.asyncExec(new Runnable(){

                    public void run() {
                        AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "closed");
                        if (!AbstractDatabaseObjectCombo.this.getCombo().isDisposed()) {
                            AbstractDatabaseObjectCombo.this.repopulate();
                        }
                    }
                });
            }

            public void columnChanged(ConnectionProfile profile, final Column column) {
                SWTUtil.asyncExec(new Runnable(){

                    public void run() {
                        AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "columnChanged: " + column.getName());
                        if (!AbstractDatabaseObjectCombo.this.getCombo().isDisposed()) {
                            AbstractDatabaseObjectCombo.this.columnChanged(column);
                        }
                    }
                });
            }

            public void databaseChanged(ConnectionProfile profile, Database database) {
                AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "databaseChanged");
            }

            public void foreignKeyChanged(ConnectionProfile profile, final ForeignKey foreignKey) {
                SWTUtil.asyncExec(new Runnable(){

                    public void run() {
                        AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "foreignKeyChanged: " + foreignKey.getName());
                        if (!AbstractDatabaseObjectCombo.this.getCombo().isDisposed()) {
                            AbstractDatabaseObjectCombo.this.foreignKeyChanged(foreignKey);
                        }
                    }
                });
            }

            public void modified(ConnectionProfile profile) {
                SWTUtil.asyncExec(new Runnable(){

                    public void run() {
                        AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "modified");
                        if (!AbstractDatabaseObjectCombo.this.getCombo().isDisposed()) {
                            AbstractDatabaseObjectCombo.this.repopulate();
                        }
                    }
                });
            }

            public boolean okToClose(ConnectionProfile profile) {
                AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "okToClose");
                return true;
            }

            public void opened(ConnectionProfile profile) {
                SWTUtil.asyncExec(new Runnable(){

                    public void run() {
                        AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "opened");
                        if (!AbstractDatabaseObjectCombo.this.getCombo().isDisposed()) {
                            AbstractDatabaseObjectCombo.this.repopulate();
                        }
                    }
                });
            }

            public void schemaChanged(ConnectionProfile profile, final Schema schema) {
                SWTUtil.asyncExec(new Runnable(){

                    public void run() {
                        AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "schemaChanged: " + schema.getName());
                        if (!AbstractDatabaseObjectCombo.this.getCombo().isDisposed()) {
                            AbstractDatabaseObjectCombo.this.schemaChanged(schema);
                        }
                    }
                });
            }

            public void sequenceChanged(ConnectionProfile profile, final Sequence sequence) {
                SWTUtil.asyncExec(new Runnable(){

                    public void run() {
                        AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "sequenceChanged: " + sequence.getName());
                        if (!AbstractDatabaseObjectCombo.this.getCombo().isDisposed()) {
                            AbstractDatabaseObjectCombo.this.sequenceChanged(sequence);
                        }
                    }
                });
            }

            public void tableChanged(ConnectionProfile profile, final Table table) {
                SWTUtil.asyncExec(new Runnable(){

                    public void run() {
                        AbstractDatabaseObjectCombo.this.log("/debug/ui/db", "tableChanged: " + table.getName());
                        if (!AbstractDatabaseObjectCombo.this.getCombo().isDisposed()) {
                            AbstractDatabaseObjectCombo.this.tableChanged(table);
                        }
                    }
                });
            }
        };
    }

    private ModifyListener buildModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CCombo combo;
                if (!AbstractDatabaseObjectCombo.this.isPopulating() && (combo = (CCombo)e.widget).getData("populating") == Boolean.FALSE) {
                    AbstractDatabaseObjectCombo.this.valueChanged(combo.getText());
                }
            }
        };
    }

    protected void buildSubject() {
    }

    protected void catalogChanged(Catalog catalog) {
    }

    private void clearDefaultValue() {
        if (this.combo.isFocusControl()) {
            this.setPopulating(true);
            try {
                this.combo.setText("");
            }
            finally {
                this.setPopulating(false);
            }
        }
    }

    protected void columnChanged(Column column) {
    }

    protected final ConnectionProfile connectionProfile() {
        JpaProject jpaProject = this.jpaProject();
        if (jpaProject != null) {
            return jpaProject.getConnectionProfile();
        }
        return null;
    }

    protected final Database database() {
        return this.connectionProfile().getDatabase();
    }

    protected abstract String defaultValue();

    @Override
    protected void disengageListeners(T subject) {
        super.disengageListeners(subject);
        JpaProject jpaProject = this.jpaProject();
        if (jpaProject != null) {
            jpaProject.getConnectionProfile().removeConnectionListener(this.connectionListener);
        }
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateCombo();
    }

    @Override
    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        if (!this.combo.isDisposed()) {
            this.combo.setEnabled(enabled);
        }
    }

    @Override
    protected void engageListeners(T subject) {
        super.engageListeners(subject);
        JpaProject jpaProject = this.jpaProject();
        if (jpaProject != null) {
            jpaProject.getConnectionProfile().addConnectionListener(this.connectionListener);
        }
    }

    protected void foreignKeyChanged(ForeignKey foreignKey) {
    }

    public final CCombo getCombo() {
        return this.combo;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.connectionListener = this.buildConnectionListener();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.combo = this.buildEditableCCombo(container);
        this.combo.addModifyListener(this.buildModifyListener());
        SWTUtil.attachDefaultValueHandler(this.combo);
    }

    protected boolean isBuildSubjectAllowed() {
        return false;
    }

    protected JpaProject jpaProject() {
        return this.subject() == null ? null : ((JpaNode)this.subject()).getJpaProject();
    }

    @Override
    protected void log(String flag, String message) {
        super.log(flag, message);
        if ("/debug/ui/db".equals(flag) && Tracing.booleanDebugOption("/debug/ui/db")) {
            Class<?> thisClass = this.getClass();
            String className = ClassTools.shortNameFor(thisClass);
            if (thisClass.isAnonymousClass()) {
                className = className.substring(0, className.indexOf(36));
                className = String.valueOf(className) + "->" + ClassTools.shortNameFor(thisClass.getSuperclass());
            }
            Tracing.log(String.valueOf(className) + ": " + message);
        }
    }

    private void populateCombo() {
        this.combo.removeAll();
        this.populateDefaultValue();
        ConnectionProfile connectionProfile = this.connectionProfile();
        if (connectionProfile != null && connectionProfile.isActive()) {
            Iterator iter = CollectionTools.sort(this.values());
            while (iter.hasNext()) {
                this.combo.add((String)iter.next());
            }
        }
        this.updateSelectedItem();
    }

    private void populateDefaultValue() {
        String defaultValue;
        String string = defaultValue = this.subject() != null ? this.defaultValue() : null;
        if (defaultValue != null) {
            this.combo.add(NLS.bind((String)JptUiMappingsMessages.ColumnComposite_defaultWithOneParam, (Object)defaultValue));
        } else {
            this.combo.add(JptUiMappingsMessages.ColumnComposite_defaultEmpty);
        }
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        this.updateSelectedItem();
    }

    protected void schemaChanged(Schema schema) {
    }

    protected void sequenceChanged(Sequence sequence) {
    }

    protected abstract void setValue(String var1);

    protected void tableChanged(Table table) {
    }

    private void updateSelectedItem() {
        JpaNode subject = (JpaNode)this.subject();
        String value = subject != null ? this.value() : null;
        String defaultValue = subject != null ? this.defaultValue() : null;
        String displayString = JptUiMappingsMessages.ColumnComposite_defaultEmpty;
        if (defaultValue != null) {
            displayString = NLS.bind((String)JptUiMappingsMessages.ColumnComposite_defaultWithOneParam, (Object)defaultValue);
        }
        if (!this.combo.getItem(0).equals(displayString)) {
            this.combo.remove(0);
            this.combo.add(displayString, 0);
        }
        if (value != null) {
            this.combo.setText(value);
        } else {
            this.combo.select(0);
        }
        this.combo.setSelection(new Point(0, 0));
    }

    protected abstract String value();

    protected void valueChanged(String value) {
        String oldValue;
        JpaNode subject = (JpaNode)this.subject();
        if (subject == null && !this.isBuildSubjectAllowed()) {
            return;
        }
        String string = oldValue = subject != null ? this.value() : null;
        if (StringTools.stringIsEmpty((String)value)) {
            value = null;
            if (StringTools.stringIsEmpty((String)oldValue)) {
                return;
            }
        }
        if (value != null && this.getCombo().getItemCount() > 0 && value.equals(this.getCombo().getItem(0))) {
            value = null;
        }
        if (oldValue == value && value == null) {
            this.clearDefaultValue();
            return;
        }
        if (subject == null) {
            this.buildSubject();
        }
        if (value != null && oldValue == null || oldValue != null && !oldValue.equals(value)) {
            this.setPopulating(true);
            this.combo.setData("populating", (Object)Boolean.TRUE);
            try {
                this.setValue(value);
            }
            finally {
                this.setPopulating(false);
                this.combo.setData("populating", (Object)Boolean.FALSE);
            }
            if (value == null) {
                this.clearDefaultValue();
            }
        }
    }

    protected abstract Iterator<String> values();
}

