/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BaseEmbeddedMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.ColumnComposite;
import org.eclipse.jpt.ui.internal.util.ControlEnabler;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationWritablePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedAttributeOverridesComposite
extends AbstractFormPane<BaseEmbeddedMapping> {
    private WritablePropertyValueModel<AttributeOverride> attributeOverrideHolder;

    public EmbeddedAttributeOverridesComposite(AbstractFormPane<? extends BaseEmbeddedMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public EmbeddedAttributeOverridesComposite(PropertyValueModel<? extends BaseEmbeddedMapping> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    private WritablePropertyValueModel<AttributeOverride> buildAttributeOverrideHolder() {
        return new SimplePropertyValueModel();
    }

    private ILabelProvider buildAttributeOverrideLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return EmbeddedAttributeOverridesComposite.this.buildOverrideDisplayString((AttributeOverride)element);
            }
        };
    }

    private AddRemovePane.Adapter buildAttributeOverridesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
            }
        };
    }

    private ListValueModel<AttributeOverride> buildAttributeOverridesListHolder() {
        ArrayList<ListValueModel<AttributeOverride>> list = new ArrayList<ListValueModel<AttributeOverride>>();
        list.add(this.buildSpecifiedAttributeOverridesListHolder());
        list.add(this.buildDefaultAttributeOverridesListHolder());
        return new CompositeListValueModel(list);
    }

    private ListValueModel<AttributeOverride> buildAttributeOverridesListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildAttributeOverridesListHolder(), new String[]{"nameProperty"});
    }

    private PropertyValueModel<Column> buildColumnHolder(WritablePropertyValueModel<AttributeOverride> attributeOverrideHolder) {
        return new TransformationPropertyValueModel<AttributeOverride, Column>(attributeOverrideHolder){

            protected Column transform_(AttributeOverride value) {
                return value.getColumn();
            }
        };
    }

    private ListValueModel<AttributeOverride> buildDefaultAttributeOverridesListHolder() {
        return new ListAspectAdapter<BaseEmbeddedMapping, AttributeOverride>(this.getSubjectHolder(), new String[]{"virtualAttributeOverridesList"}){

            protected ListIterator<AttributeOverride> listIterator_() {
                return ((BaseEmbeddedMapping)this.subject).virtualAttributeOverrides();
            }

            protected int size_() {
                return ((BaseEmbeddedMapping)this.subject).virtualAttributeOverridesSize();
            }
        };
    }

    private PropertyValueModel<Boolean> buildOverrideDefaultAttributeOverrideEnablerHolder() {
        return new TransformationPropertyValueModel<AttributeOverride, Boolean>(this.attributeOverrideHolder){

            protected Boolean transform(AttributeOverride value) {
                if (value != null) {
                    return true;
                }
                return false;
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildOverrideDefaultAttributeOverrideHolder() {
        return new TransformationWritablePropertyValueModel<AttributeOverride, Boolean>(this.attributeOverrideHolder){

            public void setValue(Boolean value) {
                EmbeddedAttributeOverridesComposite.this.updateAssociationOverride(value);
            }

            protected Boolean transform_(AttributeOverride value) {
                return !value.isVirtual();
            }
        };
    }

    private String buildOverrideDisplayString(AttributeOverride override) {
        String name = override.getName();
        name = StringTools.stringIsEmpty((String)name) ? JptUiMappingsMessages.OverridesComposite_noName : name.trim();
        return name;
    }

    private ListValueModel<AttributeOverride> buildSpecifiedAttributeOverridesListHolder() {
        return new ListAspectAdapter<BaseEmbeddedMapping, AttributeOverride>(this.getSubjectHolder(), new String[]{"specifiedAttributeOverridesList"}){

            protected ListIterator<AttributeOverride> listIterator_() {
                return ((BaseEmbeddedMapping)this.subject).specifiedAttributeOverrides();
            }

            public int size_() {
                return ((BaseEmbeddedMapping)this.subject).specifiedAttributeOverridesSize();
            }
        };
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.attributeOverrideHolder = this.buildAttributeOverrideHolder();
    }

    private AddRemoveListPane<BaseEmbeddedMapping> initializeAttributeOverridesList(Composite container) {
        return new AddRemoveListPane<BaseEmbeddedMapping>((AbstractPane)this, this.buildSubPane(container, 8), this.buildAttributeOverridesAdapter(), this.buildAttributeOverridesListModel(), this.attributeOverrideHolder, this.buildAttributeOverrideLabelProvider(), "org.eclipse.jpt.ui.mapping_embeddedAttributeOverrides"){

            @Override
            protected void initializeButtonPane(Composite container, String helpId) {
            }

            @Override
            protected void updateButtons() {
            }
        };
    }

    @Override
    protected void initializeLayout(Composite container) {
        container = this.buildTitledPane(container, JptUiMappingsMessages.AttributeOverridesComposite_attributeOverrides);
        this.initializeAttributeOverridesList(container);
        this.initializePropertyPane(this.buildSubPane(container, 5, 0));
    }

    private void initializePropertyPane(Composite container) {
        Button overrideDefaultButton = this.buildCheckBox(this.buildSubPane(container, 0, this.groupBoxMargin()), JptUiMappingsMessages.AttributeOverridesComposite_overrideDefault, this.buildOverrideDefaultAttributeOverrideHolder());
        this.installOverrideDefaultButtonEnabler(overrideDefaultButton);
        ColumnComposite columnComposite = new ColumnComposite((AbstractFormPane<?>)this, (PropertyValueModel<? extends Column>)this.buildColumnHolder(this.attributeOverrideHolder), container);
        this.installColumnCompositeEnabler(columnComposite);
    }

    private void installColumnCompositeEnabler(ColumnComposite columnComposite) {
        new PaneEnabler((PropertyValueModel<Boolean>)this.buildOverrideDefaultAttributeOverrideHolder(), (AbstractPane<?>)columnComposite);
    }

    private void installOverrideDefaultButtonEnabler(Button overrideDefaultButton) {
        new ControlEnabler(this.buildOverrideDefaultAttributeOverrideEnablerHolder(), (Control)overrideDefaultButton);
    }

    private void updateAssociationOverride(boolean selected) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            AttributeOverride override = (AttributeOverride)this.attributeOverrideHolder.getValue();
            AttributeOverride newOverride = override.setVirtual(!selected);
            this.attributeOverrideHolder.setValue((Object)newOverride);
        }
        finally {
            this.setPopulating(false);
        }
    }
}

