/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jpt.core.context.GeneratedValue;
import org.eclipse.jpt.core.context.GenerationType;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.ui.internal.listeners.SWTListChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedValueComposite
extends AbstractFormPane<IdMapping> {
    private PropertyChangeListener generatedValuePropertyChangeListener;
    private CCombo generatorNameCombo;
    private PropertyChangeListener generatorNamePropertyChangeListener;
    private ListChangeListener generatorsListChangeListener;

    public GeneratedValueComposite(AbstractFormPane<? extends IdMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private PropertyChangeListener buildGeneratedValuePropertyChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildGeneratedValuePropertyChangeListener_());
    }

    private PropertyChangeListener buildGeneratedValuePropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                GeneratedValueComposite.this.disengageListeners((GeneratedValue)e.getOldValue());
                GeneratedValueComposite.this.engageListeners((GeneratedValue)e.getNewValue());
                if (!GeneratedValueComposite.this.isPopulating()) {
                    GeneratedValueComposite.this.setPopulating(true);
                    try {
                        GeneratedValueComposite.this.populateGeneratorNameCombo();
                    }
                    finally {
                        GeneratedValueComposite.this.setPopulating(false);
                    }
                }
            }
        };
    }

    private ModifyListener buildGeneratorNameModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneratedValueComposite.this.isPopulating()) {
                    return;
                }
                String generatorName = ((CCombo)e.getSource()).getText();
                GeneratedValue generatedValue = ((IdMapping)GeneratedValueComposite.this.subject()).getGeneratedValue();
                if (StringTools.stringIsEmpty((String)generatorName)) {
                    if (generatedValue == null || StringTools.stringIsEmpty((String)generatedValue.getGenerator())) {
                        return;
                    }
                    generatorName = null;
                }
                GeneratedValueComposite.this.retrieveGeneratedValue().setSpecifiedGenerator(generatorName);
            }
        };
    }

    private PropertyChangeListener buildGeneratorNamePropertyChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildGeneratorNamePropertyChangeListener_());
    }

    private PropertyChangeListener buildGeneratorNamePropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                if (!GeneratedValueComposite.this.isPopulating()) {
                    GeneratedValueComposite.this.setPopulating(true);
                    try {
                        GeneratedValueComposite.this.populateGeneratorName();
                    }
                    finally {
                        GeneratedValueComposite.this.setPopulating(false);
                    }
                }
            }
        };
    }

    private ListChangeListener buildGeneratorsListChangeListener() {
        return new SWTListChangeListenerWrapper(this.buildGeneratorsListChangeListener_());
    }

    private ListChangeListener buildGeneratorsListChangeListener_() {
        return new ListChangeAdapter(){

            public void listChanged(ListChangeEvent event) {
                if (!GeneratedValueComposite.this.isPopulating()) {
                    GeneratedValueComposite.this.setPopulating(true);
                    try {
                        GeneratedValueComposite.this.populateGeneratorChoices();
                    }
                    finally {
                        GeneratedValueComposite.this.setPopulating(false);
                    }
                }
            }
        };
    }

    private PropertyValueModel<GeneratedValue> buildGeneratorValueHolder() {
        return new PropertyAspectAdapter<IdMapping, GeneratedValue>(this.getSubjectHolder(), new String[]{"generatedValueProperty"}){

            protected GeneratedValue buildValue_() {
                return ((IdMapping)GeneratedValueComposite.this.subject()).getGeneratedValue();
            }
        };
    }

    private EnumFormComboViewer<GeneratedValue, GenerationType> buildStrategyComboViewer(Composite parent) {
        return new EnumFormComboViewer<GeneratedValue, GenerationType>((AbstractPane)this, this.buildGeneratorValueHolder(), parent){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultStrategyProperty");
                propertyNames.add("specifiedStrategyProperty");
            }

            protected GenerationType[] choices() {
                return GenerationType.values();
            }

            @Override
            protected GenerationType defaultValue() {
                return ((GeneratedValue)this.subject()).getDefaultStrategy();
            }

            @Override
            protected String displayString(GenerationType value) {
                return this.buildDisplayString(JptUiMappingsMessages.class, GeneratedValueComposite.this, (Object)value);
            }

            @Override
            protected GenerationType getValue() {
                return ((GeneratedValue)this.subject()).getSpecifiedStrategy();
            }

            @Override
            protected void setValue(GenerationType value) {
                GeneratedValueComposite.this.retrieveGeneratedValue().setSpecifiedStrategy(value);
            }
        };
    }

    @Override
    private void disengageListeners(GeneratedValue generatedValue) {
        if (generatedValue != null) {
            generatedValue.removePropertyChangeListener("defaultGeneratorProperty", this.generatorNamePropertyChangeListener);
            generatedValue.removePropertyChangeListener("specifiedGeneratorProperty", this.generatorNamePropertyChangeListener);
            generatedValue.getPersistenceUnit().removeListChangeListener("generators", this.generatorsListChangeListener);
        }
    }

    @Override
    protected void disengageListeners(IdMapping subject) {
        super.disengageListeners(subject);
        if (subject != null) {
            subject.removePropertyChangeListener("generatedValueProperty", this.generatedValuePropertyChangeListener);
        }
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateGeneratorNameCombo();
    }

    @Override
    private void engageListeners(GeneratedValue generatedValue) {
        if (generatedValue != null) {
            generatedValue.addPropertyChangeListener("defaultGeneratorProperty", this.generatorNamePropertyChangeListener);
            generatedValue.addPropertyChangeListener("specifiedGeneratorProperty", this.generatorNamePropertyChangeListener);
            generatedValue.getPersistenceUnit().addListChangeListener("generators", this.generatorsListChangeListener);
        }
    }

    @Override
    protected void engageListeners(IdMapping subject) {
        super.engageListeners(subject);
        if (subject != null) {
            subject.addPropertyChangeListener("generatedValueProperty", this.generatedValuePropertyChangeListener);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.generatedValuePropertyChangeListener = this.buildGeneratedValuePropertyChangeListener();
        this.generatorNamePropertyChangeListener = this.buildGeneratorNamePropertyChangeListener();
        this.generatorsListChangeListener = this.buildGeneratorsListChangeListener();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.buildLabeledComposite(container, JptUiMappingsMessages.GeneratedValueComposite_strategy, this.buildStrategyComboViewer(container), "org.eclipse.jpt.ui.mapping_generatedValueStrategy");
        this.generatorNameCombo = this.buildLabeledEditableCCombo(container, JptUiMappingsMessages.GeneratedValueComposite_generatorName, this.buildGeneratorNameModifyListener(), "org.eclipse.jpt.ui.mapping_generatedValueStrategy");
        this.generatorNameCombo.add(JptUiMappingsMessages.TableComposite_defaultEmpty);
    }

    private void populateGeneratorChoices() {
        if (this.subject() == null) {
            this.generatorNameCombo.setItems(new String[0]);
        } else {
            this.generatorNameCombo.setItems(this.sortedUniqueGeneratorNames());
        }
    }

    private void populateGeneratorName() {
        if (this.subject() == null) {
            this.generatorNameCombo.setText("");
        } else {
            GeneratedValue generatedValue = ((IdMapping)this.subject()).getGeneratedValue();
            if (generatedValue == null) {
                this.generatorNameCombo.setText("");
            } else {
                String generatorName = generatedValue.getGenerator();
                if (StringTools.stringIsEmpty((String)generatorName)) {
                    this.generatorNameCombo.setText("");
                } else if (!this.generatorNameCombo.getText().equals(generatorName)) {
                    this.generatorNameCombo.setText(generatorName);
                }
            }
        }
    }

    private void populateGeneratorNameCombo() {
        this.populateGeneratorName();
        this.populateGeneratorChoices();
    }

    private GeneratedValue retrieveGeneratedValue() {
        GeneratedValue generatedValue = ((IdMapping)this.subject()).getGeneratedValue();
        if (generatedValue == null) {
            this.setPopulating(true);
            try {
                generatedValue = ((IdMapping)this.subject()).addGeneratedValue();
            }
            finally {
                this.setPopulating(false);
            }
        }
        return generatedValue;
    }

    private String[] sortedUniqueGeneratorNames() {
        return (String[])CollectionTools.array((Iterable)CollectionTools.sortedSet((Iterator)new TransformationIterator<Generator, String>((Iterator)new FilteringIterator<Generator, Generator>((Iterator)((IdMapping)this.subject()).getPersistenceUnit().allGenerators()){

            protected boolean accept(Generator o) {
                return o.getName() != null;
            }
        }){

            protected String transform(Generator next) {
                return next.getName();
            }
        }), (Object[])new String[0]);
    }
}

