/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.GeneratorHolder;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.LabeledControlUpdater;
import org.eclipse.jpt.ui.internal.util.LabeledLabel;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorComposite<T extends Generator>
extends AbstractPane<GeneratorHolder> {
    public GeneratorComposite(AbstractPane<? extends GeneratorHolder> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private WritablePropertyValueModel<Integer> buildAllocationSizeHolder() {
        return new PropertyAspectAdapter<Generator, Integer>(this.buildGeneratorHolder(), new String[]{"specifiedAllocationSizeProperty"}){

            protected Integer buildValue_() {
                Integer value = ((Generator)this.subject).getSpecifiedAllocationSize();
                if (value == null) {
                    return -1;
                }
                return value;
            }

            public void setValue(Integer value) {
                if (this.subject == null && value == -1) {
                    return;
                }
                this.setValue_(value);
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                GeneratorComposite.this.retrieveGenerator((GeneratorHolder)GeneratorComposite.this.subject()).setSpecifiedAllocationSize(value);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultAllocationSizeHolder() {
        return new PropertyAspectAdapter<Generator, Integer>(this.buildGeneratorHolder(), new String[]{"defaultAllocationSizeProperty"}){

            protected Integer buildValue_() {
                return ((Generator)this.subject).getDefaultAllocationSize();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    private Control buildDefaultAllocationSizeLabel(Composite container) {
        Label label = this.buildLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater(new LabeledLabel(label), this.buildDefaultAllocationSizeLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultAllocationSizeLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultAllocationSizeHolder()){

            protected String transform(Integer value) {
                if (value != null) {
                    return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)value);
                }
                return "";
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildDefaultInitialValueHolder() {
        return new PropertyAspectAdapter<Generator, Integer>(this.buildGeneratorHolder(), new String[]{"defaultInitialValueProperty"}){

            protected Integer buildValue_() {
                return ((Generator)this.subject).getDefaultInitialValue();
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Integer.MIN_VALUE, newValue);
                }
            }
        };
    }

    private Control buildDefaultInitialValueLabel(Composite container) {
        Label label = this.buildLabel(container, JptUiMappingsMessages.DefaultWithoutValue);
        new LabeledControlUpdater(new LabeledLabel(label), this.buildDefaultInitialValueLabelHolder());
        return label;
    }

    private PropertyValueModel<String> buildDefaultInitialValueLabelHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultInitialValueHolder()){

            protected String transform(Integer value) {
                if (value != null) {
                    return NLS.bind((String)JptUiMappingsMessages.DefaultWithValue, (Object)value);
                }
                return "";
            }
        };
    }

    protected abstract T buildGenerator(GeneratorHolder var1);

    private PropertyValueModel<Generator> buildGeneratorHolder() {
        return new PropertyAspectAdapter<GeneratorHolder, Generator>(this.getSubjectHolder(), new String[]{this.propertyName()}){

            protected Generator buildValue_() {
                return GeneratorComposite.this.generator((GeneratorHolder)this.subject);
            }
        };
    }

    protected final WritablePropertyValueModel<String> buildGeneratorNameHolder() {
        return new PropertyAspectAdapter<Generator, String>(this.buildGeneratorHolder(), new String[]{"nameProperty"}){

            protected String buildValue_() {
                return ((Generator)this.subject).getName();
            }

            public void setValue(String value) {
                if (this.subject == null && value.length() == 0) {
                    return;
                }
                this.setValue_(value);
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                GeneratorComposite.this.retrieveGenerator((GeneratorHolder)GeneratorComposite.this.subject()).setName(value);
            }
        };
    }

    private WritablePropertyValueModel<Integer> buildInitialValueHolder() {
        return new PropertyAspectAdapter<Generator, Integer>(this.buildGeneratorHolder(), new String[]{"specifiedInitialValueProperty"}){

            protected Integer buildValue_() {
                Integer value = ((Generator)this.subject).getSpecifiedInitialValue();
                if (value == null) {
                    return -1;
                }
                return value;
            }

            public void setValue(Integer value) {
                if (this.subject == null && value == -1) {
                    return;
                }
                this.setValue_(value);
            }

            protected void setValue_(Integer value) {
                if (value == -1) {
                    value = null;
                }
                GeneratorComposite.this.retrieveGenerator((GeneratorHolder)GeneratorComposite.this.subject()).setSpecifiedInitialValue(value);
            }
        };
    }

    protected final T generator() {
        return this.subject() == null ? null : (T)this.generator((GeneratorHolder)this.subject());
    }

    protected abstract T generator(GeneratorHolder var1);

    protected void initializeAllocationSizeWidgets(Composite container) {
        Spinner spinner = this.buildLabeledSpinner(container, JptUiMappingsMessages.GeneratorComposite_allocationSize, this.buildAllocationSizeHolder(), -1, -1, Integer.MAX_VALUE, this.buildDefaultAllocationSizeLabel(container));
        this.updateGridData(container, spinner);
    }

    protected void initializeInitialValueWidgets(Composite container) {
        Spinner spinner = this.buildLabeledSpinner(container, JptUiMappingsMessages.GeneratorComposite_initialValue, this.buildInitialValueHolder(), -1, -1, Integer.MAX_VALUE, this.buildDefaultInitialValueLabel(container));
        this.updateGridData(container, spinner);
    }

    protected final JpaProject jpaProject() {
        return this.subject() == null ? null : ((GeneratorHolder)this.subject()).getJpaProject();
    }

    protected abstract String propertyName();

    protected final T retrieveGenerator(GeneratorHolder subject) {
        T generator = this.generator(subject);
        if (generator == null) {
            generator = this.buildGenerator(subject);
        }
        return generator;
    }

    private void updateGridData(Composite container, Spinner spinner) {
        Composite paneContainer = spinner.getParent();
        while (container != paneContainer.getParent()) {
            paneContainer = paneContainer.getParent();
        }
        Control[] controls = paneContainer.getChildren();
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 1;
        controls[1].setLayoutData((Object)gridData);
        controls[2].setLayoutData((Object)new GridData(768));
        this.removeAlignRight(controls[2]);
    }
}

