/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collection;
import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.db.ColumnCombo;
import org.eclipse.jpt.ui.internal.mappings.details.PrimaryKeyJoinColumnsComposite;
import org.eclipse.jpt.ui.internal.util.ControlEnabler;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritanceComposite
extends AbstractFormPane<Entity> {
    private CCombo discriminatorValueCombo;

    public InheritanceComposite(AbstractFormPane<? extends Entity> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    public InheritanceComposite(PropertyValueModel<? extends Entity> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("defaultDiscriminatorValueProperty");
        propertyNames.add("specifiedDiscriminatorValueProperty");
    }

    private ColumnCombo<DiscriminatorColumn> buildColumnCombo(Composite container) {
        return new ColumnCombo<DiscriminatorColumn>((AbstractPane)this, this.buildDiscriminatorColumnHolder(), container){

            @Override
            protected String defaultValue() {
                return ((DiscriminatorColumn)this.subject()).getDefaultName();
            }

            @Override
            protected void setValue(String value) {
                ((DiscriminatorColumn)this.subject()).setSpecifiedName(value);
            }

            @Override
            protected Table table() {
                return ((DiscriminatorColumn)this.subject()).getDbTable();
            }

            @Override
            protected String value() {
                return ((DiscriminatorColumn)this.subject()).getSpecifiedName();
            }
        };
    }

    private PropertyValueModel<DiscriminatorColumn> buildDiscriminatorColumnHolder() {
        return new TransformationPropertyValueModel<Entity, DiscriminatorColumn>(this.getSubjectHolder()){

            protected DiscriminatorColumn transform_(Entity value) {
                return value.getDiscriminatorColumn();
            }
        };
    }

    private EnumFormComboViewer<DiscriminatorColumn, DiscriminatorType> buildDiscriminatorTypeCombo(Composite container) {
        return new EnumFormComboViewer<DiscriminatorColumn, DiscriminatorType>((AbstractPane)this, this.buildDiscriminatorColumnHolder(), container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultDiscriminatorTypeProperty");
                propertyNames.add("specifiedDiscriminatorTypeProperty");
            }

            protected DiscriminatorType[] choices() {
                return DiscriminatorType.values();
            }

            @Override
            protected DiscriminatorType defaultValue() {
                return ((DiscriminatorColumn)this.subject()).getDefaultDiscriminatorType();
            }

            @Override
            protected String displayString(DiscriminatorType value) {
                return this.buildDisplayString(JptUiMappingsMessages.class, InheritanceComposite.this, (Object)value);
            }

            @Override
            protected DiscriminatorType getValue() {
                return ((DiscriminatorColumn)this.subject()).getSpecifiedDiscriminatorType();
            }

            @Override
            protected void setValue(DiscriminatorType value) {
                ((DiscriminatorColumn)this.subject()).setSpecifiedDiscriminatorType(value);
            }
        };
    }

    private PropertyValueModel<Boolean> buildDiscriminatorValueBooleanHolder() {
        return new PropertyAspectAdapter<Entity, Boolean>(this.getSubjectHolder(), new String[]{"discriminatorValueAllowedProperty"}){

            protected Boolean buildValue_() {
                return ((Entity)this.subject).isDiscriminatorValueAllowed();
            }
        };
    }

    private ModifyListener buildDiscriminatorValueComboSelectionListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!InheritanceComposite.this.isPopulating()) {
                    CCombo combo = (CCombo)e.widget;
                    InheritanceComposite.this.discriminatorValueChanged(combo.getText());
                }
            }
        };
    }

    private EnumFormComboViewer<Entity, InheritanceType> buildStrategyCombo(Composite container) {
        return new EnumFormComboViewer<Entity, InheritanceType>((AbstractPane)this, container){

            @Override
            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultInheritanceStrategyProperty");
                propertyNames.add("specifiedInheritanceStrategyProperty");
            }

            protected InheritanceType[] choices() {
                return InheritanceType.values();
            }

            @Override
            protected InheritanceType defaultValue() {
                return ((Entity)this.subject()).getDefaultInheritanceStrategy();
            }

            @Override
            protected String displayString(InheritanceType value) {
                return this.buildDisplayString(JptUiMappingsMessages.class, InheritanceComposite.this, (Object)value);
            }

            @Override
            protected InheritanceType getValue() {
                return ((Entity)this.subject()).getSpecifiedInheritanceStrategy();
            }

            @Override
            protected void setValue(InheritanceType value) {
                ((Entity)this.subject()).setSpecifiedInheritanceStrategy(value);
            }
        };
    }

    private void discriminatorValueChanged(String value) {
        String oldValue;
        Entity subject = (Entity)this.subject();
        String string = oldValue = subject != null ? subject.getSpecifiedDiscriminatorValue() : null;
        if (StringTools.stringIsEmpty((String)value)) {
            value = null;
            if (StringTools.stringIsEmpty((String)oldValue)) {
                return;
            }
        }
        if (value != null && this.discriminatorValueCombo.getItemCount() > 0 && value.equals(this.discriminatorValueCombo.getItem(0))) {
            value = null;
        }
        if (oldValue == value && value == null) {
            return;
        }
        if (value != null && oldValue == null || oldValue != null && !oldValue.equals(value)) {
            this.setPopulating(true);
            try {
                subject.setSpecifiedDiscriminatorValue(value);
            }
            finally {
                this.setPopulating(false);
            }
        }
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateDiscriminatorValueCombo();
    }

    @Override
    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.groupBoxMargin();
        Composite subPane = this.buildSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin);
        this.buildLabeledComposite(subPane, JptUiMappingsMessages.InheritanceComposite_strategy, this.buildStrategyCombo(subPane), "org.eclipse.jpt.ui.entity_inheritanceStrategy");
        this.buildLabeledComposite(subPane, JptUiMappingsMessages.DiscriminatorColumnComposite_column, this.buildColumnCombo(subPane), "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorColumn");
        this.buildLabeledComposite(subPane, JptUiMappingsMessages.DiscriminatorColumnComposite_discriminatorType, this.buildDiscriminatorTypeCombo(subPane), "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorType");
        this.discriminatorValueCombo = this.buildLabeledEditableCCombo(subPane, JptUiMappingsMessages.InheritanceComposite_discriminatorValue, this.buildDiscriminatorValueComboSelectionListener(), "org.eclipse.jpt.ui.entity_inheritanceDiscriminatorValue");
        this.installDiscriminatorValueComboEnabler(this.discriminatorValueCombo);
        new PrimaryKeyJoinColumnsComposite(this, this.buildSubPane(container, 5));
    }

    private void installDiscriminatorValueComboEnabler(CCombo discriminatorValueCombo) {
        new ControlEnabler(this.buildDiscriminatorValueBooleanHolder(), (Control)discriminatorValueCombo);
    }

    private void populateDiscriminatorValueCombo() {
        Entity subject = (Entity)this.subject();
        this.discriminatorValueCombo.removeAll();
        if (subject == null) {
            return;
        }
        String defaultDiscriminatorValue = subject.getDefaultDiscriminatorValue();
        if (defaultDiscriminatorValue != null) {
            this.discriminatorValueCombo.add(NLS.bind((String)JptUiMappingsMessages.ColumnComposite_defaultWithOneParam, (Object)defaultDiscriminatorValue));
        } else {
            this.discriminatorValueCombo.add(NLS.bind((String)JptUiMappingsMessages.DiscriminatorColumnComposite_defaultEmpty, (Object)defaultDiscriminatorValue));
        }
        String specifiedDiscriminatorValue = subject.getSpecifiedDiscriminatorValue();
        if (specifiedDiscriminatorValue != null) {
            this.discriminatorValueCombo.setText(specifiedDiscriminatorValue);
        } else {
            this.discriminatorValueCombo.select(0);
        }
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "defaultDiscriminatorValueProperty" || propertyName == "specifiedDiscriminatorValueProperty") {
            this.populateDiscriminatorValueCombo();
        }
    }
}

