/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.ui.internal.mappings.details.BaseJoinColumnStateObject;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JoinColumnStateObject
extends BaseJoinColumnStateObject {
    private Boolean insertable;
    private Boolean nullable;
    private Boolean unique;
    private Boolean updatable;
    public static final String INSERTABLE_PROPERTY = "insertable";
    public static final String NULLABLE_PROPERTY = "nullable";
    public static final String UNIQUE_PROPERTY = "unique";
    public static final String UPDATABLE_PROPERTY = "updatable";

    public JoinColumnStateObject(Object owner, JoinColumn joinColumn) {
        super(owner, (BaseJoinColumn)joinColumn);
    }

    public Boolean getDefaultInsertable() {
        JoinColumn joinColumn = this.getJoinColumn();
        if (joinColumn != null) {
            return joinColumn.getDefaultInsertable();
        }
        return BaseColumn.DEFAULT_INSERTABLE;
    }

    public Boolean getDefaultNullable() {
        JoinColumn joinColumn = this.getJoinColumn();
        if (joinColumn != null) {
            return joinColumn.getDefaultNullable();
        }
        return BaseColumn.DEFAULT_NULLABLE;
    }

    public Boolean getDefaultUnique() {
        JoinColumn joinColumn = this.getJoinColumn();
        if (joinColumn != null) {
            return joinColumn.getDefaultUnique();
        }
        return BaseColumn.DEFAULT_UNIQUE;
    }

    public Boolean getDefaultUpdatable() {
        JoinColumn joinColumn = this.getJoinColumn();
        if (joinColumn != null) {
            return joinColumn.getDefaultUpdatable();
        }
        return BaseColumn.DEFAULT_UPDATABLE;
    }

    public Boolean getInsertable() {
        return this.insertable;
    }

    public JoinColumn getJoinColumn() {
        return (JoinColumn)super.getJoinColumn();
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    protected abstract Schema getSchema();

    public Boolean getUnique() {
        return this.unique;
    }

    public Boolean getUpdatable() {
        return this.updatable;
    }

    @Override
    protected void initialize(Object owner, BaseJoinColumn baseJoinColumn) {
        super.initialize(owner, baseJoinColumn);
        if (baseJoinColumn != null) {
            JoinColumn joinColumn = (JoinColumn)baseJoinColumn;
            this.insertable = joinColumn.getSpecifiedInsertable();
            this.nullable = joinColumn.getSpecifiedNullable();
            this.unique = joinColumn.getSpecifiedUnique();
            this.updatable = joinColumn.getSpecifiedUpdatable();
        }
    }

    @Override
    protected String initialTable() {
        JoinColumn joinColumn = this.getJoinColumn();
        if (joinColumn == null) {
            return null;
        }
        return joinColumn.getSpecifiedTable();
    }

    public void setInsertable(Boolean insertable) {
        Boolean oldInsertable = this.insertable;
        this.insertable = insertable;
        this.firePropertyChanged(INSERTABLE_PROPERTY, oldInsertable, insertable);
    }

    public void setNullable(Boolean nullable) {
        Boolean oldNullable = this.nullable;
        this.nullable = nullable;
        this.firePropertyChanged(NULLABLE_PROPERTY, oldNullable, nullable);
    }

    public void setUnique(Boolean unique) {
        Boolean oldUnique = this.unique;
        this.unique = unique;
        this.firePropertyChanged(UNIQUE_PROPERTY, oldUnique, unique);
    }

    public void setUpdatable(Boolean updatable) {
        Boolean oldUpdatable = this.updatable;
        this.updatable = updatable;
        this.firePropertyChanged(UPDATABLE_PROPERTY, oldUpdatable, updatable);
    }

    @Override
    public ListIterator<String> tables() {
        Schema schema = this.getSchema();
        if (schema == null) {
            return EmptyListIterator.instance();
        }
        List names = CollectionTools.list((Iterator)schema.tableNames());
        Collections.sort(names);
        return names.listIterator();
    }

    @Override
    public void updateJoinColumn(BaseJoinColumn abstractJoinColumn) {
        super.updateJoinColumn(abstractJoinColumn);
        JoinColumn joinColumn = (JoinColumn)abstractJoinColumn;
        String table = this.getTable();
        if (this.valuesAreDifferent(table, joinColumn.getSpecifiedTable())) {
            joinColumn.setSpecifiedTable(table);
        }
        if (joinColumn.getSpecifiedInsertable() != this.insertable) {
            joinColumn.setSpecifiedInsertable(this.insertable);
        }
        if (joinColumn.getSpecifiedUpdatable() != this.updatable) {
            joinColumn.setSpecifiedUpdatable(this.updatable);
        }
        if (joinColumn.getSpecifiedUnique() != this.unique) {
            joinColumn.setSpecifiedUnique(this.unique);
        }
        if (joinColumn.getSpecifiedNullable() != this.nullable) {
            joinColumn.setSpecifiedNullable(this.nullable);
        }
    }
}

