/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.QueryHintsComposite;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.ui.internal.widgets.ClassChooserPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedNativeQueryPropertyComposite
extends AbstractPane<NamedNativeQuery> {
    private ClassChooserPane<NamedNativeQuery> resultClassChooserPane;

    public NamedNativeQueryPropertyComposite(AbstractPane<?> parentPane, PropertyValueModel<? extends NamedNativeQuery> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    private ClassChooserPane<NamedNativeQuery> buildClassChooser(Composite container) {
        return new ClassChooserPane<NamedNativeQuery>((AbstractPane)this, container){

            @Override
            protected WritablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<NamedNativeQuery, String>(this.getSubjectHolder(), new String[]{"resultClassProperty"}){

                    protected String buildValue_() {
                        return ((NamedNativeQuery)this.subject).getResultClass();
                    }

                    protected void setValue_(String value) {
                        ((NamedNativeQuery)this.subject).setResultClass(value);
                    }
                };
            }

            @Override
            protected String className() {
                return ((NamedNativeQuery)this.subject()).getResultClass();
            }

            @Override
            protected String labelText() {
                return JptUiMappingsMessages.NamedNativeQueryPropertyComposite_resultClass;
            }

            @Override
            protected IPackageFragmentRoot packageFragmentRoot() {
                IProject project = ((NamedNativeQuery)this.subject()).getJpaProject().getProject();
                IJavaProject root = JavaCore.create((IProject)project);
                try {
                    return root.getAllPackageFragmentRoots()[0];
                }
                catch (JavaModelException e) {
                    JptUiPlugin.log(e);
                    return null;
                }
            }

            @Override
            protected void promptType() {
                IType type = this.chooseType();
                if (type != null) {
                    String className = type.getFullyQualifiedName();
                    ((NamedNativeQuery)this.subject()).setResultClass(className);
                }
            }
        };
    }

    private WritablePropertyValueModel<String> buildQueryHolder() {
        return new PropertyAspectAdapter<NamedNativeQuery, String>(this.getSubjectHolder(), new String[]{"queryProperty"}){

            protected String buildValue_() {
                return ((NamedNativeQuery)this.subject).getQuery();
            }

            protected void setValue_(String value) {
                ((NamedNativeQuery)this.subject).setQuery(value);
            }
        };
    }

    @Override
    public void enableWidgets(boolean enabled) {
        super.enableWidgets(enabled);
        this.resultClassChooserPane.enableWidgets(enabled);
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.resultClassChooserPane = this.buildClassChooser(container);
        this.buildLabeledMultiLineText(container, JptUiMappingsMessages.NamedNativeQueryPropertyComposite_query, this.buildQueryHolder(), 4);
        container = this.buildTitledPane(this.buildSubPane(container, 5), JptUiMappingsMessages.NamedNativeQueryPropertyComposite_queryHintsGroupBox);
        new QueryHintsComposite(this, container);
    }
}

