/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.orm.details;

import java.util.Collection;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.ui.internal.orm.JptUiOrmMessages;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmJavaAttributeChooser
extends AbstractFormPane<OrmAttributeMapping> {
    private Text text;

    public OrmJavaAttributeChooser(AbstractFormPane<?> parentPane, PropertyValueModel<OrmAttributeMapping> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    @Override
    protected void addPropertyNames(Collection<String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.add("nameProperty");
    }

    private ModifyListener buildNameModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!OrmJavaAttributeChooser.this.isPopulating()) {
                    Text text = (Text)e.widget;
                    OrmJavaAttributeChooser.this.textChanged(text.getText());
                }
            }
        };
    }

    @Override
    public void doPopulate() {
        super.doPopulate();
        this.populateText();
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.text = this.buildLabeledText(container, JptUiOrmMessages.OrmJavaAttributeChooser_javaAttribute, this.buildNameModifyListener());
    }

    private void populateText() {
        OrmAttributeMapping subject = (OrmAttributeMapping)this.subject();
        this.text.setText("");
        if (subject == null) {
            return;
        }
        String name = subject.getName();
        if (name == null) {
            name = "";
        }
        this.text.setText(name);
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        if (propertyName == "nameProperty") {
            this.populateText();
        }
    }

    private void textChanged(String text) {
        this.setPopulating(true);
        try {
            ((OrmAttributeMapping)this.subject()).setName(text);
        }
        finally {
            this.setPopulating(false);
        }
    }
}

