/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jpt.core.internal.facet.JpaFacetDataModelProvider;
import org.eclipse.jpt.core.internal.platform.JpaPlatformRegistry;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.properties.DataModelPropertyPage;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class JpaProjectPropertiesPage
extends DataModelPropertyPage
implements JpaFacetDataModelProperties {
    private PlatformGroup platformGroup;
    private ConnectionGroup connectionGroup;
    private PersistentClassManagementGroup persistentClassManagementGroup;

    public JpaProjectPropertiesPage() {
        super(DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetDataModelProvider()));
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.platformGroup = new PlatformGroup(composite);
        this.connectionGroup = new ConnectionGroup(composite);
        this.persistentClassManagementGroup = new PersistentClassManagementGroup(composite);
        this.setRuntime();
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.properties_javaPersistence");
        return composite;
    }

    private void setRuntime() {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)this.getJpaProject().getProject());
        }
        catch (CoreException ce) {
            JptUiPlugin.log(ce);
            return;
        }
        IRuntime runtime = facetedProject.getPrimaryRuntime();
        this.model.setProperty("IJpaFacetDataModelProperties.RUNTIME", (Object)runtime);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IJpaFacetDataModelProperties.PLATFORM_ID", "IJpaFacetDataModelProperties.CONNECTION", "IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES"};
    }

    protected JpaProject getJpaProject() {
        return (JpaProject)this.getElement().getAdapter(JpaProject.class);
    }

    Combo createCombo(Composite container, boolean fillHorizontal) {
        Combo combo = new Combo(container, 2060);
        if (fillHorizontal) {
            combo.setLayoutData((Object)new GridData(768));
        } else {
            combo.setLayoutData((Object)new GridData());
        }
        return combo;
    }

    Button createButton(Composite container, int span, String text, int style) {
        Button button = new Button(container, style);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        button.setLayoutData((Object)gd);
        return button;
    }

    protected void performDefaults() {
        this.platformGroup.performDefaults();
        this.connectionGroup.performDefaults();
        this.persistentClassManagementGroup.performDefaults();
    }

    public boolean performOk() {
        boolean discover;
        String connection;
        JpaProject jpaProject = this.getJpaProject();
        if (jpaProject == null) {
            return true;
        }
        boolean change = false;
        boolean platformChange = false;
        IProject project = jpaProject.getProject();
        String platform = this.model.getStringProperty("IJpaFacetDataModelProperties.PLATFORM_ID");
        if (!platform.equals(jpaProject.getJpaPlatform().getId())) {
            change = true;
            platformChange = true;
            JptCorePlugin.setJpaPlatformId((IProject)project, (String)platform);
        }
        if (!(connection = this.model.getStringProperty("IJpaFacetDataModelProperties.CONNECTION")).equals(jpaProject.getDataSource().getConnectionProfileName())) {
            change = true;
            jpaProject.getDataSource().setConnectionProfileName(connection);
            JptCorePlugin.setConnectionProfileName((IProject)project, (String)connection);
        }
        if ((discover = this.model.getBooleanProperty("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES")) != jpaProject.discoversAnnotatedClasses()) {
            change = true;
            jpaProject.setDiscoversAnnotatedClasses(discover);
            JptCorePlugin.setDiscoverAnnotatedClasses((IProject)project, (boolean)discover);
        }
        if (platformChange) {
            JpaModelManager.instance().rebuildJpaProject(project);
        }
        if (change) {
            JpaProjectPropertiesPage.buildProject(project);
        }
        return true;
    }

    private static void buildProject(final IProject project) {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    project.build(6, pm);
                }
                catch (CoreException ce) {
                    JptUiPlugin.log(ce);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, r);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    private final class ConnectionGroup {
        final Combo connectionCombo;
        private Link connectionLink;

        public ConnectionGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_connectionLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            this.connectionCombo = JpaProjectPropertiesPage.this.createCombo((Composite)group, true);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.properties_javaPersistenceConnection");
            this.connectionCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ((ConnectionGroup)ConnectionGroup.this).JpaProjectPropertiesPage.this.model.setProperty("IJpaFacetDataModelProperties.CONNECTION", (Object)ConnectionGroup.this.connectionCombo.getItem(ConnectionGroup.this.connectionCombo.getSelectionIndex()));
                }
            });
            this.fillConnections();
            this.connectionLink = new Link((Composite)group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectionLink.setLayoutData((Object)data);
            this.connectionLink.setText(JptUiMessages.JpaFacetWizardPage_connectionLink);
            this.connectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openNewConnectionWizard();
                }
            });
            this.performDefaults();
        }

        private void fillConnections() {
            this.connectionCombo.removeAll();
            Iterator stream = JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNames();
            while (stream.hasNext()) {
                this.connectionCombo.add((String)stream.next());
            }
        }

        void performDefaults() {
            String connectionName = JpaProjectPropertiesPage.this.getJpaProject().getDataSource().getConnectionProfileName();
            JpaProjectPropertiesPage.this.model.setProperty("IJpaFacetDataModelProperties.CONNECTION", (Object)connectionName);
            if (connectionName == null) {
                this.connectionCombo.clearSelection();
            } else {
                this.connectionCombo.setText(connectionName);
            }
        }

        void openNewConnectionWizard() {
            String connectionName = DTPUiTools.createNewProfile();
            if (connectionName != null) {
                this.fillConnections();
                JpaProjectPropertiesPage.this.model.setProperty("IJpaFacetDataModelProperties.CONNECTION", (Object)connectionName);
                this.connectionCombo.select(this.connectionCombo.indexOf(connectionName));
            }
        }
    }

    private final class PersistentClassManagementGroup {
        final Button discoverClassesButton;
        final Button listClassesButton;

        public PersistentClassManagementGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_persistentClassManagementLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_addJavaPersistence_classpath");
            this.discoverClassesButton = JpaProjectPropertiesPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_discoverClassesButton, 16);
            this.discoverClassesButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ((PersistentClassManagementGroup)PersistentClassManagementGroup.this).JpaProjectPropertiesPage.this.model.setBooleanProperty("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", true);
                }
            });
            this.listClassesButton = JpaProjectPropertiesPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_listClassesButton, 16);
            this.listClassesButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    ((PersistentClassManagementGroup)PersistentClassManagementGroup.this).JpaProjectPropertiesPage.this.model.setBooleanProperty("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", false);
                }
            });
            JpaProjectPropertiesPage.this.model.addListener(new IDataModelListener(){

                public void propertyChanged(DataModelEvent event) {
                    if ("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES".equals(event.getPropertyName())) {
                        boolean discoverClasses = (Boolean)event.getProperty();
                        PersistentClassManagementGroup.this.discoverClassesButton.setSelection(discoverClasses);
                        PersistentClassManagementGroup.this.listClassesButton.setSelection(!discoverClasses);
                    }
                }
            });
            this.performDefaults();
        }

        void performDefaults() {
            boolean discoverClasses = JpaProjectPropertiesPage.this.getJpaProject().discoversAnnotatedClasses();
            JpaProjectPropertiesPage.this.model.setProperty("IJpaFacetDataModelProperties.DISCOVER_ANNOTATED_CLASSES", (Object)discoverClasses);
            this.discoverClassesButton.setSelection(discoverClasses);
            this.listClassesButton.setSelection(!discoverClasses);
        }
    }

    private final class PlatformGroup {
        final ComboViewer platformCombo;

        public PlatformGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_platformLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            this.platformCombo = new ComboViewer(JpaProjectPropertiesPage.this.createCombo((Composite)group, true));
            this.platformCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return CollectionTools.array((Iterator)JpaPlatformRegistry.instance().jpaPlatformIds());
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.platformCombo.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return JpaPlatformRegistry.instance().getJpaPlatformLabel((String)element);
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return true;
                }
            });
            this.platformCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((PlatformGroup)PlatformGroup.this).JpaProjectPropertiesPage.this.model.setProperty("IJpaFacetDataModelProperties.PLATFORM_ID", ((StructuredSelection)PlatformGroup.this.platformCombo.getSelection()).getFirstElement());
                }
            });
            this.platformCombo.setInput((Object)"null input");
            this.performDefaults();
        }

        void performDefaults() {
            String platformId = JpaProjectPropertiesPage.this.getJpaProject().getJpaPlatform().getId();
            JpaProjectPropertiesPage.this.model.setProperty("IJpaFacetDataModelProperties.PLATFORM_ID", (Object)platformId);
            this.platformCombo.setSelection((ISelection)new StructuredSelection((Object)platformId));
        }
    }
}

