/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.selection;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.ui.internal.selection.DefaultJpaSelection;
import org.eclipse.jpt.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionEvent;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.ui.internal.selection.JpaSelectionParticipant;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorSelectionParticipant
implements JpaSelectionParticipant {
    private final JpaSelectionManager selectionManager;
    final ITextEditor textEditor;
    private final IPropertyListener editorInputListener;
    private final ISelectionChangedListener editorSelectionListener;
    private JpaSelection currentSelection;
    private boolean forwardSelection = true;

    public TextEditorSelectionParticipant(JpaSelectionManager selectionManager, ITextEditor textEditor) {
        this.selectionManager = selectionManager;
        this.textEditor = textEditor;
        this.editorInputListener = new EditorInputListener();
        this.textEditor.addPropertyListener(this.editorInputListener);
        this.editorSelectionListener = new EditorSelectionListener();
        this.postSelectionProvider().addPostSelectionChangedListener(this.editorSelectionListener);
        this.currentSelection = this.calculateSelection();
    }

    public JpaSelection getSelection() {
        return this.currentSelection;
    }

    public void selectionChanged(JpaSelectionEvent evt) {
        JpaSelection newSelection = evt.getSelection();
        if (newSelection == JpaSelection.NULL_SELECTION || newSelection.equals(this.currentSelection)) {
            return;
        }
        this.forwardSelection = false;
        TextRange textRange = newSelection.getSelectedNode().getSelectionTextRange();
        if (textRange != null) {
            this.textEditor.selectAndReveal(textRange.getOffset(), textRange.getLength());
        }
        this.forwardSelection = true;
    }

    public boolean disposeOnHide() {
        return true;
    }

    public void dispose() {
        this.textEditor.removePropertyListener(this.editorInputListener);
        this.postSelectionProvider().removePostSelectionChangedListener(this.editorSelectionListener);
    }

    private JpaSelection calculateSelection() {
        ISelection selection = this.textEditor.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            return JpaSelection.NULL_SELECTION;
        }
        JpaFile jpaFile = this.jpaFile();
        if (jpaFile == null) {
            return JpaSelection.NULL_SELECTION;
        }
        JpaStructureNode selectedNode = jpaFile.getStructureNode(((ITextSelection)selection).getOffset());
        if (selectedNode == null) {
            return JpaSelection.NULL_SELECTION;
        }
        return new DefaultJpaSelection(selectedNode);
    }

    private JpaFile jpaFile() {
        IEditorInput input = this.textEditor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return JptCorePlugin.getJpaFile((IFile)((IFileEditorInput)input).getFile());
    }

    private IPostSelectionProvider postSelectionProvider() {
        return (IPostSelectionProvider)this.textEditor.getSelectionProvider();
    }

    void editorInputChanged() {
        JpaSelection newSelection = this.calculateSelection();
        if (newSelection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = newSelection;
        if (this.forwardSelection) {
            this.selectionManager.select(newSelection);
        }
    }

    void editorSelectionChanged(SelectionChangedEvent event) {
        JpaSelection newSelection = this.calculateSelection();
        if (newSelection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = newSelection;
        if (this.forwardSelection) {
            this.selectionManager.select(newSelection);
        }
    }

    private class EditorInputListener
    implements IPropertyListener {
        EditorInputListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (source == TextEditorSelectionParticipant.this.textEditor && propId == 258) {
                TextEditorSelectionParticipant.this.editorInputChanged();
            }
        }
    }

    private class EditorSelectionListener
    implements ISelectionChangedListener {
        EditorSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TextEditorSelectionParticipant.this.editorSelectionChanged(event);
        }
    }
}

