/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.structure;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.resource.persistence.PersistenceResourceModel;
import org.eclipse.jpt.ui.internal.jface.AbstractTreeItemContentProvider;
import org.eclipse.jpt.ui.internal.jface.DelegatingTreeContentAndLabelProvider;
import org.eclipse.jpt.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProvider;
import org.eclipse.jpt.ui.jface.TreeItemContentProviderFactory;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

public class PersistenceItemContentProviderFactory
implements TreeItemContentProviderFactory {
    public TreeItemContentProvider buildItemContentProvider(Object item, DelegatingContentAndLabelProvider contentAndLabelProvider) {
        DelegatingTreeContentAndLabelProvider treeContentProvider = (DelegatingTreeContentAndLabelProvider)contentAndLabelProvider;
        if (item instanceof PersistenceResourceModel) {
            return new PersistenceResourceModelItemContentProvider((PersistenceResourceModel)item, treeContentProvider);
        }
        if (item instanceof Persistence) {
            return new PersistenceItemContentProvider((Persistence)item, treeContentProvider);
        }
        if (item instanceof PersistenceUnit) {
            return new PersistenceUnitItemContentProvider((PersistenceUnit)item, treeContentProvider);
        }
        if (item instanceof MappingFileRef) {
            return new MappingFileRefItemContentProvider((MappingFileRef)item, treeContentProvider);
        }
        if (item instanceof ClassRef) {
            return new ClassRefItemContentProvider((ClassRef)item, treeContentProvider);
        }
        return null;
    }

    public static class ClassRefItemContentProvider
    extends AbstractTreeItemContentProvider {
        public ClassRefItemContentProvider(ClassRef classRef, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)classRef, contentProvider);
        }

        public Object getParent() {
            return ((ClassRef)this.model()).getPersistenceUnit();
        }

        public boolean hasChildren() {
            return false;
        }
    }

    public static class MappingFileRefItemContentProvider
    extends AbstractTreeItemContentProvider {
        public MappingFileRefItemContentProvider(MappingFileRef mappingFileRef, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)mappingFileRef, contentProvider);
        }

        public Object getParent() {
            return ((MappingFileRef)this.model()).getPersistenceUnit();
        }

        public boolean hasChildren() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistenceItemContentProvider
    extends AbstractTreeItemContentProvider<PersistenceUnit> {
        public PersistenceItemContentProvider(Persistence persistence, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)persistence, contentProvider);
        }

        @Override
        public Object getParent() {
            return null;
        }

        @Override
        protected ListValueModel<PersistenceUnit> buildChildrenModel() {
            return new ListAspectAdapter<Persistence, PersistenceUnit>("persistenceUnits", (Persistence)this.model()){

                protected ListIterator<PersistenceUnit> listIterator_() {
                    return ((Persistence)this.subject).persistenceUnits();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistenceResourceModelItemContentProvider
    extends AbstractTreeItemContentProvider<JpaStructureNode> {
        public PersistenceResourceModelItemContentProvider(PersistenceResourceModel persistenceResourceModel, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)persistenceResourceModel, contentProvider);
        }

        @Override
        public Object getParent() {
            return null;
        }

        @Override
        protected ListValueModel<JpaStructureNode> buildChildrenModel() {
            return new ListAspectAdapter<PersistenceResourceModel, JpaStructureNode>("rootStructureNodes", (PersistenceResourceModel)this.model()){

                protected ListIterator<JpaStructureNode> listIterator_() {
                    return ((PersistenceResourceModel)this.subject).rootStructureNodes();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PersistenceUnitItemContentProvider
    extends AbstractTreeItemContentProvider<JpaStructureNode> {
        public PersistenceUnitItemContentProvider(PersistenceUnit persistenceUnit, DelegatingTreeContentAndLabelProvider contentProvider) {
            super((Model)persistenceUnit, contentProvider);
        }

        public Persistence getParent() {
            return ((PersistenceUnit)this.model()).getParent();
        }

        @Override
        protected ListValueModel<JpaStructureNode> buildChildrenModel() {
            ListAspectAdapter<PersistenceUnit, JpaStructureNode> specifiedMappingFileLvm = new ListAspectAdapter<PersistenceUnit, JpaStructureNode>("specifiedMappingFileRefs", (PersistenceUnit)this.model()){

                protected ListIterator<JpaStructureNode> listIterator_() {
                    return new ReadOnlyCompositeListIterator(new ListIterator[]{((PersistenceUnit)this.subject).specifiedMappingFileRefs()});
                }
            };
            CollectionListValueModelAdapter impliedMappingFileLvm = new CollectionListValueModelAdapter((CollectionValueModel)new PropertyCollectionValueModelAdapter((PropertyValueModel)new PropertyAspectAdapter<PersistenceUnit, JpaStructureNode>("impliedMappingFileRef", (PersistenceUnit)this.model()){

                protected JpaStructureNode buildValue_() {
                    return ((PersistenceUnit)this.subject).getImpliedMappingFileRef();
                }
            }));
            ListAspectAdapter<PersistenceUnit, JpaStructureNode> classLvm = new ListAspectAdapter<PersistenceUnit, JpaStructureNode>(new String[]{"specifiedClassRefs", "impliedClassRefs"}, (PersistenceUnit)this.model()){

                protected ListIterator<JpaStructureNode> listIterator_() {
                    return new ReadOnlyCompositeListIterator(new ListIterator[]{((PersistenceUnit)this.subject).classRefs()});
                }
            };
            ArrayList<ListAspectAdapter> list = new ArrayList<ListAspectAdapter>();
            list.add(specifiedMappingFileLvm);
            list.add((ListAspectAdapter)impliedMappingFileLvm);
            list.add(classLvm);
            return new CompositeListValueModel(list);
        }
    }
}

