/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.swt;

import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFieldModelAdapter {
    protected final WritablePropertyValueModel<String> textHolder;
    protected final PropertyChangeListener propertyChangeListener;
    protected final Text textField;
    protected final ModifyListener textFieldModifyListener;
    protected final DisposeListener textFieldDisposeListener;

    public static TextFieldModelAdapter adapt(WritablePropertyValueModel<String> textHolder, Text textField) {
        return new TextFieldModelAdapter(textHolder, textField);
    }

    protected TextFieldModelAdapter(WritablePropertyValueModel<String> textHolder, Text textField) {
        if (textHolder == null || textField == null) {
            throw new NullPointerException();
        }
        this.textHolder = textHolder;
        this.textField = textField;
        this.propertyChangeListener = this.buildPropertyChangeListener();
        this.textHolder.addPropertyChangeListener("value", this.propertyChangeListener);
        this.textFieldModifyListener = this.buildTextFieldModifyListener();
        this.textField.addModifyListener(this.textFieldModifyListener);
        this.textFieldDisposeListener = this.buildTextFieldDisposeListener();
        this.textField.addDisposeListener(this.textFieldDisposeListener);
        String text = (String)textHolder.getValue();
        this.textField.setText(text == null ? "" : text);
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildPropertyChangeListener_());
    }

    protected PropertyChangeListener buildPropertyChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                TextFieldModelAdapter.this.textChanged(event);
            }

            public String toString() {
                return "text listener";
            }
        };
    }

    protected ModifyListener buildTextFieldModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextFieldModelAdapter.this.textFieldModified(event);
            }

            public String toString() {
                return "text field modify listener";
            }
        };
    }

    protected DisposeListener buildTextFieldDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TextFieldModelAdapter.this.textFieldDisposed(event);
            }

            public String toString() {
                return "text field dispose listener";
            }
        };
    }

    protected void textChanged(PropertyChangeEvent event) {
        String text = (String)event.getNewValue();
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.textField.getText())) {
            this.textField.setText(text);
        }
    }

    protected void textFieldModified(ModifyEvent event) {
        this.textHolder.setValue((Object)this.textField.getText());
    }

    protected void textFieldDisposed(DisposeEvent event) {
        this.textField.removeDisposeListener(this.textFieldDisposeListener);
        this.textField.removeModifyListener(this.textFieldModifyListener);
        this.textHolder.removePropertyChangeListener("value", this.propertyChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.textHolder);
    }
}

