/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.views.structure;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.ui.internal.jface.DelegatingTreeContentAndLabelProvider;
import org.eclipse.jpt.ui.internal.selection.DefaultJpaSelection;
import org.eclipse.jpt.ui.internal.selection.JpaSelection;
import org.eclipse.jpt.ui.internal.views.structure.JpaStructureView;
import org.eclipse.jpt.ui.structure.JpaStructureProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class JpaStructurePage
extends Page
implements ISelectionProvider,
ISelectionChangedListener {
    private JpaStructureProvider structureProvider;
    private ListenerList selectionChangedListeners;
    private Composite control;
    private TreeViewer viewer;
    private JpaStructureView jpaStructureView;

    public JpaStructurePage(JpaStructureView jpaStructureView, JpaStructureProvider structureProvider) {
        this.jpaStructureView = jpaStructureView;
        this.structureProvider = structureProvider;
        this.selectionChangedListeners = new ListenerList();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(this.control, 770);
        this.viewer.setAutoExpandLevel(2);
        DelegatingTreeContentAndLabelProvider contentAndLabelProvider = new DelegatingTreeContentAndLabelProvider(this.structureProvider.getTreeItemContentProviderFactory(), this.structureProvider.getItemLabelProviderFactory());
        this.viewer.setContentProvider((IContentProvider)contentAndLabelProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)contentAndLabelProvider);
        this.viewer.setInput(this.structureProvider.getInput());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.initContextMenu();
    }

    public void dispose() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.structureProvider.dispose();
        super.dispose();
    }

    protected void initContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                JpaStructurePage.this.fillContextMenu(mgr);
            }
        });
        Menu menu = mgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.jpaStructureView.getSite().registerContextMenu(mgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("additions"));
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        this.control.setFocus();
    }

    void select(JpaSelection selection) {
        if (selection.isEmpty()) {
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)selection.getSelectedNode()), true);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public JpaSelection getSelection() {
        ITreeSelection viewerSelection = (ITreeSelection)this.viewer.getSelection();
        if (viewerSelection.isEmpty() || viewerSelection.size() > 1) {
            return JpaSelection.NULL_SELECTION;
        }
        return new DefaultJpaSelection((JpaStructureNode)viewerSelection.getFirstElement());
    }

    public void setSelection(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    protected void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }
}

