/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.widgets;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.ui.internal.widgets.AbstractChooserPane;
import org.eclipse.jpt.ui.internal.widgets.AbstractPane;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassChooserPane<T extends Model>
extends AbstractChooserPane<T> {
    private JavaTypeCompletionProcessor javaTypeCompletionProcessor;

    public ClassChooserPane(AbstractPane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public ClassChooserPane(AbstractPane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    @Override
    protected final Runnable buildBrowseAction() {
        return new Runnable(){

            public void run() {
                ClassChooserPane.this.promptType();
            }
        };
    }

    @Override
    protected Control buildMainControl(Composite container) {
        WritablePropertyValueModel<String> textHolder = this.buildTextHolder();
        textHolder.addPropertyChangeListener("value", this.buildTextChangeListener());
        Text text = this.buildText(container, textHolder);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.javaTypeCompletionProcessor);
        return text;
    }

    private PropertyChangeListener buildTextChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildTextChangeListener_());
    }

    private PropertyChangeListener buildTextChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                IPackageFragmentRoot root;
                if (ClassChooserPane.this.subject() != null && (root = ClassChooserPane.this.packageFragmentRoot()) != null) {
                    ClassChooserPane.this.javaTypeCompletionProcessor.setPackageFragment(root.getPackageFragment(""));
                }
            }
        };
    }

    protected abstract WritablePropertyValueModel<String> buildTextHolder();

    protected IType chooseType() {
        SelectionDialog typeSelectionDialog;
        IPackageFragmentRoot root = this.packageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            typeSelectionDialog = JavaUI.createTypeDialog((Shell)this.shell(), (IRunnableContext)service, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)(this.className() != null ? ClassTools.shortNameForClassNamed((String)this.className()) : ""));
        }
        catch (JavaModelException e) {
            JptUiPlugin.log(e);
            return null;
        }
        typeSelectionDialog.setTitle(JptUiMessages.ClassChooserPane_dialogTitle);
        typeSelectionDialog.setMessage(JptUiMessages.ClassChooserPane_dialogMessage);
        if (typeSelectionDialog.open() == 0) {
            return (IType)typeSelectionDialog.getResult()[0];
        }
        return null;
    }

    protected abstract String className();

    @Override
    protected void initialize() {
        super.initialize();
        this.javaTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
    }

    protected abstract IPackageFragmentRoot packageFragmentRoot();

    protected abstract void promptType();
}

