/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.db.ConnectionAdapter;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.wizards.GenerateEntitiesWizard;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseReconnectWizardPage
extends WizardPage {
    private JpaProject jpaProject;
    private ConnectionProfile profile;
    private ConnectionListener connectionListener;

    public DatabaseReconnectWizardPage(JpaProject jpaProject) {
        super("Database Settings");
        this.jpaProject = jpaProject;
        this.setTitle(JptUiMessages.DatabaseReconnectWizardPage_databaseConnection);
        this.setMessage(JptUiMessages.DatabaseReconnectWizardPage_reconnectToDatabase);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite top = this.createTopLevelComposite(parent);
        this.setControl((Control)top);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        new DatabaseGroup(composite);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.properties_javaPersistenceConnection");
        return composite;
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 30;
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Combo createCombo(Composite container, boolean fillHorizontal) {
        Combo combo = new Combo(container, 2052);
        if (fillHorizontal) {
            combo.setLayoutData((Object)new GridData(768));
        } else {
            combo.setLayoutData((Object)new GridData());
        }
        return combo;
    }

    protected GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    public Collection<Table> getTables() {
        Schema schema = this.getDefaultSchema();
        if (schema != null && schema.getName() != null) {
            return CollectionTools.collection((Iterator)schema.tables());
        }
        return Collections.emptyList();
    }

    private void updateGenerateEntitiesPage(Schema schema) {
        GenerateEntitiesWizard generateEntitiesWizard = (GenerateEntitiesWizard)this.getWizard();
        generateEntitiesWizard.updatePossibleTables(CollectionTools.collection((Iterator)schema.tables()));
    }

    public void dispose() {
        this.removeConnectionListener();
        super.dispose();
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            if (this.profile != null) {
                this.profile.removeConnectionListener(this.connectionListener);
            }
            this.connectionListener = null;
        }
    }

    ConnectionProfile getProjectConnectionProfile() {
        String profileName = this.jpaProject.getDataSource().getConnectionProfileName();
        return this.connectionProfileNamed(profileName);
    }

    ConnectionProfile connectionProfileNamed(String profileName) {
        return JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNamed(profileName);
    }

    Schema getDefaultSchema() {
        return this.getProjectConnectionProfile().getDefaultSchema();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DatabaseGroup {
        private final Group group;
        private final Combo connectionCombo;
        private final Combo schemaCombo;
        private Link addConnectionLink;
        private Link reconnectLink;

        public DatabaseGroup(Composite composite) {
            this.group = new Group(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.group.setLayout((Layout)layout);
            this.group.setLayoutData((Object)new GridData(768));
            this.group.setText(JptUiMessages.DatabaseReconnectWizardPage_database);
            DatabaseReconnectWizardPage.this.createLabel((Composite)this.group, 1, JptUiMessages.DatabaseReconnectWizardPage_connection);
            this.connectionCombo = DatabaseReconnectWizardPage.this.createCombo((Composite)this.group, true);
            this.connectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.this.handleConnectionChange();
                }
            });
            DatabaseReconnectWizardPage.this.createLabel((Composite)this.group, 1, JptUiMessages.DatabaseReconnectWizardPage_schema);
            this.schemaCombo = DatabaseReconnectWizardPage.this.createCombo((Composite)this.group, true);
            this.schemaCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.this.handleSchemaChange();
                }
            });
            DatabaseReconnectWizardPage.this.createLabel((Composite)this.group, 2, JptUiMessages.DatabaseReconnectWizardPage_schemaInfo);
            this.addConnectionLink = new Link((Composite)this.group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.addConnectionLink.setLayoutData((Object)data);
            this.addConnectionLink.setText(JptUiMessages.DatabaseReconnectWizardPage_addConnectionLink);
            this.addConnectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.this.openNewConnectionWizard();
                }
            });
            this.reconnectLink = new Link((Composite)this.group, 0);
            data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.reconnectLink.setLayoutData((Object)data);
            this.reconnectLink.setText(JptUiMessages.DatabaseReconnectWizardPage_reconnectLink);
            this.reconnectLink.setEnabled(false);
            this.reconnectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatabaseGroup.this.openConnectionProfileNamed(DatabaseGroup.this.connectionCombo.getText());
                }
            });
            this.populateConnectionCombo();
            this.populateSchemaCombo();
        }

        private ConnectionProfile connectionProfileNamed(String profileName) {
            return DatabaseReconnectWizardPage.this.connectionProfileNamed(profileName);
        }

        private Iterator<String> dtpConnectionProfileNames() {
            return JptDbPlugin.instance().getConnectionProfileRepository().connectionProfileNames();
        }

        private String getProjectConnectionProfileName() {
            return DatabaseReconnectWizardPage.this.jpaProject.getDataSource().getConnectionProfileName();
        }

        Schema getDefaultSchema() {
            return DatabaseReconnectWizardPage.this.getProjectConnectionProfile().getDefaultSchema();
        }

        private void openConnectionProfileNamed(String connectionProfileName) {
            DatabaseReconnectWizardPage.this.removeConnectionListener();
            DatabaseReconnectWizardPage.this.profile = this.connectionProfileNamed(connectionProfileName);
            DatabaseReconnectWizardPage.this.profile.connect();
            if (DatabaseReconnectWizardPage.this.profile.isActive()) {
                this.populateSchemaCombo();
                DatabaseReconnectWizardPage.this.connectionListener = this.buildConnectionListener();
                DatabaseReconnectWizardPage.this.profile.addConnectionListener(DatabaseReconnectWizardPage.this.connectionListener);
            }
        }

        private void populateConnectionCombo() {
            this.connectionCombo.removeAll();
            Iterator i = CollectionTools.sort(this.dtpConnectionProfileNames());
            while (i.hasNext()) {
                this.connectionCombo.add((String)i.next());
            }
            String connectionName = this.getProjectConnectionProfileName();
            if (!StringTools.stringIsEmpty((String)connectionName)) {
                this.connectionCombo.select(this.connectionCombo.indexOf(connectionName));
                this.reconnectLink.setEnabled(true);
            }
        }

        private void handleConnectionChange() {
            this.reconnectLink.setEnabled(true);
            this.populateSchemaCombo();
        }

        private void handleSchemaChange() {
            ConnectionProfile connectionProfile = this.connectionProfileNamed(this.getConnectionProfileName());
            Schema schema = connectionProfile.getDatabase().schemaNamed(this.getSchemaName());
            DatabaseReconnectWizardPage.this.updateGenerateEntitiesPage(schema);
            DatabaseReconnectWizardPage.this.setPageComplete(true);
        }

        private void populateSchemaCombo() {
            this.schemaCombo.removeAll();
            ConnectionProfile connectionProfile = this.connectionProfileNamed(this.getConnectionProfileName());
            Iterator stream = CollectionTools.sort((Iterator)connectionProfile.getDatabase().schemaNames());
            while (stream.hasNext()) {
                this.schemaCombo.add((String)stream.next());
            }
            Schema schema = this.getDefaultSchema();
            if (schema != null && schema.getName() != null && (schema = connectionProfile.getDatabase().schemaNamed(schema.getName())) != null) {
                this.schemaCombo.select(this.schemaCombo.indexOf(schema.getName()));
                DatabaseReconnectWizardPage.this.updateGenerateEntitiesPage(schema);
                DatabaseReconnectWizardPage.this.setPageComplete(true);
            }
        }

        private String getConnectionProfileName() {
            return this.connectionCombo.getText();
        }

        private String getSchemaName() {
            return this.schemaCombo.getText();
        }

        private void openNewConnectionWizard() {
            String addedProfileName = DTPUiTools.createNewProfile();
            ConnectionProfile addedProfile = this.connectionProfileNamed(addedProfileName);
            if (!addedProfile.isNull()) {
                addedProfile.connect();
                this.populateConnectionCombo();
                this.connectionCombo.select(this.connectionCombo.indexOf(addedProfile.getName()));
                this.handleConnectionChange();
            }
        }

        private ConnectionListener buildConnectionListener() {
            return new ConnectionAdapter(){

                public void opened(ConnectionProfile profile) {
                    if (DatabaseReconnectWizardPage.this.profile.equals(profile)) {
                        DatabaseGroup.this.populateSchemaCombo();
                    }
                }

                public void aboutToClose(ConnectionProfile profile) {
                    if (DatabaseReconnectWizardPage.this.profile.equals(profile)) {
                        DatabaseReconnectWizardPage.this.removeConnectionListener();
                    }
                }
            };
        }
    }
}

