/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.wst.common.project.facet.core.ActionConfig;
import org.eclipse.wst.common.project.facet.core.IActionConfig;
import org.eclipse.wst.common.project.facet.core.IActionDefinition;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.ui.IFacetWizardPage;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.common.project.facet.ui.ProjectFacetsUiManager;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel;
import org.eclipse.wst.common.project.facet.ui.internal.util.EnhancedHyperlink;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;
import org.eclipse.wst.common.project.facet.ui.internal.util.SwtUtil;

public final class FacetsPropertyPage
extends PropertyPage {
    private IFacetedProject project;
    private IFacetedProjectWorkingCopy fpjwc;
    private Composite topComposite;
    private Composite furtherConfigComposite;

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setText(Resources.revertButtonLabel);
    }

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        if (!(element instanceof IProject)) {
            return null;
        }
        IProject project = (IProject)element;
        try {
            this.project = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return null;
        }
        this.topComposite = new Composite(parent, 0);
        this.topComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.topComposite.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 0, 0, 5));
        this.fpjwc = this.project.createWorkingCopy();
        FacetsSelectionPanel facetsSelectionPanel = new FacetsSelectionPanel(this.topComposite, this.fpjwc);
        facetsSelectionPanel.setLayoutData(GridLayoutUtil.gdfill());
        this.fpjwc.addListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetsPropertyPage.this.handleProjectModifiedEvent();
            }
        }, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_MODIFIED});
        this.furtherConfigComposite = new Composite(this.topComposite, 0);
        this.updateFurtherConfigHyperlink();
        this.topComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FacetsPropertyPage.this.handleDisposeEvent();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        return this.topComposite;
    }

    public boolean performOk() {
        final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                FacetsPropertyPage.this.fpjwc.commitChanges(monitor);
            }
        };
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof CoreException) {
                IStatus st = ((CoreException)te).getStatus();
                ErrorDialog.openError((Shell)this.getShell(), (String)Resources.errDlgTitle, (String)st.getMessage(), (IStatus)st);
                FacetUiPlugin.log(st);
            }
            throw new RuntimeException(e.getTargetException());
        }
        return true;
    }

    protected void performApply() {
        this.performOk();
        this.updateFurtherConfigHyperlink();
    }

    protected void performDefaults() {
        this.fpjwc.revertChanges();
        super.performDefaults();
    }

    public boolean isValid() {
        return this.fpjwc.validate().getSeverity() != 4;
    }

    private void handleProjectModifiedEvent() {
        Runnable runnable = new Runnable(){

            public void run() {
                FacetsPropertyPage.this.updateApplyButton();
                FacetsPropertyPage.this.getContainer().updateButtons();
                FacetsPropertyPage.this.updateFurtherConfigHyperlink();
            }
        };
        SwtUtil.runOnDisplayThread(this.topComposite.getDisplay(), runnable);
    }

    private void updateFurtherConfigHyperlink() {
        Control[] controlArray = this.furtherConfigComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        Set base = this.fpjwc.getFacetedProject().getProjectFacets();
        boolean errors = false;
        boolean configPagesAvailable = false;
        if (this.fpjwc.validate().getSeverity() != 4) {
            for (IFacetedProject.Action action : this.fpjwc.getProjectFacetActions()) {
                IStatus result;
                IStatus result2;
                Object config;
                if (!configPagesAvailable) {
                    try {
                        IFacetedProject.Action.Type actionType = action.getType();
                        IProjectFacetVersion fv = action.getProjectFacetVersion();
                        IActionDefinition actiondef = fv.getActionDefinition(base, actionType);
                        if (!ProjectFacetsUiManager.getWizardPages(actiondef.getId()).isEmpty()) {
                            configPagesAvailable = true;
                        }
                    }
                    catch (CoreException e) {
                        FacetUiPlugin.log((Exception)((Object)e));
                    }
                }
                if (errors || (config = action.getConfig()) == null) continue;
                IActionConfig c = null;
                if (config instanceof IActionConfig) {
                    c = (IActionConfig)config;
                } else {
                    IAdapterManager m = Platform.getAdapterManager();
                    String t = IActionConfig.class.getName();
                    c = (IActionConfig)m.loadAdapter(config, t);
                }
                if (c != null && (result2 = c.validate()).getSeverity() == 4) {
                    errors = true;
                }
                ActionConfig c2 = null;
                if (config instanceof ActionConfig) {
                    c2 = (ActionConfig)config;
                } else if (config != null) {
                    IAdapterManager m = Platform.getAdapterManager();
                    String t = ActionConfig.class.getName();
                    c2 = (ActionConfig)m.loadAdapter(config, t);
                }
                if (c2 == null || (result = c2.validate()).getSeverity() != 4) continue;
                errors = true;
            }
        }
        if (configPagesAvailable) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            Color infoBackgroundColor = this.topComposite.getDisplay().getSystemColor(29);
            this.furtherConfigComposite.setLayoutData((Object)GridLayoutUtil.gdhfill());
            this.furtherConfigComposite.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 2, 0, 0));
            Composite subComposite = new Composite(this.furtherConfigComposite, 2048);
            subComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
            subComposite.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(2), 5, 5));
            subComposite.setBackground(infoBackgroundColor);
            Label image = new Label(subComposite, 0);
            image.setBackground(infoBackgroundColor);
            String imageType = errors ? "IMG_OBJS_ERROR_TSK" : "IMG_OBJS_INFO_TSK";
            image.setImage(sharedImages.getImage(imageType));
            EnhancedHyperlink link = new EnhancedHyperlink(subComposite, 0);
            link.setBackground(infoBackgroundColor);
            if (errors) {
                link.setText(Resources.furtherConfigRequired);
            } else {
                link.setText(Resources.furtherConfigAvailable);
            }
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    FacetsPropertyPage.this.handleFurtherConfigHyperlinkEvent();
                }
            });
        } else {
            this.furtherConfigComposite.setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gd(), 0));
        }
        this.topComposite.layout(true, true);
    }

    private void handleFurtherConfigHyperlinkEvent() {
        ModifyFacetedProjectWizard wizard = new ModifyFacetedProjectWizard(this.fpjwc){

            public boolean getShowFacetsSelectionPage() {
                return false;
            }

            public boolean canFinish() {
                return true;
            }

            public boolean performFinish() {
                IWizardPage[] iWizardPageArray = this.getPages();
                int n = iWizardPageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardPage page = iWizardPageArray[n2];
                    IFacetWizardPage facetPage = (IFacetWizardPage)page;
                    facetPage.transferStateToConfig();
                    ++n2;
                }
                return true;
            }
        };
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                this.getButton(16).setText(IDialogConstants.OK_LABEL);
                this.getButton(1).dispose();
                --((GridLayout)parent.getLayout()).numColumns;
            }
        };
        dialog.open();
    }

    private void handleDisposeEvent() {
        this.fpjwc.dispose();
    }

    private static final class Resources
    extends NLS {
        public static String revertButtonLabel;
        public static String furtherConfigAvailable;
        public static String furtherConfigRequired;
        public static String errDlgTitle;

        static {
            Resources.initializeMessages((String)FacetsPropertyPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

