/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.wst.javascript.core.internal.jsparser.lexer.ILexer;
import org.eclipse.wst.javascript.core.internal.jsparser.lexer.LexerException;
import org.eclipse.wst.javascript.core.internal.jsparser.node.EOF;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TBlank;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TCommenttok;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TErrorChar;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TStringLiteral;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TUnterminatedComment;
import org.eclipse.wst.javascript.core.internal.jsparser.node.TUnterminatedStringLiteral;
import org.eclipse.wst.javascript.ui.internal.common.JavaScriptColorPreferences;
import org.eclipse.wst.javascript.ui.internal.common.LexerCacheForJavaScript;
import org.eclipse.wst.javascript.ui.internal.common.TextRange;
import org.eclipse.wst.javascript.ui.internal.common.style.LineStyleProviderForJavaScript;
import org.eclipse.wst.javascript.ui.internal.editor.Logger;

public class JSLineStyleListener
implements LineStyleListener,
IDocumentListener {
    private ISourceViewer fSourceViewer = null;
    protected ArrayList cachedStyles = new ArrayList(100);
    protected int offCachedStylesRegion = 0;
    protected String strOldNodeValue = null;
    protected LexerCacheForJavaScript pcParseCache = null;
    private IDocument fDocument = null;
    private static HashSet boldKeywords = new HashSet();
    private PropertyChangeListener fPreferenceListener = new PropertyChangeListener();

    static {
        int i = 0;
        while (i < LineStyleProviderForJavaScript.keywords.length) {
            boldKeywords.add(LineStyleProviderForJavaScript.keywords[i]);
            ++i;
        }
    }

    public JSLineStyleListener(IDocument document, ISourceViewer sourceViewer) {
        this.fDocument = document;
        if (this.fDocument != null) {
            LexerCacheForJavaScript.getCache(this.fDocument, this.fDocument.get());
            this.fDocument.addDocumentListener((IDocumentListener)this);
            JavaScriptColorPreferences.addPropertyChangeListener(this.fPreferenceListener);
        }
        if (sourceViewer != null) {
            this.setSourceViewer(sourceViewer);
        }
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void documentChanged(DocumentEvent event) {
        try {
            String nv = this.fDocument.get();
            if (nv == null) return;
            if (this.strOldNodeValue == null) {
                this.pcParseCache.notifyChange(nv, 0, 0, nv.length());
                this.cachedStyles.clear();
                this.redrawRegion(0, -2);
            } else {
                int idx = event.getOffset();
                TextRange trRightmostParseChange = this.pcParseCache.notifyChange(nv, idx, event.getLength(), event.getText() != null ? event.getText().length() : 0);
                if (this.cachedStyles.size() > 0) {
                    int csize = this.cachedStyles.size();
                    int offIdx = idx + this.offCachedStylesRegion;
                    StyleRange srOne = (StyleRange)this.cachedStyles.get(0);
                    if (srOne.start > offIdx) {
                        this.cachedStyles.clear();
                    } else {
                        while (csize-- > 0) {
                            srOne = (StyleRange)this.cachedStyles.get(csize);
                            if (srOne.start + srOne.length < offIdx) break;
                            this.cachedStyles.remove(srOne);
                        }
                    }
                }
                if (trRightmostParseChange.right > 0) {
                    int idxEOL = nv.indexOf(10, trRightmostParseChange.offStart);
                    if (idxEOL > trRightmostParseChange.right) {
                        trRightmostParseChange.right = idxEOL;
                    } else if (idxEOL < 0) {
                        trRightmostParseChange.right = nv.length();
                    }
                }
                this.redrawRegion(trRightmostParseChange.offStart, trRightmostParseChange.right);
            }
            this.strOldNodeValue = nv;
            return;
        }
        catch (Exception exc) {
            Logger.logException("Exception in notifyChanged() of LineStyleProviderForJava", exc);
        }
    }

    public void lineGetStyle(LineStyleEvent event) {
        String lineText = event.lineText;
        int offset = event.lineOffset;
        event.styles = this.getStyleRangeArray(offset, lineText);
    }

    protected StyleRange[] getStyleRangeArray(int offset, String text) {
        Vector styleRangeVector = new Vector();
        this.prepareRegions(offset, text.length(), styleRangeVector);
        Object[] styleRangeArray = new StyleRange[styleRangeVector.size()];
        styleRangeVector.copyInto(styleRangeArray);
        return styleRangeArray;
    }

    private void prepareRegions(int offStart, int length, Collection holdResults) {
        Vector<StyleRange> vecTempResults = new Vector<StyleRange>();
        this.prepareRegions2(offStart, length, vecTempResults);
        int veclen = vecTempResults.size();
        if (veclen > 0) {
            StyleRange sr0 = (StyleRange)vecTempResults.elementAt(0);
            sr0 = JSLineStyleListener.returnPrunedStyle(offStart, length, sr0);
            vecTempResults.removeElementAt(0);
            vecTempResults.insertElementAt(sr0, 0);
            StyleRange srE = (StyleRange)vecTempResults.elementAt(veclen - 1);
            srE = JSLineStyleListener.returnPrunedStyle(offStart, length, srE);
            vecTempResults.removeElementAt(veclen - 1);
            vecTempResults.insertElementAt(srE, veclen - 1);
        }
        int i = 0;
        while (i < vecTempResults.size()) {
            StyleRange styleRange = (StyleRange)vecTempResults.elementAt(i);
            if (styleRange.length > 0) {
                holdResults.add(styleRange);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void prepareRegions2(int offStart, int length, Collection holdResults) {
        startHere = false;
        offMax = offStart + length;
        offStart2 = offStart;
        previousAttr = null;
        offNode = 0;
        try {
            block39: {
                block40: {
                    cacheSize = this.cachedStyles.size();
                    if (cacheSize <= 0) break block39;
                    if (this.offCachedStylesRegion != offNode) {
                        delta = offNode - this.offCachedStylesRegion;
                        sidx = 0;
                        while (sidx < cacheSize) {
                            sr = (StyleRange)this.cachedStyles.get(sidx);
                            sr.start += delta;
                            ++sidx;
                        }
                    }
                    this.offCachedStylesRegion = offNode;
                    srLastCached = (StyleRange)this.cachedStyles.get(cacheSize - 1);
                    if (((StyleRange)this.cachedStyles.get((int)0)).start > offStart || offStart >= srLastCached.start + srLastCached.length) break block40;
                    ii = 0;
                    srOne = null;
                    iihigh = cacheSize - 1;
                    iilow = 0;
                    while (true) {
                        ii = (iihigh + iilow) / 2;
                        srOne = (StyleRange)this.cachedStyles.get(ii);
                        if (srOne.start > offStart) {
                            iihigh = ii;
                            continue;
                        }
                        if (srOne.start + srOne.length > offStart) ** GOTO lbl37
                        iilow = ii + 1;
                    }
lbl-1000:
                    // 1 sources

                    {
                        holdResults.add(JSLineStyleListener.returnPrunedStyle(offStart, length, srOne));
                        if (++ii >= cacheSize) break;
                        srOne = (StyleRange)this.cachedStyles.get(ii);
lbl37:
                        // 2 sources

                        ** while (srOne.start < offMax)
                    }
lbl38:
                    // 2 sources

                    if (srOne.start + srOne.length >= offMax) {
                        return;
                    }
                    offStart2 = srOne.start + srOne.length;
                    if (cacheSize > 150) {
                        this.cachedStyles.clear();
                    }
                    startHere = true;
                    break block39;
                }
                if (cacheSize > 150 || ((StyleRange)this.cachedStyles.get((int)0)).start > offStart) {
                    this.cachedStyles.clear();
                } else if (srLastCached.start + srLastCached.length + 2 < offStart) {
                    this.cachedStyles.clear();
                } else {
                    offStart2 = srLastCached.start + srLastCached.length;
                    startHere = true;
                }
            }
            styleRange = null;
            offsReq = offStart2 - offNode;
            offsMax = offMax - offNode;
            lexer2 = this.getParseStartPoint(offStart2, startHere);
            if (lexer2 == null) {
                return;
            }
            tkThis = lexer2.next();
            while (tkThis.getLPOffset() < offsMax + 200) {
                strTkThis = tkThis.toString();
                offsTkThis = tkThis.getLPOffset();
                offsTkThisEnd = offsTkThis + strTkThis.length();
                attr = null;
                if (offsTkThisEnd > offsReq) {
                    attr = JavaScriptColorPreferences.taDefault;
                    if (tkThis instanceof TStringLiteral) {
                        attr = JavaScriptColorPreferences.taStringLit;
                    } else if (tkThis instanceof TBlank) {
                        if (styleRange != null && (styleRange.background == attr.getBackground() || styleRange.background != null && attr.getBackground() != null && styleRange.background.equals((Object)attr.getBackground())) && attr.getStyle() == styleRange.fontStyle) {
                            attr = previousAttr;
                        }
                    } else if (tkThis instanceof TCommenttok) {
                        attr = JavaScriptColorPreferences.taComment;
                    } else if (tkThis instanceof TUnterminatedComment) {
                        attr = JavaScriptColorPreferences.taUnfComment;
                    } else if (tkThis instanceof TUnterminatedStringLiteral) {
                        attr = JavaScriptColorPreferences.taUnfComment;
                    } else if (tkThis instanceof TErrorChar) {
                        attr = JavaScriptColorPreferences.taUnfComment;
                    } else if (JSLineStyleListener.boldKeywords.contains(strTkThis)) {
                        attr = JavaScriptColorPreferences.taKeyword;
                    }
                    if (styleRange != null && previousAttr != null && previousAttr.equals((Object)attr)) {
                        styleRange.length += strTkThis.length();
                    } else {
                        styleRange = new StyleRange(offNode + offsTkThis, strTkThis.length(), attr.getForeground(), attr.getBackground(), attr.getStyle());
                        if ((attr.getStyle() & 0x20000000) != 0) {
                            styleRange.strikeout = true;
                        }
                        if ((attr.getStyle() & 0x40000000) != 0) {
                            styleRange.underline = true;
                        }
                        if (offsTkThis < offsMax) {
                            holdResults.add(styleRange);
                        }
                        this.cachedStyles.add(styleRange);
                        previousAttr = attr;
                    }
                }
                if (!((tkThis = lexer2.next()) instanceof EOF)) {
                    continue;
                }
                break;
            }
        }
        catch (IOException exc) {
            Logger.logException(exc);
        }
        catch (LexerException exc) {
            Logger.logException(exc);
        }
        catch (Exception exc) {
            Logger.logException("Exception in JavaScript prepareRegions()", exc);
        }
    }

    protected ILexer getParseStartPoint(int offStart, boolean startHere) {
        if (this.pcParseCache == null) {
            this.pcParseCache = LexerCacheForJavaScript.getCache(this.fDocument, this.fDocument.get());
            if (this.fDocument != null) {
                this.strOldNodeValue = this.fDocument.get();
                this.pcParseCache.notifyChange(this.strOldNodeValue, -1, 0, 0);
            }
        }
        return this.pcParseCache.getParser(offStart, startHere);
    }

    private void handlePropertyChange(PropertyChangeEvent event) {
        if (event != null) {
            String prefKey = event.getProperty();
            if (JavaScriptColorPreferences.isJavaScriptColorPreference(prefKey)) {
                StyledText textWidget;
                this.cachedStyles.clear();
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer != null && (textWidget = sourceViewer.getTextWidget()) != null) {
                    textWidget.redraw();
                }
            }
        } else {
            StyledText textWidget;
            this.cachedStyles.clear();
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer != null && (textWidget = sourceViewer.getTextWidget()) != null) {
                textWidget.redraw();
            }
        }
    }

    public static StyleRange returnPrunedStyle(int offRegStart, int lenReg, StyleRange srIn) {
        int intSRStart = srIn.start;
        int intSREnd = srIn.start + srIn.length;
        if (intSRStart < offRegStart) {
            intSRStart = offRegStart;
        }
        if (intSREnd > offRegStart + lenReg) {
            intSREnd = offRegStart + lenReg;
        }
        if (intSRStart == srIn.start && intSREnd == srIn.start + srIn.length) {
            return srIn;
        }
        StyleRange retval = (StyleRange)srIn.clone();
        retval.start = intSRStart;
        retval.length = intSREnd - intSRStart;
        return retval;
    }

    protected void setSourceViewer(ISourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
    }

    protected ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected void redrawRegion(int start, int idxEnd) {
        int difflen = 0;
        if (idxEnd == -1) {
            return;
        }
        if (idxEnd >= 0) {
            difflen = idxEnd - start;
        } else {
            IRegion visibleRegion = null;
            ISourceViewer viewer = this.getSourceViewer();
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                visibleRegion = extension.getModelCoverage();
            } else {
                visibleRegion = this.getSourceViewer().getVisibleRegion();
            }
            if (idxEnd == -2) {
                start = visibleRegion.getOffset();
                difflen = visibleRegion.getLength();
            } else if (idxEnd == -3) {
                int start2 = visibleRegion.getOffset();
                difflen = start2 + visibleRegion.getLength() - start;
            } else {
                return;
            }
        }
        int end = start + difflen;
        int actualEnd = this.getSourceViewer().getTextWidget().getCharCount();
        if (end > actualEnd) {
            difflen = actualEnd - start;
        }
        this.getSourceViewer().getTextWidget().redrawRange(start, difflen, true);
        try {
            int lastLineStart = this.getDocument().getLineOffset(this.getDocument().getLineOfOffset(start + difflen));
            int length = start + difflen - lastLineStart;
            this.getSourceViewer().getTextWidget().redrawRange(lastLineStart, length, true);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void dispose() {
        JavaScriptColorPreferences.removePropertyChangeListener(this.fPreferenceListener);
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener((IDocumentListener)this);
            LexerCacheForJavaScript.release(this.fDocument);
        }
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            JSLineStyleListener.this.handlePropertyChange(event);
        }
    }
}

