/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.ui.internal.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.model.GlobalPreferences;
import org.eclipse.wst.validation.internal.ui.DelegatingValidatorPreferencesDialog;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;
import org.eclipse.wst.validation.ui.internal.ValUIMessages;
import org.eclipse.wst.validation.ui.internal.dialog.FilterDialog;

public class ValidationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IValidationPage _pageImpl = null;
    private Shell _shell;

    protected Control createContents(Composite parent) {
        try {
            this._shell = parent.getShell();
            this._pageImpl = new ValidatorListPage(parent);
        }
        catch (Exception exc) {
            this._pageImpl = new InvalidPage(parent);
            this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
        }
        return this._pageImpl.getControl();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        try {
            this._pageImpl.performDefaults();
        }
        catch (Exception exc) {
            this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
        }
    }

    public boolean performOk() {
        try {
            return this._pageImpl.performOk();
        }
        catch (Exception exc) {
            this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
            return false;
        }
    }

    public void dispose() {
        super.dispose();
        try {
            if (this._pageImpl != null) {
                this._pageImpl.dispose();
                this._pageImpl = null;
            }
        }
        catch (Exception exc) {
            this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
        }
    }

    private void logError(Throwable exc) {
        ValidationUIPlugin.getPlugin().handleException(exc);
    }

    void displayAndLogError(String title, String message, Throwable exc) {
        this.logError(exc);
        this.displayMessage(title, message, 1);
    }

    private void displayMessage(String title, String message, int iIconType) {
        MessageBox messageBox = new MessageBox(this.getShell(), 0x20 | iIconType | 0x10000);
        messageBox.setMessage(message);
        messageBox.setText(title);
        messageBox.open();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this._pageImpl == null) {
            return;
        }
        if (visible) {
            this._pageImpl.gainFocus();
        } else {
            this._pageImpl.loseFocus();
        }
    }

    protected Button getDefaultsButton() {
        return super.getDefaultsButton();
    }

    public static interface IValidationPage {
        public Composite createPage(Composite var1) throws InvocationTargetException;

        public boolean performOk() throws InvocationTargetException;

        public boolean performDefaults() throws InvocationTargetException;

        public Composite getControl();

        public void dispose();

        public void loseFocus();

        public void gainFocus();
    }

    public class InvalidPage
    implements IValidationPage {
        private Composite page = null;
        private Composite composite = null;
        private GridLayout layout = null;
        private Label messageLabel = null;

        public InvalidPage(Composite parent) {
            this.page = this.createPage(parent);
        }

        public Composite createPage(Composite parent) {
            ValidationPreferencePage.this.noDefaultAndApplyButton();
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this.composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this.composite);
            this.layout = new GridLayout();
            this.composite.setLayout((Layout)this.layout);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "org.eclipse.wst.common.frameworks.ui.jvpp0000");
            this.messageLabel = new Label(this.composite, 0);
            this.messageLabel.setText(ValUIMessages.VBF_EXC_INVALID_REGISTER);
            this.composite.setSize(this.composite.computeSize(-1, -1));
            return this.composite;
        }

        public boolean performDefaults() {
            return true;
        }

        public boolean performOk() {
            return true;
        }

        public Composite getControl() {
            return this.page;
        }

        public void dispose() {
            this.messageLabel.dispose();
            this.composite.dispose();
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }
    }

    private class ValidatorListPage
    implements IValidationPage {
        private Composite _page;
        private Composite _composite;
        private TableViewer _validatorList;
        private Button _enableAllButton;
        private Button _disableAllButton;
        private Button _override;
        private Button _suspend;
        private Button _autoSave;
        private Button _confirmButton;
        private Label _listLabel;
        private Table _validatorsTable;
        private GlobalPreferences _globalPreferences = ValManager.getDefault().getGlobalPreferences();
        private GlobalConfiguration _globalConfig;
        private Validator[] _validators;

        public ValidatorListPage(Composite parent) throws InvocationTargetException {
            this._page = this.createPage(parent);
        }

        private void setupTableColumns(Table table) {
            TableColumn validatorColumn = new TableColumn(table, 0);
            validatorColumn.setText(ValUIMessages.VALIDATOR);
            validatorColumn.setResizable(false);
            validatorColumn.setWidth(320);
            TableColumn manualColumn = new TableColumn(table, 0);
            manualColumn.setText(ValUIMessages.MANUAL);
            manualColumn.setResizable(false);
            manualColumn.setWidth(40);
            TableColumn buildColumn = new TableColumn(table, 0);
            buildColumn.setText(ValUIMessages.BUILD);
            buildColumn.setResizable(false);
            buildColumn.setWidth(40);
            TableColumn settingsColumn = new TableColumn(table, 0x1000000);
            settingsColumn.setText(ValUIMessages.SETTINGS);
            settingsColumn.setResizable(false);
            settingsColumn.setWidth(50);
        }

        public Composite createPage(Composite parent) throws InvocationTargetException {
            this._globalConfig = new GlobalConfiguration(ConfigurationManager.getManager().getGlobalConfiguration());
            this._validators = this.copyValidators(ValManager.getDefault().getValidators());
            ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
            sc1.setLayoutData((Object)new GridData(1808));
            this._composite = new Composite((Composite)sc1, 0);
            sc1.setContent((Control)this._composite);
            this._composite.setLayout((Layout)new GridLayout());
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._composite, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            Composite validatorGroup = new Composite(this._composite, 0);
            GridLayout validatorGroupLayout = new GridLayout();
            validatorGroupLayout.numColumns = 2;
            validatorGroup.setLayout((Layout)validatorGroupLayout);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)validatorGroup, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            new Label(validatorGroup, 0).setLayoutData((Object)new GridData());
            this.addOverride(validatorGroup);
            this.addSuspend(validatorGroup);
            this.addAutoSave(validatorGroup);
            this.addConfirm(validatorGroup);
            this._listLabel = new Label(validatorGroup, 0);
            GridData listLabelData = new GridData(768);
            listLabelData.horizontalSpan = 2;
            this._listLabel.setLayoutData((Object)listLabelData);
            this._listLabel.setText(ValUIMessages.PREF_VALLIST_TITLE);
            this._validatorsTable = new Table(validatorGroup, 67584);
            TableLayout tableLayout = new TableLayout();
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(160, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            this._validatorsTable.setHeaderVisible(true);
            this._validatorsTable.setLinesVisible(true);
            this._validatorsTable.setLayout((Layout)tableLayout);
            this._validatorList = new TableViewer(this._validatorsTable);
            GridData validatorListData = new GridData(768);
            validatorListData.horizontalSpan = 2;
            this._validatorsTable.setLayoutData((Object)validatorListData);
            this._validatorList.getTable().setLayoutData((Object)validatorListData);
            this._validatorList.setLabelProvider((IBaseLabelProvider)new ValidationLabelProvider());
            this._validatorList.setContentProvider((IContentProvider)new ValidationContentProvider());
            this._validatorList.setSorter((ViewerSorter)new ValidationViewerSorter());
            this.setupTableColumns(this._validatorsTable);
            this._validatorList.setInput((Object)this._validators);
            this._validatorsTable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    int columnNumber;
                    if (e.button != 1) {
                        return;
                    }
                    TableItem tableItem = ValidatorListPage.this._validatorsTable.getItem(new Point(e.x, e.y));
                    if (tableItem == null || tableItem.isDisposed()) {
                        return;
                    }
                    int columnsCount = ValidatorListPage.this._validatorsTable.getColumnCount();
                    if (columnsCount == 0) {
                        columnNumber = 0;
                    } else {
                        columnNumber = -1;
                        int i = 0;
                        while (i < columnsCount) {
                            Rectangle bounds = tableItem.getBounds(i);
                            if (bounds.contains(e.x, e.y)) {
                                columnNumber = i;
                                break;
                            }
                            ++i;
                        }
                        if (columnNumber == -1) {
                            return;
                        }
                    }
                    ValidatorListPage.this.columnClicked(columnNumber);
                }
            });
            this._validatorsTable.setMenu(this.createContextMenu());
            this._validatorsTable.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    super.focusGained(e);
                    if (ValidatorListPage.this._validatorsTable.getSelectionCount() == 0) {
                        ValidatorListPage.this._validatorsTable.select(0);
                    }
                }
            });
            this._enableAllButton = new Button(validatorGroup, 8);
            this._enableAllButton.setLayoutData((Object)new GridData());
            this._enableAllButton.setText(ValUIMessages.PREF_BUTTON_ENABLEALL);
            this._enableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        ValidatorListPage.this.performEnableAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidationPreferencePage.this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._enableAllButton, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            this._disableAllButton = new Button(validatorGroup, 8);
            this._disableAllButton.setLayoutData((Object)new GridData());
            this._disableAllButton.setText(ValUIMessages.PREF_BUTTON_DISABLEALL);
            this._disableAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        ValidatorListPage.this.performDisableAll();
                    }
                    catch (InvocationTargetException exc) {
                        ValidationPreferencePage.this.displayAndLogError(ValUIMessages.VBF_EXC_INTERNAL_TITLE, ValUIMessages.VBF_EXC_INTERNAL_PAGE, exc);
                    }
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._disableAllButton, "org.eclipse.wst.common.frameworks.ui.jvgp0000");
            validatorGroup.setTabList(new Control[]{this._suspend, this._autoSave, this._validatorList.getTable(), this._enableAllButton, this._disableAllButton});
            this.updateWidgets();
            ValidationPreferencePage.this.applyDialogFont(this._composite);
            this._composite.setSize(this._composite.computeSize(-1, -1));
            return sc1;
        }

        private Validator[] copyValidators(Validator[] vals) {
            Validator[] copy = new Validator[vals.length];
            int i = 0;
            while (i < vals.length) {
                copy[i] = vals[i].copy();
                ++i;
            }
            return copy;
        }

        private void addConfirm(Composite validatorGroup) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this._confirmButton = new Button(validatorGroup, 32);
            this._confirmButton.setLayoutData((Object)gd);
            this._confirmButton.setText(ValUIMessages.PrefPageConfirmDialog);
            this._confirmButton.setSelection(this._globalPreferences.getConfirmDialog());
            this._confirmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ValidatorListPage.this._globalPreferences.setConfirmDialog(ValidatorListPage.this._confirmButton.getSelection());
                    ValidatorListPage.this._confirmButton.setFocus();
                }
            });
        }

        private void addAutoSave(Composite validatorGroup) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this._autoSave = new Button(validatorGroup, 32);
            this._autoSave.setLayoutData((Object)gd);
            this._autoSave.setText(ValUIMessages.PrefPage_always_save);
            this._autoSave.setSelection(this._globalPreferences.getSaveAutomatically());
            this._autoSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ValidatorListPage.this._globalPreferences.setSaveAutomatically(ValidatorListPage.this._autoSave.getSelection());
                    ValidatorListPage.this._autoSave.setFocus();
                }
            });
        }

        private void addSuspend(Composite validatorGroup) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this._suspend = new Button(validatorGroup, 32);
            this._suspend.setLayoutData((Object)gd);
            this._suspend.setText(ValUIMessages.DISABLE_VALIDATION);
            this._suspend.setSelection(this._globalPreferences.getDisableAllValidation());
            this._suspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ValidatorListPage.this._suspend.setFocus();
                    ValidatorListPage.this._validatorsTable.setEnabled(!ValidatorListPage.this._suspend.getSelection());
                    ValidatorListPage.this._enableAllButton.setEnabled(!ValidatorListPage.this._suspend.getSelection());
                    ValidatorListPage.this._disableAllButton.setEnabled(!ValidatorListPage.this._suspend.getSelection());
                    ValidatorListPage.this._validatorList.refresh();
                }
            });
        }

        private void addOverride(Composite validatorGroup) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this._override = new Button(validatorGroup, 32);
            this._override.setLayoutData((Object)gd);
            this._override.setText(ValUIMessages.PREF_BUTTON_OVERRIDE);
            this._override.setEnabled(true);
            this._override.setSelection(this._globalPreferences.getOverride());
            this._override.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ValidatorListPage.this._globalPreferences.setOverride(ValidatorListPage.this._override.getSelection());
                    ValidatorListPage.this._override.setFocus();
                }
            });
        }

        protected Menu createContextMenu() {
            Menu menu = new Menu((Decorations)this._validatorsTable.getShell(), 8);
            final MenuItem manualItem = new MenuItem(menu, 32);
            manualItem.setText(ValUIMessages.PREF_MNU_MANUAL);
            final MenuItem buildItem = new MenuItem(menu, 32);
            buildItem.setText(ValUIMessages.PREF_MNU_BUILD);
            final MenuItem settingsItem = new MenuItem(menu, 8);
            settingsItem.setText(ValUIMessages.PREF_MNU_SETTINGS);
            class MenuItemListener
            extends SelectionAdapter {
                private final /* synthetic */ Menu val$menu;

                MenuItemListener(Menu menu) {
                    this.val$menu = menu;
                }

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.getSource();
                    int index = this.val$menu.indexOf(menuItem) + 1;
                    ValidatorListPage.this.columnClicked(index);
                }
            }
            MenuItemListener listener = new MenuItemListener(menu);
            manualItem.addSelectionListener((SelectionListener)listener);
            buildItem.addSelectionListener((SelectionListener)listener);
            settingsItem.addSelectionListener((SelectionListener)listener);
            menu.addMenuListener((MenuListener)new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)ValidatorListPage.this._validatorList.getSelection();
                    Validator vw = (Validator)selection.getFirstElement();
                    manualItem.setSelection(vw.isManualValidation());
                    buildItem.setSelection(vw.isBuildValidation());
                    settingsItem.setEnabled(ValidatorListPage.this.hasSettings(vw));
                }
            });
            return menu;
        }

        protected void columnClicked(int columnToEdit) {
            IStructuredSelection selection = (IStructuredSelection)this._validatorList.getSelection();
            Validator val = (Validator)selection.getFirstElement();
            switch (columnToEdit) {
                case 1: {
                    val.setManualValidation(!val.isManualValidation());
                    break;
                }
                case 2: {
                    val.setBuildValidation(!val.isBuildValidation());
                    break;
                }
                case 3: {
                    Validator.V2 v2 = val.asV2Validator();
                    if (v2 != null) {
                        FilterDialog fd = new FilterDialog(ValidationPreferencePage.this._shell, val, null);
                        if (fd.open() != 0) break;
                        val.become(fd.getValidator());
                        break;
                    }
                    this.handleOldDelegate(val);
                    break;
                }
            }
            this._validatorList.refresh();
        }

        private void handleOldDelegate(Validator val) {
            Validator.V1 v1 = val.asV1Validator();
            if (v1 == null) {
                return;
            }
            ValidatorMetaData vmd = v1.getVmd();
            if (!vmd.isDelegating()) {
                return;
            }
            String delegateID = this._globalConfig.getDelegateUniqueName(vmd);
            Shell shell = Display.getCurrent().getActiveShell();
            DelegatingValidatorPreferencesDialog dialog = new DelegatingValidatorPreferencesDialog(shell, vmd, delegateID);
            dialog.setBlockOnOpen(true);
            dialog.create();
            int result = dialog.open();
            if (result == 0) {
                this._globalConfig.setDelegateUniqueName(vmd, dialog.getDelegateID());
            }
        }

        boolean hasSettings(Validator v) {
            if (v.asV2Validator() != null) {
                return true;
            }
            return v.getDelegatingId() != null;
        }

        protected void updateWidgets() throws InvocationTargetException {
            this.updateAllWidgets();
            this.updateHelp();
        }

        private void updateAllWidgets() throws InvocationTargetException {
            this._suspend.setSelection(this._globalPreferences.getDisableAllValidation());
            this._autoSave.setSelection(this._globalPreferences.getSaveAutomatically());
            this._confirmButton.setSelection(this._globalPreferences.getConfirmDialog());
            this._override.setSelection(this._globalPreferences.getOverride());
            this._validatorsTable.setEnabled(!this._suspend.getSelection());
            this._enableAllButton.setEnabled(!this._suspend.getSelection());
            this._disableAllButton.setEnabled(!this._suspend.getSelection());
            this._validatorList.setInput((Object)this._validators);
            this._validatorList.refresh();
        }

        public boolean performOk() throws InvocationTargetException {
            this._globalPreferences.setDisableAllValidation(this._suspend.getSelection());
            this._globalPreferences.setSaveAutomatically(this._autoSave.getSelection());
            ValPrefManagerGlobal vpm = ValPrefManagerGlobal.getDefault();
            vpm.savePreferences(this._globalPreferences, this._validators);
            this.saveV1Preferences();
            if (MessageDialog.openQuestion((Shell)ValidationPreferencePage.this._shell, (String)ValUIMessages.RebuildTitle, (String)ValUIMessages.RebuildMsg)) {
                try {
                    ResourcesPlugin.getWorkspace().build(6, null);
                }
                catch (CoreException coreException) {}
            }
            return true;
        }

        private void saveV1Preferences() {
            try {
                GlobalConfiguration gc = ConfigurationManager.getManager().getGlobalConfiguration();
                if (this._globalPreferences.getDisableAllValidation()) {
                    gc.setDisableAllValidation(true);
                }
                gc.setEnabledManualValidators(this.getEnabledManualValidators());
                gc.setEnabledBuildValidators(this.getEnabledBuildValidators());
                gc.passivate();
                gc.store();
            }
            catch (InvocationTargetException e) {
                ValidationUIPlugin.getPlugin().handleException(e);
            }
        }

        private ValidatorMetaData[] getEnabledManualValidators() {
            LinkedList<ValidatorMetaData> list = new LinkedList<ValidatorMetaData>();
            Validator[] validatorArray = this._validators;
            int n = this._validators.length;
            int n2 = 0;
            while (n2 < n) {
                Validator.V1 v1;
                Validator v = validatorArray[n2];
                if (v.isManualValidation() && (v1 = v.asV1Validator()) != null) {
                    list.add(v1.getVmd());
                }
                ++n2;
            }
            ValidatorMetaData[] result = new ValidatorMetaData[list.size()];
            list.toArray(result);
            return result;
        }

        private ValidatorMetaData[] getEnabledBuildValidators() {
            LinkedList<ValidatorMetaData> list = new LinkedList<ValidatorMetaData>();
            Validator[] validatorArray = this._validators;
            int n = this._validators.length;
            int n2 = 0;
            while (n2 < n) {
                Validator.V1 v1;
                Validator v = validatorArray[n2];
                if (v.isBuildValidation() && (v1 = v.asV1Validator()) != null) {
                    list.add(v1.getVmd());
                }
                ++n2;
            }
            ValidatorMetaData[] result = new ValidatorMetaData[list.size()];
            list.toArray(result);
            return result;
        }

        public boolean performDefaults() throws InvocationTargetException {
            this._validators = this.copyValidators(ValManager.getDefaultValidators());
            this.updateWidgets();
            ValidationPreferencePage.this.getDefaultsButton().setFocus();
            return true;
        }

        public boolean performEnableAll() throws InvocationTargetException {
            this.setAllValidators(true);
            this._enableAllButton.setFocus();
            this._validatorList.refresh();
            return true;
        }

        public boolean performDisableAll() throws InvocationTargetException {
            this.setAllValidators(false);
            this._disableAllButton.setFocus();
            this._validatorList.refresh();
            return true;
        }

        private void setAllValidators(boolean bool) {
            Validator[] validatorArray = this._validators;
            int n = this._validators.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                v.setBuildValidation(bool);
                v.setManualValidation(bool);
                ++n2;
            }
        }

        protected void updateHelp() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._suspend, "org.eclipse.wst.common.frameworks.ui.jvgp0010");
        }

        public Composite getControl() {
            return this._page;
        }

        public void dispose() {
            this._autoSave.dispose();
            this._suspend.dispose();
            this._disableAllButton.dispose();
            this._enableAllButton.dispose();
            this._listLabel.dispose();
            this._suspend.dispose();
            this._validatorList.getTable().dispose();
            this._composite.dispose();
        }

        public void loseFocus() {
        }

        public void gainFocus() {
        }

        public class ValidationContentProvider
        implements IStructuredContentProvider {
            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Validator[]) {
                    return (Validator[])inputElement;
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        public class ValidationLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                if (element instanceof Validator) {
                    return ((Validator)element).getName();
                }
                return super.getText(element);
            }

            private Image getImage(String imageName) {
                boolean isDisabled;
                boolean bl = isDisabled = !ValidatorListPage.this._validatorsTable.isEnabled();
                if (isDisabled) {
                    imageName = String.valueOf(imageName) + "_disabled";
                }
                return ValidationUIPlugin.getPlugin().getImage(imageName);
            }

            public Image getColumnImage(Object element, int columnIndex) {
                Validator v = (Validator)element;
                if (columnIndex == 1) {
                    return this.getImage(v.isManualValidation() ? "ok_tbl" : "fail_tbl");
                }
                if (columnIndex == 2) {
                    return this.getImage(v.isBuildValidation() ? "ok_tbl" : "fail_tbl");
                }
                if (columnIndex == 3) {
                    if (ValidatorListPage.this.hasSettings(v)) {
                        return this.getImage("settings");
                    }
                    return null;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return ((Validator)element).getName();
                }
                return null;
            }
        }

        public class ValidationViewerSorter
        extends ViewerSorter {
            public int compare(Viewer viewer, Object e1, Object e2) {
                return super.compare(viewer, e1, e2);
            }
        }
    }
}

