/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.ResourceModel;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceModel
extends AbstractModel
implements ResourceModel {
    private final List<JpaStructureNode> rootStructureNodes = new ArrayList<JpaStructureNode>();

    protected AbstractResourceModel() {
    }

    public abstract Object getResource();

    @Override
    public ListIterator<JpaStructureNode> rootStructureNodes() {
        return new CloneListIterator(this.rootStructureNodes);
    }

    @Override
    public int rootStructureNodesSize() {
        return this.rootStructureNodes.size();
    }

    @Override
    public void addRootStructureNode(JpaStructureNode structureNode) {
        this.addRootStructureNode(this.rootStructureNodes.size(), structureNode);
    }

    @Override
    public void addRootStructureNode(int index, JpaStructureNode structureNode) {
        if (!this.rootStructureNodes.contains(structureNode)) {
            this.addItemToList(index, structureNode, this.rootStructureNodes, "rootStructureNodes");
        }
    }

    public void removeRootStructureNode(JpaStructureNode structureNode) {
        this.removeItemFromList(structureNode, this.rootStructureNodes, "rootStructureNodes");
    }

    public void removeRootStructureNode(int index) {
        this.removeItemFromList(index, this.rootStructureNodes, "rootStructureNodes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        List<JpaStructureNode> list = this.rootStructureNodes;
        synchronized (list) {
            for (JpaStructureNode rootNode : this.rootStructureNodes) {
                JpaStructureNode node = rootNode.getStructureNode(textOffset);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        this.clearList(this.rootStructureNodes, "rootStructureNodes");
    }
}

