/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.utility.internal.StringTools;

public class AsynchronousJpaProjectUpdater
implements JpaProject.Updater {
    protected final JpaProject jpaProject;
    protected final UpdateJob job;

    public AsynchronousJpaProjectUpdater(JpaProject jpaProject) {
        this.jpaProject = jpaProject;
        this.job = this.buildJob();
    }

    protected UpdateJob buildJob() {
        return new UpdateJob();
    }

    public void update() {
        this.job.schedule();
    }

    public void dispose() {
        this.job.setShouldSchedule(false);
        this.job.cancel();
        try {
            this.job.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.jpaProject);
    }

    protected class UpdateJob
    extends Job {
        protected boolean shouldSchedule;

        protected UpdateJob() {
            super("Update JPA project: " + AsynchronousJpaProjectUpdater.this.jpaProject.getName());
            this.shouldSchedule = true;
            this.setRule((ISchedulingRule)AsynchronousJpaProjectUpdater.this.jpaProject.getProject());
        }

        protected IStatus run(IProgressMonitor monitor) {
            return AsynchronousJpaProjectUpdater.this.jpaProject.update(monitor);
        }

        public void setShouldSchedule(boolean shouldSchedule) {
            this.shouldSchedule = shouldSchedule;
        }

        public boolean shouldSchedule() {
            return this.shouldSchedule;
        }
    }
}

