/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.context.AbstractJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.persistence.PersistenceArtifactEdit;
import org.eclipse.jpt.core.resource.persistence.PersistenceResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRootContextNode
extends AbstractJpaContextNode
implements JpaRootContextNode {
    protected final JpaProject jpaProject;
    protected PersistenceXml persistenceXml;
    private boolean okToContinueValidation = true;

    public GenericRootContextNode(JpaProject jpaProject) {
        super(null);
        if (jpaProject == null) {
            throw new IllegalArgumentException("The JPA project must not be null");
        }
        this.jpaProject = jpaProject;
        PersistenceArtifactEdit pae = PersistenceArtifactEdit.getArtifactEditForRead(jpaProject.getProject());
        PersistenceResource pr = pae.getResource();
        if (pr.exists()) {
            this.persistenceXml = this.buildPersistenceXml(pr);
        }
        pae.dispose();
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    @Override
    public IResource getResource() {
        return this.getJpaProject().getProject();
    }

    @Override
    public JpaContextNode getParent() {
        return null;
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return null;
    }

    @Override
    public EntityMappings getEntityMappings() {
        return null;
    }

    @Override
    public OrmPersistentType getOrmPersistentType() {
        return null;
    }

    @Override
    public PersistenceXml getPersistenceXml() {
        return this.persistenceXml;
    }

    protected void setPersistenceXml(PersistenceXml persistenceXml) {
        PersistenceXml old = this.persistenceXml;
        this.persistenceXml = persistenceXml;
        this.firePropertyChanged("persistenceXml", old, persistenceXml);
    }

    @Override
    public PersistenceXml addPersistenceXml() {
        if (this.persistenceXml != null) {
            throw new IllegalStateException();
        }
        PersistenceArtifactEdit pae = PersistenceArtifactEdit.getArtifactEditForWrite(this.getJpaProject().getProject());
        PersistenceResource pr = pae.createDefaultResource();
        pae.dispose();
        PersistenceXml px = this.buildPersistenceXml(pr);
        this.setPersistenceXml(px);
        return px;
    }

    @Override
    public void removePersistenceXml() {
        if (this.persistenceXml == null) {
            throw new IllegalStateException();
        }
        PersistenceArtifactEdit pae = PersistenceArtifactEdit.getArtifactEditForWrite(this.getJpaProject().getProject());
        PersistenceResource pr = pae.getResource();
        pae.dispose();
        try {
            WorkbenchResourceHelper.deleteResource((Resource)pr);
        }
        catch (CoreException ce) {
            JptCorePlugin.log(ce);
        }
        if (!pr.exists()) {
            this.setPersistenceXml(null);
        }
    }

    @Override
    public void update(IProgressMonitor monitor) {
        PersistenceArtifactEdit pae = PersistenceArtifactEdit.getArtifactEditForRead(this.getJpaProject().getProject());
        PersistenceResource pr = pae.getResource();
        if (pr.exists()) {
            if (this.persistenceXml != null) {
                this.persistenceXml.update(pr);
            } else {
                this.setPersistenceXml(this.buildPersistenceXml(pr));
            }
        } else {
            this.setPersistenceXml(null);
        }
        pae.dispose();
    }

    protected PersistenceXml buildPersistenceXml(PersistenceResource persistenceResource) {
        return this.getJpaFactory().buildPersistenceXml(this, persistenceResource);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        this.addNoPersistenceXmlMessage(messages);
        this.addOrphanedJavaClassMessages(messages);
        if (this.okToContinueValidation) {
            this.getPersistenceXml().addToMessages(messages);
        }
    }

    protected void addNoPersistenceXmlMessage(List<IMessage> messages) {
        if (this.persistenceXml == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PROJECT_NO_PERSISTENCE_XML", this));
            this.okToContinueValidation = false;
        }
    }

    protected void addOrphanedJavaClassMessages(List<IMessage> messages) {
    }
}

