/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.GenericJavaPersistentAttribute;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaAttributeMapping<T extends JavaResourceNode>
extends AbstractJavaJpaContextNode
implements JavaAttributeMapping {
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;

    protected AbstractJavaAttributeMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    protected T getMappingResource() {
        if (this.isDefault()) {
            return (T)this.resourcePersistentAttribute.getNullMappingAnnotation(this.getAnnotationName());
        }
        return (T)this.resourcePersistentAttribute.getMappingAnnotation(this.getAnnotationName());
    }

    @Override
    public GenericJavaPersistentAttribute getPersistentAttribute() {
        return (GenericJavaPersistentAttribute)this.getParent();
    }

    protected JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.resourcePersistentAttribute;
    }

    @Override
    public boolean isDefault() {
        return this.getPersistentAttribute().mappingIsDefault(this);
    }

    protected boolean embeddableOwned() {
        return this.getTypeMapping().getKey() == "embeddable";
    }

    protected boolean entityOwned() {
        return this.getTypeMapping().getKey() == "entity";
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getTypeMapping();
    }

    public String getAttributeName() {
        return this.getPersistentAttribute().getName();
    }

    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getMappingResource().getTextRange(astRoot);
        return textRange != null ? textRange : this.getPersistentAttribute().getValidationTextRange(astRoot);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isIdMapping() {
        return false;
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        this.resourcePersistentAttribute = resourcePersistentAttribute;
        this.initialize(this.getMappingResource());
    }

    protected void initialize(T mappingResource) {
    }

    @Override
    public void update(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        this.resourcePersistentAttribute = resourcePersistentAttribute;
        this.update(this.getMappingResource());
    }

    protected void update(T mappingResource) {
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        this.addModifierMessages(messages, astRoot);
        this.addInvalidMappingMessage(messages, astRoot);
    }

    protected void addModifierMessages(List<IMessage> messages, CompilationUnit astRoot) {
        GenericJavaPersistentAttribute attribute = this.getPersistentAttribute();
        if (attribute.getMapping().getKey() != "transient" && this.resourcePersistentAttribute.isForField()) {
            int flags;
            try {
                flags = this.resourcePersistentAttribute.getMember().getJdtMember().getFlags();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            if (Flags.isFinal((int)flags)) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_FINAL_FIELD", new String[]{attribute.getName()}, attribute, attribute.getValidationTextRange(astRoot)));
            }
            if (Flags.isPublic((int)flags)) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_PUBLIC_FIELD", new String[]{attribute.getName()}, attribute, attribute.getValidationTextRange(astRoot)));
            }
        }
    }

    protected void addInvalidMappingMessage(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{this.getPersistentAttribute().getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }
}

