/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.GeneratorAnnotation;
import org.eclipse.jpt.core.utility.TextRange;

public abstract class AbstractJavaGenerator
extends AbstractJavaJpaContextNode
implements JavaGenerator {
    protected String name;
    protected Integer specifiedInitialValue;
    protected Integer specifiedAllocationSize;
    protected GeneratorAnnotation generatorResource;

    protected AbstractJavaGenerator(JavaJpaContextNode parent) {
        super(parent);
    }

    public void initializeFromResource(GeneratorAnnotation generatorResource) {
        this.generatorResource = generatorResource;
        this.name = this.name(generatorResource);
        this.specifiedInitialValue = this.specifiedInitialValue(generatorResource);
        this.specifiedAllocationSize = this.specifiedAllocationSize(generatorResource);
    }

    protected GeneratorAnnotation getGeneratorResource() {
        return this.generatorResource;
    }

    protected String name(GeneratorAnnotation generatorResource) {
        return generatorResource.getName();
    }

    protected Integer specifiedInitialValue(GeneratorAnnotation generatorResource) {
        return generatorResource.getInitialValue();
    }

    protected Integer specifiedAllocationSize(GeneratorAnnotation generatorResource) {
        return generatorResource.getAllocationSize();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.getGeneratorResource().setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    public Integer getInitialValue() {
        return this.getSpecifiedInitialValue() == null ? this.getDefaultInitialValue() : this.getSpecifiedInitialValue();
    }

    public Integer getSpecifiedInitialValue() {
        return this.specifiedInitialValue;
    }

    public void setSpecifiedInitialValue(Integer newSpecifiedInitialValue) {
        Integer oldSpecifiedInitialValue = this.specifiedInitialValue;
        this.specifiedInitialValue = newSpecifiedInitialValue;
        this.getGeneratorResource().setInitialValue(newSpecifiedInitialValue);
        this.firePropertyChanged("specifiedInitialValueProperty", oldSpecifiedInitialValue, newSpecifiedInitialValue);
    }

    protected void setSpecifiedInitialValue_(Integer newSpecifiedInitialValue) {
        Integer oldSpecifiedInitialValue = this.specifiedInitialValue;
        this.specifiedInitialValue = newSpecifiedInitialValue;
        this.firePropertyChanged("specifiedInitialValueProperty", oldSpecifiedInitialValue, newSpecifiedInitialValue);
    }

    public Integer getAllocationSize() {
        return this.getSpecifiedAllocationSize() == null ? this.getDefaultAllocationSize() : this.getSpecifiedAllocationSize();
    }

    public Integer getSpecifiedAllocationSize() {
        return this.specifiedAllocationSize;
    }

    public void setSpecifiedAllocationSize(Integer newSpecifiedAllocationSize) {
        Integer oldSpecifiedAllocationSize = this.specifiedAllocationSize;
        this.specifiedAllocationSize = newSpecifiedAllocationSize;
        this.getGeneratorResource().setAllocationSize(newSpecifiedAllocationSize);
        this.firePropertyChanged("specifiedAllocationSizeProperty", oldSpecifiedAllocationSize, newSpecifiedAllocationSize);
    }

    protected void setSpecifiedAllocationSize_(Integer newSpecifiedAllocationSize) {
        Integer oldSpecifiedAllocationSize = this.specifiedAllocationSize;
        this.specifiedAllocationSize = newSpecifiedAllocationSize;
        this.firePropertyChanged("specifiedAllocationSizeProperty", oldSpecifiedAllocationSize, newSpecifiedAllocationSize);
    }

    public Integer getDefaultAllocationSize() {
        return Generator.DEFAULT_ALLOCATION_SIZE;
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    public TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.generatorResource.getTextRange(astRoot);
    }

    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.generatorResource.getNameTextRange(astRoot);
    }

    protected void update(GeneratorAnnotation generatorResource) {
        this.generatorResource = generatorResource;
        this.setName_(this.name(generatorResource));
        this.setSpecifiedInitialValue_(this.specifiedInitialValue(generatorResource));
        this.setSpecifiedAllocationSize_(this.specifiedAllocationSize(generatorResource));
    }

    public boolean overrides(Generator generator) {
        return false;
    }
}

