/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaNamedColumn;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.NamedColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaNamedColumn<T extends NamedColumnAnnotation>
extends AbstractJavaJpaContextNode
implements JavaNamedColumn {
    protected JavaNamedColumn.Owner owner;
    protected String specifiedName;
    protected String defaultName;
    protected String columnDefinition;

    protected AbstractJavaNamedColumn(JavaJpaContextNode parent, JavaNamedColumn.Owner owner) {
        super(parent);
        this.owner = owner;
    }

    protected void initializeFromResource(T column) {
        this.specifiedName = column.getName();
        this.defaultName = this.defaultName();
        this.columnDefinition = column.getColumnDefinition();
    }

    protected abstract T getColumnResource();

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.getColumnResource().setName(newSpecifiedName);
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultNameProperty", oldDefaultName, newDefaultName);
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String newColumnDefinition) {
        String oldColumnDefinition = this.columnDefinition;
        this.columnDefinition = newColumnDefinition;
        this.getColumnResource().setColumnDefinition(newColumnDefinition);
        this.firePropertyChanged("columnDefinitionProperty", oldColumnDefinition, newColumnDefinition);
    }

    protected void setColumnDefinition_(String newColumnDefinition) {
        String oldColumnDefinition = this.columnDefinition;
        this.columnDefinition = newColumnDefinition;
        this.firePropertyChanged("columnDefinitionProperty", oldColumnDefinition, newColumnDefinition);
    }

    @Override
    public JavaNamedColumn.Owner getOwner() {
        return this.owner;
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getColumnResource().getNameTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.getColumnResource().nameTouches(pos, astRoot);
    }

    @Override
    public Column getDbColumn() {
        Table table = this.getDbTable();
        return table == null ? null : table.columnNamed(this.getName());
    }

    @Override
    public Table getDbTable() {
        return this.getOwner().getDbTable(this.getTableName());
    }

    protected abstract String getTableName();

    @Override
    public boolean isResolved() {
        return this.getDbColumn() != null;
    }

    @Override
    public Iterator<String> connectedCandidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedCandidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.quotedCandidateNames(filter);
        }
        return null;
    }

    private Iterator<String> candidateNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.columnNames() : EmptyIterator.instance();
    }

    private Iterator<String> candidateNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateNames(), filter);
    }

    private Iterator<String> quotedCandidateNames(Filter<String> filter) {
        return StringTools.quote(this.candidateNames(filter));
    }

    protected void update(T column) {
        this.setSpecifiedName_(column.getName());
        this.setDefaultName(this.defaultName());
        this.setColumnDefinition_(column.getColumnDefinition());
    }

    protected String defaultName() {
        return this.getOwner().getDefaultColumnName();
    }
}

