/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.QueryHint;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaQuery;
import org.eclipse.jpt.core.context.java.JavaQueryHint;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.QueryAnnotation;
import org.eclipse.jpt.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaQuery
extends AbstractJavaJpaContextNode
implements JavaQuery {
    protected String name;
    protected String query;
    protected final List<JavaQueryHint> hints = new ArrayList<JavaQueryHint>();
    protected QueryAnnotation queryAnnotation;

    protected AbstractJavaQuery(JavaJpaContextNode parent) {
        super(parent);
    }

    protected QueryAnnotation getQueryResource() {
        return this.queryAnnotation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.queryAnnotation.setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String newQuery) {
        String oldQuery = this.query;
        this.query = newQuery;
        this.queryAnnotation.setQuery(newQuery);
        this.firePropertyChanged("queryProperty", oldQuery, newQuery);
    }

    protected void setQuery_(String newQuery) {
        String oldQuery = this.query;
        this.query = newQuery;
        this.firePropertyChanged("queryProperty", oldQuery, newQuery);
    }

    @Override
    public ListIterator<JavaQueryHint> hints() {
        return new CloneListIterator(this.hints);
    }

    @Override
    public int hintsSize() {
        return this.hints.size();
    }

    @Override
    public JavaQueryHint addHint(int index) {
        JavaQueryHint hint = this.getJpaFactory().buildJavaQueryHint(this);
        this.hints.add(index, hint);
        this.getQueryResource().addHint(index);
        this.fireItemAdded("hintsList", index, hint);
        return hint;
    }

    protected void addHint(int index, JavaQueryHint hint) {
        this.addItemToList(index, hint, this.hints, "hintsList");
    }

    @Override
    public void removeHint(QueryHint queryHint) {
        this.removeHint(this.hints.indexOf(queryHint));
    }

    @Override
    public void removeHint(int index) {
        JavaQueryHint removedHint = this.hints.remove(index);
        this.getQueryResource().removeHint(index);
        this.fireItemRemoved("hintsList", index, removedHint);
    }

    protected void removeHint_(JavaQueryHint hint) {
        this.removeItemFromList(hint, this.hints, "hintsList");
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.hints, (int)targetIndex, (int)sourceIndex);
        this.getQueryResource().moveHint(targetIndex, sourceIndex);
        this.fireItemMoved("hintsList", targetIndex, sourceIndex);
    }

    protected void initializeFromResource(QueryAnnotation queryAnnotation) {
        this.queryAnnotation = queryAnnotation;
        this.name = queryAnnotation.getName();
        this.query = queryAnnotation.getQuery();
        this.initializeQueryHints(queryAnnotation);
    }

    protected void update(QueryAnnotation queryAnnotation) {
        this.queryAnnotation = queryAnnotation;
        this.setName_(queryAnnotation.getName());
        this.setQuery_(queryAnnotation.getQuery());
        this.updateQueryHints(queryAnnotation);
    }

    protected void initializeQueryHints(QueryAnnotation queryResource) {
        ListIterator<QueryHintAnnotation> annotations = queryResource.hints();
        while (annotations.hasNext()) {
            this.hints.add(this.createQueryHint(annotations.next()));
        }
    }

    protected void updateQueryHints(QueryAnnotation queryResource) {
        ListIterator<JavaQueryHint> hints = this.hints();
        ListIterator<QueryHintAnnotation> resourceHints = queryResource.hints();
        while (hints.hasNext()) {
            JavaQueryHint hint = hints.next();
            if (resourceHints.hasNext()) {
                hint.update(resourceHints.next());
                continue;
            }
            this.removeHint_(hint);
        }
        while (resourceHints.hasNext()) {
            this.addHint(this.hintsSize(), this.createQueryHint(resourceHints.next()));
        }
    }

    protected JavaQueryHint createQueryHint(QueryHintAnnotation hintResource) {
        JavaQueryHint queryHint = this.getJpaFactory().buildJavaQueryHint(this);
        queryHint.initializeFromResource(hintResource);
        return queryHint;
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.queryAnnotation.getTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.queryAnnotation.getNameTextRange(astRoot);
    }

    @Override
    public boolean overrides(Query query) {
        return false;
    }
}

