/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.TableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.NameTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTable
extends AbstractJavaJpaContextNode {
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;

    protected AbstractJavaTable(JavaJpaContextNode parent) {
        super(parent);
    }

    protected void initializeFromResource(TableAnnotation table) {
        this.defaultName = this.defaultName();
        this.defaultSchema = this.defaultSchema();
        this.defaultCatalog = this.defaultCatalog();
        this.specifiedName = table.getName();
        this.specifiedSchema = table.getSchema();
        this.specifiedCatalog = table.getCatalog();
    }

    protected abstract TableAnnotation getTableResource();

    protected abstract String getAnnotationName();

    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    public String getSpecifiedName() {
        return this.specifiedName;
    }

    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.getTableResource().setName(newSpecifiedName);
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getCatalog() {
        return this.getSpecifiedCatalog() == null ? this.getDefaultCatalog() : this.getSpecifiedCatalog();
    }

    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    public void setSpecifiedCatalog(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        this.getTableResource().setCatalog(newSpecifiedCatalog);
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    protected void setSpecifiedCatalog_(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public String getSchema() {
        return this.getSpecifiedSchema() == null ? this.getDefaultSchema() : this.getSpecifiedSchema();
    }

    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    public void setSpecifiedSchema(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.getTableResource().setSchema(newSpecifiedSchema);
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    protected void setSpecifiedSchema_(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public TextRange getNameTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getTableResource().getNameTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.getTableResource().nameTouches(pos, astRoot);
    }

    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getTableResource().getSchemaTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        return this.getTableResource().schemaTouches(pos, astRoot);
    }

    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getTableResource().getCatalogTextRange(astRoot);
    }

    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        return this.getTableResource().catalogTouches(pos, astRoot);
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultNameProperty", oldDefaultName, newDefaultName);
    }

    protected void setDefaultCatalog(String newDefaultCatalog) {
        String oldDefaultCatalog = this.defaultCatalog;
        this.defaultCatalog = newDefaultCatalog;
        this.firePropertyChanged("defaultCatalogProperty", oldDefaultCatalog, newDefaultCatalog);
    }

    protected void setDefaultSchema(String newDefaultSchema) {
        String oldDefaultSchema = this.defaultSchema;
        this.defaultSchema = newDefaultSchema;
        this.firePropertyChanged("defaultSchemaProperty", oldDefaultSchema, newDefaultSchema);
    }

    protected void update(TableAnnotation table) {
        this.setSpecifiedName_(table.getName());
        this.setSpecifiedSchema_(table.getSchema());
        this.setSpecifiedCatalog_(table.getCatalog());
        this.setDefaultName(this.defaultName());
        this.setDefaultSchema(this.defaultSchema());
        this.setDefaultCatalog(this.defaultCatalog());
    }

    protected abstract String defaultName();

    protected String defaultSchema() {
        if (this.getEntityMappings() != null) {
            return this.getEntityMappings().getSchema();
        }
        return this.getPersistenceUnit().getDefaultSchema();
    }

    protected String defaultCatalog() {
        if (this.getEntityMappings() != null) {
            return this.getEntityMappings().getCatalog();
        }
        return this.getPersistenceUnit().getDefaultCatalog();
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getTableResource().getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public Table getDbTable() {
        Schema schema = this.getDbSchema();
        return schema == null ? null : schema.tableNamed(this.getName());
    }

    public Schema getDbSchema() {
        return this.getDatabase().schemaNamed(this.getSchema());
    }

    public boolean hasResolvedSchema() {
        return this.getDbSchema() != null;
    }

    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public Iterator<String> connectedCandidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedCandidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.quotedCandidateNames(filter);
        }
        if (this.schemaTouches(pos, astRoot)) {
            return this.quotedCandidateSchemas(filter);
        }
        if (this.catalogTouches(pos, astRoot)) {
            return this.quotedCandidateCatalogs(filter);
        }
        return null;
    }

    private Iterator<String> candidateNames() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.tableNames() : EmptyIterator.instance();
    }

    private Iterator<String> candidateNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateNames(), filter);
    }

    private Iterator<String> quotedCandidateNames(Filter<String> filter) {
        return StringTools.quote(this.candidateNames(filter));
    }

    private Iterator<String> candidateSchemas() {
        return this.getDatabase().schemaNames();
    }

    private Iterator<String> candidateSchemas(Filter<String> filter) {
        return new FilteringIterator(this.candidateSchemas(), filter);
    }

    private Iterator<String> quotedCandidateSchemas(Filter<String> filter) {
        return StringTools.quote(this.candidateSchemas(filter));
    }

    private Iterator<String> candidateCatalogs() {
        return this.getDatabase().catalogNames();
    }

    private Iterator<String> candidateCatalogs(Filter<String> filter) {
        return new FilteringIterator(this.candidateCatalogs(), filter);
    }

    private Iterator<String> quotedCandidateCatalogs(Filter<String> filter) {
        return StringTools.quote(this.candidateCatalogs(filter));
    }

    public String getQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getQualifiedName());
    }

    @Override
    public String displayString() {
        return this.getQualifiedName();
    }
}

