/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaBaseJoinColumn;
import org.eclipse.jpt.core.context.java.JavaDiscriminatorColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaGenerator;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaNamedColumn;
import org.eclipse.jpt.core.context.java.JavaNamedNativeQuery;
import org.eclipse.jpt.core.context.java.JavaNamedQuery;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.java.JavaQuery;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.java.JavaSequenceGenerator;
import org.eclipse.jpt.core.context.java.JavaTable;
import org.eclipse.jpt.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.VirtualAttributeOverride;
import org.eclipse.jpt.core.internal.resource.java.NullAssociationOverride;
import org.eclipse.jpt.core.internal.resource.java.NullPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorValueAnnotation;
import org.eclipse.jpt.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.core.resource.java.IdClassAnnotation;
import org.eclipse.jpt.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.NamedNativeQueryAnnotation;
import org.eclipse.jpt.core.resource.java.NamedQueryAnnotation;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.SecondaryTableAnnotation;
import org.eclipse.jpt.core.resource.java.SequenceGeneratorAnnotation;
import org.eclipse.jpt.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaEntity
extends AbstractJavaTypeMapping
implements JavaEntity {
    protected EntityAnnotation entityResource;
    protected String specifiedName;
    protected String defaultName;
    protected final JavaTable table = this.getJpaFactory().buildJavaTable(this);
    protected final List<JavaSecondaryTable> specifiedSecondaryTables;
    protected final List<JavaPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns;
    protected JavaPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String defaultDiscriminatorValue;
    protected boolean discriminatorValueAllowed;
    protected String specifiedDiscriminatorValue;
    protected final JavaDiscriminatorColumn discriminatorColumn = this.buildJavaDiscriminatorColumn();
    protected JavaSequenceGenerator sequenceGenerator;
    protected JavaTableGenerator tableGenerator;
    protected final List<JavaAttributeOverride> specifiedAttributeOverrides;
    protected final List<JavaAttributeOverride> virtualAttributeOverrides;
    protected final List<JavaAssociationOverride> specifiedAssociationOverrides;
    protected final List<JavaAssociationOverride> virtualAssociationOverrides;
    protected final List<JavaNamedQuery> namedQueries;
    protected final List<JavaNamedNativeQuery> namedNativeQueries;
    protected String idClass;

    public GenericJavaEntity(JavaPersistentType parent) {
        super(parent);
        this.specifiedSecondaryTables = new ArrayList<JavaSecondaryTable>();
        this.specifiedPrimaryKeyJoinColumns = new ArrayList<JavaPrimaryKeyJoinColumn>();
        this.specifiedAttributeOverrides = new ArrayList<JavaAttributeOverride>();
        this.virtualAttributeOverrides = new ArrayList<JavaAttributeOverride>();
        this.namedQueries = new ArrayList<JavaNamedQuery>();
        this.namedNativeQueries = new ArrayList<JavaNamedNativeQuery>();
        this.specifiedAssociationOverrides = new ArrayList<JavaAssociationOverride>();
        this.virtualAssociationOverrides = new ArrayList<JavaAssociationOverride>();
    }

    protected JavaBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected JavaDiscriminatorColumn buildJavaDiscriminatorColumn() {
        return this.getJpaFactory().buildJavaDiscriminatorColumn(this, this.buildDiscriminatorColumnOwner());
    }

    protected JavaNamedColumn.Owner buildDiscriminatorColumnOwner() {
        return new JavaNamedColumn.Owner(){

            public org.eclipse.jpt.db.Table getDbTable(String tableName) {
                return GenericJavaEntity.this.getDbTable(tableName);
            }

            public TextRange getValidationTextRange(CompilationUnit astRoot) {
                return GenericJavaEntity.this.getValidationTextRange(astRoot);
            }

            public TypeMapping getTypeMapping() {
                return GenericJavaEntity.this;
            }

            public String getDefaultColumnName() {
                return "DTYPE";
            }
        };
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentType resourcePersistentType) {
        super.initializeFromResource(resourcePersistentType);
        this.entityResource = (EntityAnnotation)resourcePersistentType.getMappingAnnotation("javax.persistence.Entity");
        this.specifiedName = this.specifiedName(this.entityResource);
        this.defaultName = this.defaultName(resourcePersistentType);
        this.defaultInheritanceStrategy = this.defaultInheritanceStrategy();
        this.specifiedInheritanceStrategy = this.specifiedInheritanceStrategy(this.getInheritanceResource());
        this.specifiedDiscriminatorValue = this.getDiscriminatorValueResource().getValue();
        this.defaultDiscriminatorValue = this.javaDefaultDiscriminatorValue();
        this.discriminatorValueAllowed = this.discriminatorValueIsAllowed(resourcePersistentType);
        this.discriminatorColumn.initializeFromResource(resourcePersistentType);
        this.table.initializeFromResource(resourcePersistentType);
        this.initializeSecondaryTables(resourcePersistentType);
        this.initializeTableGenerator(resourcePersistentType);
        this.initializeSequenceGenerator(resourcePersistentType);
        this.initializePrimaryKeyJoinColumns(resourcePersistentType);
        this.initializeDefaultPrimaryKeyJoinColumn(resourcePersistentType);
        this.initializeSpecifiedAttributeOverrides(resourcePersistentType);
        this.initializeVirtualAttributeOverrides(resourcePersistentType);
        this.initializeSpecifiedAssociationOverrides(resourcePersistentType);
        this.initializeDefaultAssociationOverrides(resourcePersistentType);
        this.initializeNamedQueries(resourcePersistentType);
        this.initializeNamedNativeQueries(resourcePersistentType);
        this.initializeIdClass(resourcePersistentType);
        this.updatePersistenceUnitGeneratorsAndQueries();
    }

    protected void initializeSecondaryTables(JavaResourcePersistentType resourcePersistentType) {
        ListIterator annotations = resourcePersistentType.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        while (annotations.hasNext()) {
            this.specifiedSecondaryTables.add(this.buildSecondaryTable((SecondaryTableAnnotation)annotations.next()));
        }
    }

    protected void initializeTableGenerator(JavaResourcePersistentType resourcePersistentType) {
        TableGeneratorAnnotation tableGeneratorResource = this.tableGenerator(resourcePersistentType);
        if (tableGeneratorResource != null) {
            this.tableGenerator = this.buildTableGenerator(tableGeneratorResource);
        }
    }

    protected void initializeSequenceGenerator(JavaResourcePersistentType resourcePersistentType) {
        SequenceGeneratorAnnotation sequenceGeneratorResource = this.sequenceGenerator(resourcePersistentType);
        if (sequenceGeneratorResource != null) {
            this.sequenceGenerator = this.buildSequenceGenerator(sequenceGeneratorResource);
        }
    }

    protected void initializePrimaryKeyJoinColumns(JavaResourcePersistentType resourcePersistentType) {
        ListIterator annotations = resourcePersistentType.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (annotations.hasNext()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)annotations.next()));
        }
    }

    protected boolean shouldBuildDefaultPrimaryKeyJoinColumn() {
        return !this.containsSpecifiedPrimaryKeyJoinColumns();
    }

    protected void initializeDefaultPrimaryKeyJoinColumn(JavaResourcePersistentType persistentTypeResource) {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            return;
        }
        this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumn(persistentTypeResource));
    }

    protected void initializeSpecifiedAttributeOverrides(JavaResourcePersistentType persistentTypeResource) {
        ListIterator annotations = persistentTypeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        while (annotations.hasNext()) {
            this.specifiedAttributeOverrides.add(this.buildAttributeOverride((AttributeOverrideAnnotation)annotations.next()));
        }
    }

    protected void initializeVirtualAttributeOverrides(JavaResourcePersistentType persistentTypeResource) {
        for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
            JavaAttributeOverride attributeOverride = this.attributeOverrideNamed(persistentAttribute.getName());
            if (attributeOverride != null) continue;
            this.virtualAttributeOverrides.add(this.buildVirtualAttributeOverride(persistentTypeResource, persistentAttribute));
        }
    }

    protected void initializeSpecifiedAssociationOverrides(JavaResourcePersistentType resourcePersistentType) {
        ListIterator annotations = resourcePersistentType.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        while (annotations.hasNext()) {
            this.specifiedAssociationOverrides.add(this.buildAssociationOverride((AssociationOverrideAnnotation)annotations.next()));
        }
    }

    protected void initializeDefaultAssociationOverrides(JavaResourcePersistentType resourcePersistentType) {
        Iterator<String> i = this.allOverridableAssociationNames();
        while (i.hasNext()) {
            String associationName = i.next();
            JavaAssociationOverride associationOverride = this.associationOverrideNamed(associationName);
            if (associationOverride != null) continue;
            this.virtualAssociationOverrides.add(this.buildAssociationOverride(new NullAssociationOverride(resourcePersistentType, associationName)));
        }
    }

    protected void initializeNamedQueries(JavaResourcePersistentType resourcePersistentType) {
        ListIterator annotations = resourcePersistentType.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        while (annotations.hasNext()) {
            this.namedQueries.add(this.buildNamedQuery((NamedQueryAnnotation)annotations.next()));
        }
    }

    protected void initializeNamedNativeQueries(JavaResourcePersistentType resourcePersistentType) {
        ListIterator annotations = resourcePersistentType.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        while (annotations.hasNext()) {
            this.namedNativeQueries.add(this.buildNamedNativeQuery((NamedNativeQueryAnnotation)annotations.next()));
        }
    }

    protected InheritanceAnnotation getInheritanceResource() {
        return (InheritanceAnnotation)this.javaResourcePersistentType.getNonNullAnnotation("javax.persistence.Inheritance");
    }

    protected DiscriminatorValueAnnotation getDiscriminatorValueResource() {
        return (DiscriminatorValueAnnotation)this.javaResourcePersistentType.getNonNullAnnotation("javax.persistence.DiscriminatorValue");
    }

    protected void initializeIdClass(JavaResourcePersistentType typeResource) {
        IdClassAnnotation idClassResource = (IdClassAnnotation)typeResource.getAnnotation("javax.persistence.IdClass");
        if (idClassResource != null) {
            this.idClass = idClassResource.getValue();
        }
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getTableName() {
        return this.getTable().getName();
    }

    @Override
    public org.eclipse.jpt.db.Table getPrimaryDbTable() {
        return this.getTable().getDbTable();
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable(String tableName) {
        Iterator<Table> stream = this.associatedTablesIncludingInherited();
        while (stream.hasNext()) {
            org.eclipse.jpt.db.Table dbTable = stream.next().getDbTable();
            if (dbTable == null || !dbTable.matchesShortJavaClassName(tableName)) continue;
            return dbTable;
        }
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return this.getTable().getDbSchema();
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Entity";
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.Table", "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables", "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns", "javax.persistence.IdClass", "javax.persistence.Inheritance", "javax.persistence.DiscriminatorValue", "javax.persistence.DiscriminatorColumn", "javax.persistence.SequenceGenerator", "javax.persistence.TableGenerator", "javax.persistence.NamedQuery", "javax.persistence.NamedQueries", "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries", "javax.persistence.SqlResultSetMapping", "javax.persistence.ExcludeDefaultListeners", "javax.persistence.ExcludeSuperclassListeners", "javax.persistence.EntityListeners", "javax.persistence.PrePersist", "javax.persistence.PostPersist", "javax.persistence.PreRemove", "javax.persistence.PostRemove", "javax.persistence.PreUpdate", "javax.persistence.PostUpdate", "javax.persistence.PostLoad", "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides", "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides"});
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.entityResource.setName(newSpecifiedName);
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    protected void setSpecifiedName_(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultNameProperty", oldDefaultName, newDefaultName);
    }

    @Override
    public JavaTable getTable() {
        return this.table;
    }

    @Override
    public ListIterator<JavaSecondaryTable> specifiedSecondaryTables() {
        return new CloneListIterator(this.specifiedSecondaryTables);
    }

    @Override
    public int specifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTables.size();
    }

    @Override
    public JavaSecondaryTable addSpecifiedSecondaryTable(int index) {
        JavaSecondaryTable secondaryTable = this.getJpaFactory().buildJavaSecondaryTable(this);
        this.specifiedSecondaryTables.add(index, secondaryTable);
        SecondaryTableAnnotation secondaryTableResource = (SecondaryTableAnnotation)this.javaResourcePersistentType.addAnnotation(index, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        secondaryTable.initializeFromResource(secondaryTableResource);
        this.fireItemAdded("specifiedSecondaryTablesList", index, secondaryTable);
        return secondaryTable;
    }

    protected void addSpecifiedSecondaryTable(int index, JavaSecondaryTable secondaryTable) {
        this.addItemToList(index, secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTablesList");
    }

    @Override
    public void removeSpecifiedSecondaryTable(SecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTables.indexOf(secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        JavaSecondaryTable removedSecondaryTable = this.specifiedSecondaryTables.remove(index);
        this.javaResourcePersistentType.removeAnnotation(index, "javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        this.fireItemRemoved("specifiedSecondaryTablesList", index, removedSecondaryTable);
    }

    protected void removeSpecifiedSecondaryTable_(JavaSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTablesList");
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedSecondaryTables, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.move(targetIndex, sourceIndex, "javax.persistence.SecondaryTables");
        this.fireItemMoved("specifiedSecondaryTablesList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<JavaSecondaryTable> secondaryTables() {
        return this.specifiedSecondaryTables();
    }

    @Override
    public int secondaryTablesSize() {
        return this.specifiedSecondaryTablesSize();
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.getSpecifiedInheritanceStrategy() == null ? this.getDefaultInheritanceStrategy() : this.getSpecifiedInheritanceStrategy();
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategyProperty", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        this.getInheritanceResource().setStrategy(InheritanceType.toJavaResourceModel(newInheritanceType));
        this.firePropertyChanged("specifiedInheritanceStrategyProperty", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategyProperty", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    @Override
    public JavaDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String newDefaultDiscriminatorValue) {
        String oldDefaultDiscriminatorValue = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = newDefaultDiscriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValueProperty", oldDefaultDiscriminatorValue, newDefaultDiscriminatorValue);
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        this.getDiscriminatorValueResource().setValue(newSpecifiedDiscriminatorValue);
        this.firePropertyChanged("specifiedDiscriminatorValueProperty", oldSpecifiedDiscriminatorValue, newSpecifiedDiscriminatorValue);
    }

    protected void setSpecifiedDiscriminatorValue_(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        this.firePropertyChanged("specifiedDiscriminatorValueProperty", oldSpecifiedDiscriminatorValue, newSpecifiedDiscriminatorValue);
    }

    @Override
    public String getDiscriminatorValue() {
        return this.getSpecifiedDiscriminatorValue() == null ? this.getDefaultDiscriminatorValue() : this.getSpecifiedDiscriminatorValue();
    }

    @Override
    public boolean isDiscriminatorValueAllowed() {
        return this.discriminatorValueAllowed;
    }

    protected void setDiscriminatorValueAllowed(boolean newDiscriminatorValueAllowed) {
        boolean oldDiscriminatorValueAllowed = this.discriminatorValueAllowed;
        this.discriminatorValueAllowed = newDiscriminatorValueAllowed;
        this.firePropertyChanged("discriminatorValueAllowedProperty", oldDiscriminatorValueAllowed, newDiscriminatorValueAllowed);
    }

    @Override
    public JavaTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        this.tableGenerator = this.getJpaFactory().buildJavaTableGenerator(this);
        TableGeneratorAnnotation tableGeneratorResource = (TableGeneratorAnnotation)this.javaResourcePersistentType.addAnnotation("javax.persistence.TableGenerator");
        this.tableGenerator.initializeFromResource(tableGeneratorResource);
        this.firePropertyChanged("tableGeneratorProperty", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        JavaTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        this.javaResourcePersistentType.removeAnnotation("javax.persistence.TableGenerator");
        this.firePropertyChanged("tableGeneratorProperty", oldTableGenerator, null);
    }

    @Override
    public JavaTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(JavaTableGenerator newTableGenerator) {
        JavaTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGeneratorProperty", oldTableGenerator, newTableGenerator);
    }

    @Override
    public JavaSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        this.sequenceGenerator = this.getJpaFactory().buildJavaSequenceGenerator(this);
        SequenceGeneratorAnnotation sequenceGeneratorResource = (SequenceGeneratorAnnotation)this.javaResourcePersistentType.addAnnotation("javax.persistence.SequenceGenerator");
        this.sequenceGenerator.initializeFromResource(sequenceGeneratorResource);
        this.firePropertyChanged("sequenceGeneratorProperty", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        JavaSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        this.javaResourcePersistentType.removeAnnotation("javax.persistence.SequenceGenerator");
        this.firePropertyChanged("sequenceGeneratorProperty", oldSequenceGenerator, null);
    }

    @Override
    public JavaSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(JavaSequenceGenerator newSequenceGenerator) {
        JavaSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGeneratorProperty", oldSequenceGenerator, newSequenceGenerator);
    }

    protected Iterator<JavaGenerator> generators() {
        return new CompositeIterator(new Iterator[]{this.getSequenceGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getSequenceGenerator()), this.getTableGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getTableGenerator())});
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumns() : this.defaultPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumnsSize() : this.defaultPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<JavaPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.specifiedPrimaryKeyJoinColumns.isEmpty();
    }

    @Override
    public JavaPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return this.defaultPrimaryKeyJoinColumn;
    }

    protected void setDefaultPrimaryKeyJoinColumn(JavaPrimaryKeyJoinColumn newPkJoinColumn) {
        JavaPrimaryKeyJoinColumn oldPkJoinColumn = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = newPkJoinColumn;
        this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldPkJoinColumn, newPkJoinColumn);
    }

    protected ListIterator<JavaPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns() {
        if (this.defaultPrimaryKeyJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultPrimaryKeyJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumn == null ? 0 : 1;
    }

    @Override
    public JavaPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn oldDefaultPkJoinColumn = this.getDefaultPrimaryKeyJoinColumn();
        if (oldDefaultPkJoinColumn != null) {
            this.defaultPrimaryKeyJoinColumn = null;
        }
        JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner());
        this.specifiedPrimaryKeyJoinColumns.add(index, primaryKeyJoinColumn);
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = (PrimaryKeyJoinColumnAnnotation)this.javaResourcePersistentType.addAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        primaryKeyJoinColumn.initializeFromResource(pkJoinColumnResource);
        this.fireItemAdded("specifiedPrimaryKeyJoinColumnsList", index, primaryKeyJoinColumn);
        if (oldDefaultPkJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldDefaultPkJoinColumn, null);
        }
        return primaryKeyJoinColumn;
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(int index, JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumnsList");
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(primaryKeyJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        JavaPrimaryKeyJoinColumn removedPrimaryKeyJoinColumn = this.specifiedPrimaryKeyJoinColumns.remove(index);
        if (!this.containsSpecifiedPrimaryKeyJoinColumns()) {
            this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumn(this.javaResourcePersistentType));
        }
        this.javaResourcePersistentType.removeAnnotation(index, "javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumnsList", index, removedPrimaryKeyJoinColumn);
        if (this.defaultPrimaryKeyJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", null, this.defaultPrimaryKeyJoinColumn);
        }
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(JavaPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeItemFromList(primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumnsList");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        this.javaResourcePersistentType.move(targetIndex, sourceIndex, "javax.persistence.PrimaryKeyJoinColumns");
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumnsList");
    }

    @Override
    public ListIterator<JavaAttributeOverride> attributeOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributeOverrides(), this.virtualAttributeOverrides()});
    }

    @Override
    public int attributeOverridesSize() {
        return this.specifiedAttributeOverridesSize() + this.virtualAttributeOverridesSize();
    }

    @Override
    public ListIterator<JavaAttributeOverride> virtualAttributeOverrides() {
        return new CloneListIterator(this.virtualAttributeOverrides);
    }

    @Override
    public int virtualAttributeOverridesSize() {
        return this.virtualAttributeOverrides.size();
    }

    @Override
    public ListIterator<JavaAttributeOverride> specifiedAttributeOverrides() {
        return new CloneListIterator(this.specifiedAttributeOverrides);
    }

    @Override
    public int specifiedAttributeOverridesSize() {
        return this.specifiedAttributeOverrides.size();
    }

    protected JavaAttributeOverride addSpecifiedAttributeOverride(int index) {
        JavaAttributeOverride attributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this.createAttributeOverrideOwner());
        this.specifiedAttributeOverrides.add(index, attributeOverride);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)this.javaResourcePersistentType.addAnnotation(index, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        attributeOverride.initializeFromResource(attributeOverrideResource);
        this.fireItemAdded("specifiedAttributeOverridesList", index, attributeOverride);
        return attributeOverride;
    }

    protected JavaAttributeOverride setAttributeOverrideVirtual(boolean virtual, JavaAttributeOverride attributeOverride) {
        if (virtual) {
            return this.setAttributeOverrideVirtual(attributeOverride);
        }
        return this.setAttributeOverrideSpecified(attributeOverride);
    }

    protected JavaAttributeOverride setAttributeOverrideVirtual(JavaAttributeOverride attributeOverride) {
        int index = this.specifiedAttributeOverrides.indexOf(attributeOverride);
        this.specifiedAttributeOverrides.remove(index);
        String attributeOverrideName = attributeOverride.getName();
        JavaAttributeOverride virtualAttributeOverride = null;
        if (attributeOverrideName != null) {
            for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
                if (!persistentAttribute.getName().equals(attributeOverrideName)) continue;
                virtualAttributeOverride = this.buildVirtualAttributeOverride(this.javaResourcePersistentType, persistentAttribute);
                this.virtualAttributeOverrides.add(virtualAttributeOverride);
                break;
            }
        }
        this.javaResourcePersistentType.removeAnnotation(index, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        this.fireItemRemoved("specifiedAttributeOverridesList", index, attributeOverride);
        if (virtualAttributeOverride != null) {
            this.fireItemAdded("virtualAttributeOverridesList", this.virtualAttributeOverridesSize() - 1, virtualAttributeOverride);
        }
        return virtualAttributeOverride;
    }

    protected JavaAttributeOverride setAttributeOverrideSpecified(JavaAttributeOverride oldAttributeOverride) {
        int index = this.specifiedAttributeOverridesSize();
        JavaAttributeOverride newAttributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this.createAttributeOverrideOwner());
        this.specifiedAttributeOverrides.add(index, newAttributeOverride);
        AttributeOverrideAnnotation attributeOverrideResource = (AttributeOverrideAnnotation)this.javaResourcePersistentType.addAnnotation(index, "javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        newAttributeOverride.initializeFromResource(attributeOverrideResource);
        int defaultIndex = this.virtualAttributeOverrides.indexOf(oldAttributeOverride);
        this.virtualAttributeOverrides.remove(defaultIndex);
        newAttributeOverride.setName(oldAttributeOverride.getName());
        newAttributeOverride.getColumn().setSpecifiedName(oldAttributeOverride.getColumn().getName());
        this.fireItemRemoved("virtualAttributeOverridesList", defaultIndex, oldAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverridesList", index, newAttributeOverride);
        return newAttributeOverride;
    }

    protected AttributeOverride.Owner createAttributeOverrideOwner() {
        return new AttributeOverrideOwner();
    }

    protected void addSpecifiedAttributeOverride(int index, JavaAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverridesList");
    }

    protected void removeSpecifiedAttributeOverride_(JavaAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverridesList");
    }

    @Override
    public void moveSpecifiedAttributeOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAttributeOverrides, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.move(targetIndex, sourceIndex, "javax.persistence.AttributeOverrides");
        this.fireItemMoved("specifiedAttributeOverridesList", targetIndex, sourceIndex);
    }

    protected void addVirtualAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.addItemToList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverridesList");
    }

    protected void removeVirtualAttributeOverride(JavaAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.virtualAttributeOverrides, "virtualAttributeOverridesList");
    }

    public JavaAttributeOverride attributeOverrideNamed(String name) {
        return (JavaAttributeOverride)this.overrideNamed(name, this.attributeOverrides());
    }

    public boolean containsAttributeOverride(String name) {
        return this.containsOverride(name, this.attributeOverrides());
    }

    public boolean containsDefaultAttributeOverride(String name) {
        return this.containsOverride(name, this.virtualAttributeOverrides());
    }

    public boolean containsSpecifiedAttributeOverride(String name) {
        return this.containsOverride(name, this.specifiedAttributeOverrides());
    }

    public JavaAssociationOverride associationOverrideNamed(String name) {
        return (JavaAssociationOverride)this.overrideNamed(name, this.associationOverrides());
    }

    public boolean containsAssociationOverride(String name) {
        return this.containsOverride(name, this.associationOverrides());
    }

    public boolean containsSpecifiedAssociationOverride(String name) {
        return this.containsOverride(name, this.specifiedAssociationOverrides());
    }

    public boolean containsDefaultAssociationOverride(String name) {
        return this.containsOverride(name, this.virtualAssociationOverrides());
    }

    private BaseOverride overrideNamed(String name, ListIterator<? extends BaseOverride> overrides) {
        for (BaseOverride override : CollectionTools.iterable(overrides)) {
            String overrideName = override.getName();
            if (overrideName == null && name == null) {
                return override;
            }
            if (overrideName == null || !overrideName.equals(name)) continue;
            return override;
        }
        return null;
    }

    private boolean containsOverride(String name, ListIterator<? extends BaseOverride> overrides) {
        return this.overrideNamed(name, overrides) != null;
    }

    @Override
    public ListIterator<JavaAssociationOverride> associationOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAssociationOverrides(), this.virtualAssociationOverrides()});
    }

    @Override
    public int associationOverridesSize() {
        return this.specifiedAssociationOverridesSize() + this.virtualAssociationOverridesSize();
    }

    @Override
    public ListIterator<JavaAssociationOverride> virtualAssociationOverrides() {
        return new CloneListIterator(this.virtualAssociationOverrides);
    }

    @Override
    public int virtualAssociationOverridesSize() {
        return this.virtualAssociationOverrides.size();
    }

    @Override
    public ListIterator<JavaAssociationOverride> specifiedAssociationOverrides() {
        return new CloneListIterator(this.specifiedAssociationOverrides);
    }

    @Override
    public int specifiedAssociationOverridesSize() {
        return this.specifiedAssociationOverrides.size();
    }

    public JavaAssociationOverride addSpecifiedAssociationOverride(int index) {
        JavaAssociationOverride associationOverride = this.getJpaFactory().buildJavaAssociationOverride(this, this.createAssociationOverrideOwner());
        this.specifiedAssociationOverrides.add(index, associationOverride);
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)this.javaResourcePersistentType.addAnnotation(index, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.initializeFromResource(associationOverrideResource);
        this.fireItemAdded("specifiedAssociationOverridesList", index, associationOverride);
        return associationOverride;
    }

    protected AssociationOverride.Owner createAssociationOverrideOwner() {
        return new AssociationOverrideOwner();
    }

    protected void addSpecifiedAssociationOverride(int index, JavaAssociationOverride associationOverride) {
        this.addItemToList(index, associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverridesList");
    }

    protected void removeSpecifiedAssociationOverride_(JavaAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverridesList");
    }

    @Override
    public void moveSpecifiedAssociationOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAssociationOverrides, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.move(targetIndex, sourceIndex, "javax.persistence.AssociationOverrides");
        this.fireItemMoved("specifiedAssociationOverridesList", targetIndex, sourceIndex);
    }

    protected JavaAssociationOverride setAssociationOverrideVirtual(boolean virtual, JavaAssociationOverride associationOverride) {
        if (virtual) {
            return this.setAssociationOverrideVirtual(associationOverride);
        }
        return this.setAssociationOverrideSpecified(associationOverride);
    }

    protected JavaAssociationOverride setAssociationOverrideVirtual(JavaAssociationOverride associationOverride) {
        int index = this.specifiedAssociationOverrides.indexOf(associationOverride);
        this.specifiedAssociationOverrides.remove(index);
        String associationOverrideName = associationOverride.getName();
        JavaAssociationOverride virtualAssociationOverride = null;
        if (associationOverrideName != null) {
            for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAssociations())) {
                if (!persistentAttribute.getName().equals(associationOverrideName)) continue;
                virtualAssociationOverride = this.buildAssociationOverride(new NullAssociationOverride(this.javaResourcePersistentType, associationOverrideName));
                this.virtualAssociationOverrides.add(virtualAssociationOverride);
                break;
            }
        }
        this.javaResourcePersistentType.removeAnnotation(index, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.fireItemRemoved("specifiedAssociationOverridesList", index, associationOverride);
        if (virtualAssociationOverride != null) {
            this.fireItemAdded("virtualAssociationOverridesList", this.virtualAssociationOverridesSize() - 1, virtualAssociationOverride);
        }
        return virtualAssociationOverride;
    }

    protected JavaAssociationOverride setAssociationOverrideSpecified(JavaAssociationOverride oldAssociationOverride) {
        int index = this.specifiedAssociationOverridesSize();
        JavaAssociationOverride newAssociationOverride = this.getJpaFactory().buildJavaAssociationOverride(this, this.createAssociationOverrideOwner());
        this.specifiedAssociationOverrides.add(index, newAssociationOverride);
        AssociationOverrideAnnotation attributeOverrideResource = (AssociationOverrideAnnotation)this.javaResourcePersistentType.addAnnotation(index, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        newAssociationOverride.initializeFromResource(attributeOverrideResource);
        int virtualIndex = this.virtualAssociationOverrides.indexOf(oldAssociationOverride);
        this.virtualAssociationOverrides.remove(virtualIndex);
        newAssociationOverride.setName(oldAssociationOverride.getName());
        this.fireItemRemoved("virtualAssociationOverridesList", virtualIndex, oldAssociationOverride);
        this.fireItemAdded("specifiedAssociationOverridesList", index, newAssociationOverride);
        return newAssociationOverride;
    }

    protected void addVirtualAssociationOverride(JavaAssociationOverride associationOverride) {
        this.addItemToList(associationOverride, this.virtualAssociationOverrides, "virtualAssociationOverridesList");
    }

    protected void removeVirtualAssociationOverride(JavaAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.virtualAssociationOverrides, "virtualAssociationOverridesList");
    }

    @Override
    public ListIterator<JavaNamedQuery> namedQueries() {
        return new CloneListIterator(this.namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.namedQueries.size();
    }

    @Override
    public JavaNamedQuery addNamedQuery(int index) {
        JavaNamedQuery namedQuery = this.getJpaFactory().buildJavaNamedQuery(this);
        this.namedQueries.add(index, namedQuery);
        NamedQueryAnnotation namedQueryAnnotation = (NamedQueryAnnotation)this.javaResourcePersistentType.addAnnotation(index, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        namedQuery.initializeFromResource(namedQueryAnnotation);
        this.fireItemAdded("namedQueriesList", index, namedQuery);
        return namedQuery;
    }

    protected void addNamedQuery(int index, JavaNamedQuery namedQuery) {
        this.addItemToList(index, namedQuery, this.namedQueries, "namedQueriesList");
    }

    @Override
    public void removeNamedQuery(NamedQuery namedQuery) {
        this.removeNamedQuery(this.namedQueries.indexOf(namedQuery));
    }

    @Override
    public void removeNamedQuery(int index) {
        JavaNamedQuery removedNamedQuery = this.namedQueries.remove(index);
        this.javaResourcePersistentType.removeAnnotation(index, "javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        this.fireItemRemoved("namedQueriesList", index, removedNamedQuery);
    }

    protected void removeNamedQuery_(JavaNamedQuery namedQuery) {
        this.removeItemFromList(namedQuery, this.namedQueries, "namedQueriesList");
    }

    @Override
    public void moveNamedQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedQueries, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.move(targetIndex, sourceIndex, "javax.persistence.NamedQueries");
        this.fireItemMoved("namedQueriesList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<JavaNamedNativeQuery> namedNativeQueries() {
        return new CloneListIterator(this.namedNativeQueries);
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.namedNativeQueries.size();
    }

    @Override
    public JavaNamedNativeQuery addNamedNativeQuery(int index) {
        JavaNamedNativeQuery namedNativeQuery = this.getJpaFactory().buildJavaNamedNativeQuery(this);
        this.namedNativeQueries.add(index, namedNativeQuery);
        NamedNativeQueryAnnotation namedNativeQueryAnnotation = (NamedNativeQueryAnnotation)this.javaResourcePersistentType.addAnnotation(index, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        namedNativeQuery.initializeFromResource(namedNativeQueryAnnotation);
        this.fireItemAdded("namedNativeQueriesList", index, namedNativeQuery);
        return namedNativeQuery;
    }

    protected void addNamedNativeQuery(int index, JavaNamedNativeQuery namedNativeQuery) {
        this.addItemToList(index, namedNativeQuery, this.namedNativeQueries, "namedNativeQueriesList");
    }

    @Override
    public void removeNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.removeNamedNativeQuery(this.namedNativeQueries.indexOf(namedNativeQuery));
    }

    @Override
    public void removeNamedNativeQuery(int index) {
        JavaNamedNativeQuery removedNamedNativeQuery = this.namedNativeQueries.remove(index);
        this.javaResourcePersistentType.removeAnnotation(index, "javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        this.fireItemRemoved("namedNativeQueriesList", index, removedNamedNativeQuery);
    }

    protected void removeNamedNativeQuery_(JavaNamedNativeQuery namedNativeQuery) {
        this.removeItemFromList(namedNativeQuery, this.namedNativeQueries, "namedNativeQueriesList");
    }

    @Override
    public void moveNamedNativeQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedNativeQueries, (int)targetIndex, (int)sourceIndex);
        this.javaResourcePersistentType.move(targetIndex, sourceIndex, "javax.persistence.NamedNativeQueries");
        this.fireItemMoved("namedNativeQueriesList", targetIndex, sourceIndex);
    }

    protected Iterator<JavaQuery> queries() {
        return new CompositeIterator(new Iterator[]{this.namedNativeQueries(), this.namedQueries()});
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public void setIdClass(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        if (newIdClass != oldIdClass) {
            if (newIdClass != null) {
                if (this.getIdClassResource() == null) {
                    this.addIdClassResource();
                }
                this.getIdClassResource().setValue(newIdClass);
            } else {
                this.removeIdClassResource();
            }
        }
        this.firePropertyChanged("idClassProperty", oldIdClass, newIdClass);
    }

    protected void setIdClass_(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        this.firePropertyChanged("idClassProperty", oldIdClass, newIdClass);
    }

    protected IdClassAnnotation getIdClassResource() {
        return (IdClassAnnotation)this.javaResourcePersistentType.getAnnotation("javax.persistence.IdClass");
    }

    protected void addIdClassResource() {
        this.javaResourcePersistentType.addAnnotation("javax.persistence.IdClass");
    }

    protected void removeIdClassResource() {
        this.javaResourcePersistentType.removeAnnotation("javax.persistence.IdClass");
    }

    @Override
    public Entity getParentEntity() {
        Iterator<PersistentType> i = this.getPersistentType().inheritanceHierarchy();
        while (i.hasNext()) {
            TypeMapping typeMapping = i.next().getMapping();
            if (typeMapping == this || !(typeMapping instanceof Entity)) continue;
            return (Entity)typeMapping;
        }
        return this;
    }

    @Override
    public Entity getRootEntity() {
        Entity rootEntity = this;
        Iterator<PersistentType> i = this.getPersistentType().inheritanceHierarchy();
        while (i.hasNext()) {
            PersistentType persistentType = i.next();
            if (!(persistentType.getMapping() instanceof Entity)) continue;
            rootEntity = (Entity)persistentType.getMapping();
        }
        return rootEntity;
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return GenericJavaEntity.primaryKeyColumnName(this.getPersistentType().allAttributes());
    }

    public static String primaryKeyColumnName(Iterator<PersistentAttribute> attributes) {
        String pkColumnName = null;
        Iterator<PersistentAttribute> stream = attributes;
        while (stream.hasNext()) {
            PersistentAttribute attribute = stream.next();
            String name = attribute.getPrimaryKeyColumnName();
            if (pkColumnName == null) {
                pkColumnName = name;
                continue;
            }
            if (name == null) continue;
            return null;
        }
        return pkColumnName;
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !CollectionTools.contains(this.associatedTableNamesIncludingInherited(), (Object)tableName);
    }

    @Override
    public Iterator<Table> associatedTables() {
        return new CompositeIterator((Object)this.getTable(), this.secondaryTables());
    }

    @Override
    public Iterator<Table> associatedTablesIncludingInherited() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<Table>>(this.inheritanceHierarchy()){

            protected Iterator<Table> transform(TypeMapping mapping) {
                return new FilteringIterator<Table, Table>(mapping.associatedTables()){

                    protected boolean accept(Table o) {
                        return true;
                    }
                };
            }
        });
    }

    @Override
    public Iterator<String> associatedTableNamesIncludingInherited() {
        return this.nonNullTableNames(this.associatedTablesIncludingInherited());
    }

    protected Iterator<String> nonNullTableNames(Iterator<Table> tables) {
        return new FilteringIterator<String, String>(this.tableNames(tables)){

            protected boolean accept(String o) {
                return o != null;
            }
        };
    }

    protected Iterator<String> tableNames(Iterator<Table> tables) {
        return new TransformationIterator<Table, String>(tables){

            protected String transform(Table t) {
                return t.getName();
            }
        };
    }

    protected Iterator<TypeMapping> inheritanceHierarchy() {
        return new TransformationIterator<PersistentType, TypeMapping>(this.getPersistentType().inheritanceHierarchy()){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<String>>(this.inheritanceHierarchy()){

            protected Iterator<String> transform(TypeMapping mapping) {
                return mapping.overridableAttributeNames();
            }
        });
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(TypeMapping mapping) {
                return mapping.overridableAttributes();
            }
        });
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAssociations() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(TypeMapping mapping) {
                return mapping.overridableAssociations();
            }
        });
    }

    @Override
    public Iterator<String> allOverridableAssociationNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<String>>(this.inheritanceHierarchy()){

            protected Iterator<String> transform(TypeMapping mapping) {
                return mapping.overridableAssociationNames();
            }
        });
    }

    @Override
    public void update(JavaResourcePersistentType resourcePersistentType) {
        super.update(resourcePersistentType);
        this.entityResource = (EntityAnnotation)resourcePersistentType.getMappingAnnotation("javax.persistence.Entity");
        this.setSpecifiedName_(this.specifiedName(this.entityResource));
        this.setDefaultName(this.defaultName(resourcePersistentType));
        this.updateInheritance(this.getInheritanceResource());
        this.updateDiscriminatorColumn(resourcePersistentType);
        this.updateDiscriminatorValue(this.getDiscriminatorValueResource());
        this.setDiscriminatorValueAllowed(this.discriminatorValueIsAllowed(resourcePersistentType));
        this.updateTable(resourcePersistentType);
        this.updateSecondaryTables(resourcePersistentType);
        this.updateTableGenerator(resourcePersistentType);
        this.updateSequenceGenerator(resourcePersistentType);
        this.updateSpecifiedPrimaryKeyJoinColumns(resourcePersistentType);
        this.updateDefaultPrimaryKeyJoinColumn(resourcePersistentType);
        this.updateSpecifiedAttributeOverrides(resourcePersistentType);
        this.updateVirtualAttributeOverrides(resourcePersistentType);
        this.updateSpecifiedAssociationOverrides(resourcePersistentType);
        this.updateVirtualAssociationOverrides(resourcePersistentType);
        this.updateNamedQueries(resourcePersistentType);
        this.updateNamedNativeQueries(resourcePersistentType);
        this.updateIdClass(resourcePersistentType);
        this.updatePersistenceUnitGeneratorsAndQueries();
    }

    protected String specifiedName(EntityAnnotation entityResource) {
        return entityResource.getName();
    }

    protected String defaultName(JavaResourcePersistentType persistentTypeResource) {
        return persistentTypeResource.getName();
    }

    protected void updateTable(JavaResourcePersistentType persistentTypeResource) {
        this.getTable().update(persistentTypeResource);
    }

    protected void updateInheritance(InheritanceAnnotation inheritanceResource) {
        this.setSpecifiedInheritanceStrategy_(this.specifiedInheritanceStrategy(inheritanceResource));
        this.setDefaultInheritanceStrategy(this.defaultInheritanceStrategy());
    }

    protected InheritanceType specifiedInheritanceStrategy(InheritanceAnnotation inheritanceResource) {
        return InheritanceType.fromJavaResourceModel(inheritanceResource.getStrategy());
    }

    protected InheritanceType defaultInheritanceStrategy() {
        if (this.getRootEntity() == this) {
            return InheritanceType.SINGLE_TABLE;
        }
        return this.getRootEntity().getInheritanceStrategy();
    }

    protected void updateDiscriminatorColumn(JavaResourcePersistentType persistentTypeResource) {
        this.getDiscriminatorColumn().update(persistentTypeResource);
    }

    protected void updateDiscriminatorValue(DiscriminatorValueAnnotation discriminatorValueResource) {
        this.setSpecifiedDiscriminatorValue_(discriminatorValueResource.getValue());
        this.setDefaultDiscriminatorValue(this.javaDefaultDiscriminatorValue());
    }

    protected String javaDefaultDiscriminatorValue() {
        if (this.javaResourcePersistentType.isAbstract()) {
            return null;
        }
        if (this.getDiscriminatorType() != DiscriminatorType.STRING) {
            return null;
        }
        return this.getName();
    }

    protected DiscriminatorType getDiscriminatorType() {
        return this.getDiscriminatorColumn().getDiscriminatorType();
    }

    protected boolean discriminatorValueIsAllowed(JavaResourcePersistentType persistentTypeResource) {
        return !persistentTypeResource.isAbstract();
    }

    protected void updateSecondaryTables(JavaResourcePersistentType persistentTypeResource) {
        ListIterator<JavaSecondaryTable> secondaryTables = this.specifiedSecondaryTables();
        ListIterator resourceSecondaryTables = persistentTypeResource.annotations("javax.persistence.SecondaryTable", "javax.persistence.SecondaryTables");
        while (secondaryTables.hasNext()) {
            JavaSecondaryTable secondaryTable = secondaryTables.next();
            if (resourceSecondaryTables.hasNext()) {
                secondaryTable.update((SecondaryTableAnnotation)resourceSecondaryTables.next());
                continue;
            }
            this.removeSpecifiedSecondaryTable_(secondaryTable);
        }
        while (resourceSecondaryTables.hasNext()) {
            this.addSpecifiedSecondaryTable(this.specifiedSecondaryTablesSize(), this.buildSecondaryTable((SecondaryTableAnnotation)resourceSecondaryTables.next()));
        }
    }

    protected JavaSecondaryTable buildSecondaryTable(SecondaryTableAnnotation secondaryTableResource) {
        JavaSecondaryTable secondaryTable = this.getJpaFactory().buildJavaSecondaryTable(this);
        secondaryTable.initializeFromResource(secondaryTableResource);
        return secondaryTable;
    }

    protected void updateTableGenerator(JavaResourcePersistentType persistentTypeResource) {
        TableGeneratorAnnotation tableGeneratorResource = this.tableGenerator(persistentTypeResource);
        if (tableGeneratorResource == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.buildTableGenerator(tableGeneratorResource));
        } else {
            this.getTableGenerator().update(tableGeneratorResource);
        }
    }

    protected JavaTableGenerator buildTableGenerator(TableGeneratorAnnotation tableGeneratorResource) {
        JavaTableGenerator tableGenerator = this.getJpaFactory().buildJavaTableGenerator(this);
        tableGenerator.initializeFromResource(tableGeneratorResource);
        return tableGenerator;
    }

    protected TableGeneratorAnnotation tableGenerator(JavaResourcePersistentType persistentTypeResource) {
        return (TableGeneratorAnnotation)persistentTypeResource.getAnnotation("javax.persistence.TableGenerator");
    }

    protected void updateSequenceGenerator(JavaResourcePersistentType persistentTypeResource) {
        SequenceGeneratorAnnotation sequenceGeneratorResource = this.sequenceGenerator(persistentTypeResource);
        if (sequenceGeneratorResource == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.buildSequenceGenerator(sequenceGeneratorResource));
        } else {
            this.getSequenceGenerator().update(sequenceGeneratorResource);
        }
    }

    protected JavaSequenceGenerator buildSequenceGenerator(SequenceGeneratorAnnotation sequenceGeneratorResource) {
        JavaSequenceGenerator sequenceGenerator = this.getJpaFactory().buildJavaSequenceGenerator(this);
        sequenceGenerator.initializeFromResource(sequenceGeneratorResource);
        return sequenceGenerator;
    }

    protected SequenceGeneratorAnnotation sequenceGenerator(JavaResourcePersistentType persistentTypeResource) {
        return (SequenceGeneratorAnnotation)persistentTypeResource.getAnnotation("javax.persistence.SequenceGenerator");
    }

    protected void updateSpecifiedPrimaryKeyJoinColumns(JavaResourcePersistentType persistentTypeResource) {
        ListIterator<JavaPrimaryKeyJoinColumn> primaryKeyJoinColumns = this.specifiedPrimaryKeyJoinColumns();
        ListIterator resourcePrimaryKeyJoinColumns = persistentTypeResource.annotations("javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns");
        while (primaryKeyJoinColumns.hasNext()) {
            JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = primaryKeyJoinColumns.next();
            if (resourcePrimaryKeyJoinColumns.hasNext()) {
                primaryKeyJoinColumn.update((PrimaryKeyJoinColumnAnnotation)resourcePrimaryKeyJoinColumns.next());
                continue;
            }
            this.removeSpecifiedPrimaryKeyJoinColumn_(primaryKeyJoinColumn);
        }
        while (resourcePrimaryKeyJoinColumns.hasNext()) {
            this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumnsSize(), this.buildPrimaryKeyJoinColumn((PrimaryKeyJoinColumnAnnotation)resourcePrimaryKeyJoinColumns.next()));
        }
    }

    protected JavaPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnResource) {
        JavaPrimaryKeyJoinColumn primaryKeyJoinColumn = this.getJpaFactory().buildJavaPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner());
        primaryKeyJoinColumn.initializeFromResource(primaryKeyJoinColumnResource);
        return primaryKeyJoinColumn;
    }

    protected void updateDefaultPrimaryKeyJoinColumn(JavaResourcePersistentType persistentTypeResource) {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            this.setDefaultPrimaryKeyJoinColumn(null);
            return;
        }
        if (this.getDefaultPrimaryKeyJoinColumn() == null) {
            this.setDefaultPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn(new NullPrimaryKeyJoinColumn(this.javaResourcePersistentType)));
        } else {
            this.defaultPrimaryKeyJoinColumn.update(new NullPrimaryKeyJoinColumn(persistentTypeResource));
        }
    }

    protected void updateSpecifiedAttributeOverrides(JavaResourcePersistentType persistentTypeResource) {
        ListIterator<JavaAttributeOverride> attributeOverrides = this.specifiedAttributeOverrides();
        ListIterator resourceAttributeOverrides = persistentTypeResource.annotations("javax.persistence.AttributeOverride", "javax.persistence.AttributeOverrides");
        while (attributeOverrides.hasNext()) {
            JavaAttributeOverride attributeOverride = attributeOverrides.next();
            if (resourceAttributeOverrides.hasNext()) {
                attributeOverride.update((AttributeOverrideAnnotation)resourceAttributeOverrides.next());
                continue;
            }
            this.removeSpecifiedAttributeOverride_(attributeOverride);
        }
        while (resourceAttributeOverrides.hasNext()) {
            this.addSpecifiedAttributeOverride(this.specifiedAttributeOverridesSize(), this.buildAttributeOverride((AttributeOverrideAnnotation)resourceAttributeOverrides.next()));
        }
    }

    protected JavaAttributeOverride buildAttributeOverride(AttributeOverrideAnnotation attributeOverrideResource) {
        JavaAttributeOverride attributeOverride = this.getJpaFactory().buildJavaAttributeOverride(this, this.createAttributeOverrideOwner());
        attributeOverride.initializeFromResource(attributeOverrideResource);
        return attributeOverride;
    }

    protected JavaAttributeOverride buildVirtualAttributeOverride(JavaResourcePersistentType resourcePersistentType, PersistentAttribute attribute) {
        return this.buildAttributeOverride(this.buildVirtualAttributeOverrideResource(resourcePersistentType, attribute));
    }

    protected VirtualAttributeOverride buildVirtualAttributeOverrideResource(JavaResourcePersistentType resourcePersistentType, PersistentAttribute attribute) {
        ColumnMapping columnMapping = (ColumnMapping)((Object)attribute.getMapping());
        return new VirtualAttributeOverride(resourcePersistentType, attribute.getName(), columnMapping.getColumn());
    }

    protected void updateVirtualAttributeOverrides(JavaResourcePersistentType resourcePersistentType) {
        for (PersistentAttribute persistentAttribute : CollectionTools.iterable(this.allOverridableAttributes())) {
            JavaAttributeOverride attributeOverride = this.attributeOverrideNamed(persistentAttribute.getName());
            if (attributeOverride == null) {
                this.addVirtualAttributeOverride(this.buildVirtualAttributeOverride(resourcePersistentType, persistentAttribute));
                continue;
            }
            if (!attributeOverride.isVirtual()) continue;
            attributeOverride.update(this.buildVirtualAttributeOverrideResource(resourcePersistentType, persistentAttribute));
        }
        Collection attributeNames = CollectionTools.collection(this.allOverridableAttributeNames());
        for (JavaAttributeOverride attributeOverride : CollectionTools.iterable(this.virtualAttributeOverrides())) {
            if (attributeNames.contains(attributeOverride.getName()) && !this.containsSpecifiedAttributeOverride(attributeOverride.getName())) continue;
            this.removeVirtualAttributeOverride(attributeOverride);
        }
    }

    protected void updateSpecifiedAssociationOverrides(JavaResourcePersistentType resourcePersistentType) {
        ListIterator<JavaAssociationOverride> associationOverrides = this.specifiedAssociationOverrides();
        ListIterator resourceAssociationOverrides = resourcePersistentType.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        while (associationOverrides.hasNext()) {
            JavaAssociationOverride associationOverride = associationOverrides.next();
            if (resourceAssociationOverrides.hasNext()) {
                associationOverride.update((AssociationOverrideAnnotation)resourceAssociationOverrides.next());
                continue;
            }
            this.removeSpecifiedAssociationOverride_(associationOverride);
        }
        while (resourceAssociationOverrides.hasNext()) {
            this.addSpecifiedAssociationOverride(this.specifiedAssociationOverridesSize(), this.buildAssociationOverride((AssociationOverrideAnnotation)resourceAssociationOverrides.next()));
        }
    }

    protected JavaAssociationOverride buildAssociationOverride(AssociationOverrideAnnotation associationOverrideResource) {
        JavaAssociationOverride associationOverride = this.getJpaFactory().buildJavaAssociationOverride(this, this.createAssociationOverrideOwner());
        associationOverride.initializeFromResource(associationOverrideResource);
        return associationOverride;
    }

    protected void updateVirtualAssociationOverrides(JavaResourcePersistentType resourcePersistentType) {
        Iterator<String> i = this.allOverridableAssociationNames();
        while (i.hasNext()) {
            String associationName = i.next();
            JavaAssociationOverride associationOverride = this.associationOverrideNamed(associationName);
            if (associationOverride == null) {
                associationOverride = this.buildAssociationOverride(new NullAssociationOverride(resourcePersistentType, associationName));
                this.addVirtualAssociationOverride(associationOverride);
                continue;
            }
            if (!associationOverride.isVirtual()) continue;
            associationOverride.update(new NullAssociationOverride(resourcePersistentType, associationName));
        }
        Collection associationNames = CollectionTools.collection(this.allOverridableAssociationNames());
        for (JavaAssociationOverride associationOverride : CollectionTools.iterable(this.virtualAssociationOverrides())) {
            if (associationNames.contains(associationOverride.getName()) && !this.containsSpecifiedAssociationOverride(associationOverride.getName())) continue;
            this.removeVirtualAssociationOverride(associationOverride);
        }
    }

    protected void updateNamedQueries(JavaResourcePersistentType resourcePersistentType) {
        ListIterator<JavaNamedQuery> namedQueries = this.namedQueries();
        ListIterator resourceNamedQueries = resourcePersistentType.annotations("javax.persistence.NamedQuery", "javax.persistence.NamedQueries");
        while (namedQueries.hasNext()) {
            JavaNamedQuery namedQuery = namedQueries.next();
            if (resourceNamedQueries.hasNext()) {
                namedQuery.update((NamedQueryAnnotation)resourceNamedQueries.next());
                continue;
            }
            this.removeNamedQuery_(namedQuery);
        }
        while (resourceNamedQueries.hasNext()) {
            this.addNamedQuery(this.namedQueriesSize(), this.buildNamedQuery((NamedQueryAnnotation)resourceNamedQueries.next()));
        }
    }

    protected void updateNamedNativeQueries(JavaResourcePersistentType resourcePersistentType) {
        ListIterator<JavaNamedNativeQuery> namedNativeQueries = this.namedNativeQueries();
        ListIterator resourceNamedNativeQueries = resourcePersistentType.annotations("javax.persistence.NamedNativeQuery", "javax.persistence.NamedNativeQueries");
        while (namedNativeQueries.hasNext()) {
            JavaNamedNativeQuery namedQuery = namedNativeQueries.next();
            if (resourceNamedNativeQueries.hasNext()) {
                namedQuery.update((NamedNativeQueryAnnotation)resourceNamedNativeQueries.next());
                continue;
            }
            this.removeNamedNativeQuery_(namedQuery);
        }
        while (resourceNamedNativeQueries.hasNext()) {
            this.addNamedNativeQuery(this.namedNativeQueriesSize(), this.buildNamedNativeQuery((NamedNativeQueryAnnotation)resourceNamedNativeQueries.next()));
        }
    }

    protected JavaNamedQuery buildNamedQuery(NamedQueryAnnotation namedQueryResource) {
        JavaNamedQuery namedQuery = this.getJpaFactory().buildJavaNamedQuery(this);
        namedQuery.initializeFromResource(namedQueryResource);
        return namedQuery;
    }

    protected JavaNamedNativeQuery buildNamedNativeQuery(NamedNativeQueryAnnotation namedNativeQueryResource) {
        JavaNamedNativeQuery namedNativeQuery = this.getJpaFactory().buildJavaNamedNativeQuery(this);
        namedNativeQuery.initializeFromResource(namedNativeQueryResource);
        return namedNativeQuery;
    }

    protected void updateIdClass(JavaResourcePersistentType resourcePersistentType) {
        IdClassAnnotation idClass = (IdClassAnnotation)resourcePersistentType.getAnnotation("javax.persistence.IdClass");
        if (idClass != null) {
            this.setIdClass_(idClass.getValue());
        } else {
            this.setIdClass_(null);
        }
    }

    protected void updatePersistenceUnitGeneratorsAndQueries() {
        if (this.getTableGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getTableGenerator());
        }
        if (this.getSequenceGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getSequenceGenerator());
        }
        for (Query query : CollectionTools.iterable(this.namedQueries())) {
            this.getPersistenceUnit().addQuery(query);
        }
        for (Query query : CollectionTools.iterable(this.namedNativeQueries())) {
            this.getPersistenceUnit().addQuery(query);
        }
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getTable().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaSecondaryTable sTable : CollectionTools.iterable(this.secondaryTables())) {
            result = sTable.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaPrimaryKeyJoinColumn column : CollectionTools.iterable(this.primaryKeyJoinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaJpaContextNode override : CollectionTools.iterable(this.attributeOverrides())) {
            result = override.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        for (JavaJpaContextNode override : CollectionTools.iterable(this.associationOverrides())) {
            result = override.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        result = this.getDiscriminatorColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.getTableGenerator() != null && (result = this.getTableGenerator().javaCompletionProposals(pos, filter, astRoot)) != null) {
            return result;
        }
        if (this.getSequenceGenerator() != null && (result = this.getSequenceGenerator().javaCompletionProposals(pos, filter, astRoot)) != null) {
            return result;
        }
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        this.getTable().addToMessages(messages, astRoot);
        this.addIdMessages(messages, astRoot);
        this.addGeneratorMessages(messages, astRoot);
        this.addQueryMessages(messages, astRoot);
        ListIterator<JavaJpaContextNode> stream = this.specifiedSecondaryTables();
        while (stream.hasNext()) {
            ((JavaSecondaryTable)stream.next()).addToMessages(messages, astRoot);
        }
        stream = this.attributeOverrides();
        while (stream.hasNext()) {
            ((JavaAttributeOverride)stream.next()).addToMessages(messages, astRoot);
        }
        stream = this.associationOverrides();
        while (stream.hasNext()) {
            ((JavaAssociationOverride)stream.next()).addToMessages(messages, astRoot);
        }
    }

    protected void addIdMessages(List<IMessage> messages, CompilationUnit astRoot) {
        this.addNoIdMessage(messages, astRoot);
    }

    protected void addNoIdMessage(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.entityHasNoId()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NO_ID", new String[]{this.getName()}, this, this.getValidationTextRange(astRoot)));
        }
    }

    private boolean entityHasNoId() {
        return !this.entityHasId();
    }

    private boolean entityHasId() {
        Iterator<PersistentAttribute> stream = this.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            if (!stream.next().isIdAttribute()) continue;
            return true;
        }
        return false;
    }

    protected void addGeneratorMessages(List<IMessage> messages, CompilationUnit astRoot) {
        List masterList = CollectionTools.list(this.getPersistenceUnit().allGenerators());
        Iterator<JavaGenerator> stream = this.generators();
        while (stream.hasNext()) {
            JavaGenerator current = stream.next();
            masterList.remove(current);
            for (Generator each : masterList) {
                if (each.overrides(current) || each.getName() == null || !each.getName().equals(current.getName())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{current.getName()}, current, current.getNameTextRange(astRoot)));
            }
            masterList.add(current);
        }
    }

    protected void addQueryMessages(List<IMessage> messages, CompilationUnit astRoot) {
        List masterList = CollectionTools.list(this.getPersistenceUnit().allQueries());
        Iterator<JavaQuery> stream = this.queries();
        while (stream.hasNext()) {
            JavaQuery current = stream.next();
            masterList.remove(current);
            for (Query each : masterList) {
                if (each.overrides(current) || !each.getName().equals(current.getName())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", new String[]{current.getName()}, current, current.getNameTextRange(astRoot)));
            }
            masterList.add(current);
        }
    }

    class AssociationOverrideOwner
    implements AssociationOverride.Owner {
        AssociationOverrideOwner() {
        }

        public RelationshipMapping getRelationshipMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<PersistentAttribute> stream = GenericJavaEntity.this.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                PersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof RelationshipMapping)) continue;
                return (RelationshipMapping)persAttribute.getMapping();
            }
            return null;
        }

        public boolean isVirtual(BaseOverride override) {
            return GenericJavaEntity.this.virtualAssociationOverrides.contains(override);
        }

        public BaseOverride setVirtual(boolean virtual, BaseOverride attributeOverride) {
            return GenericJavaEntity.this.setAssociationOverrideVirtual(virtual, (JavaAssociationOverride)attributeOverride);
        }

        public TypeMapping getTypeMapping() {
            return GenericJavaEntity.this;
        }

        public TextRange validationTextRange(CompilationUnit astRoot) {
            return null;
        }
    }

    class AttributeOverrideOwner
    implements AttributeOverride.Owner {
        AttributeOverrideOwner() {
        }

        public ColumnMapping getColumnMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<PersistentAttribute> stream = GenericJavaEntity.this.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                PersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof ColumnMapping)) continue;
                return (ColumnMapping)((Object)persAttribute.getMapping());
            }
            return null;
        }

        public boolean isVirtual(BaseOverride override) {
            return GenericJavaEntity.this.virtualAttributeOverrides.contains(override);
        }

        public BaseOverride setVirtual(boolean virtual, BaseOverride attributeOverride) {
            return GenericJavaEntity.this.setAttributeOverrideVirtual(virtual, (JavaAttributeOverride)attributeOverride);
        }

        public TypeMapping getTypeMapping() {
            return GenericJavaEntity.this;
        }

        public TextRange validationTextRange(CompilationUnit astRoot) {
            return null;
        }
    }

    class PrimaryKeyJoinColumnOwner
    implements JavaBaseJoinColumn.Owner {
        PrimaryKeyJoinColumnOwner() {
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaEntity.this.getValidationTextRange(astRoot);
        }

        public TypeMapping getTypeMapping() {
            return GenericJavaEntity.this;
        }

        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return GenericJavaEntity.this.getDbTable(tableName);
        }

        public org.eclipse.jpt.db.Table getDbReferencedColumnTable() {
            Entity parentEntity = GenericJavaEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return GenericJavaEntity.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericJavaEntity.this.defaultPrimaryKeyJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            return GenericJavaEntity.this.getParentEntity().getPrimaryKeyColumnName();
        }
    }
}

