/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaOneToOneMapping
extends AbstractJavaSingleRelationshipMapping<OneToOneAnnotation>
implements JavaOneToOneMapping {
    protected String mappedBy;

    public GenericJavaOneToOneMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public Iterator<String> correspondingAnnotationNames() {
        return new ArrayIterator((Object[])new String[]{"javax.persistence.PrimaryKeyJoinColumn", "javax.persistence.PrimaryKeyJoinColumns", "javax.persistence.JoinColumn", "javax.persistence.JoinColumns", "javax.persistence.JoinTable"});
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.OneToOne";
    }

    @Override
    public String getKey() {
        return "oneToOne";
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.getMappedBy() == null;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        ((OneToOneAnnotation)this.getMappingResource()).setMappedBy(newMappedBy);
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    @Override
    public boolean mappedByIsValid(AttributeMapping mappedByMapping) {
        String mappedByKey = mappedByMapping.getKey();
        return mappedByKey == "oneToOne";
    }

    @Override
    protected void setOptionalOnResourceModel(Boolean newOptional) {
        ((OneToOneAnnotation)this.getMappingResource()).setOptional(newOptional);
    }

    public TextRange getMappedByTextRange(CompilationUnit astRoot) {
        return ((OneToOneAnnotation)this.getMappingResource()).getMappedByTextRange(astRoot);
    }

    public boolean mappedByTouches(int pos, CompilationUnit astRoot) {
        return ((OneToOneAnnotation)this.getMappingResource()).mappedByTouches(pos, astRoot);
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.mappedByTouches(pos, astRoot)) {
            return this.quotedCandidateMappedByAttributeNames(filter);
        }
        return null;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return true;
    }

    @Override
    protected void initialize(OneToOneAnnotation oneToOneResource) {
        super.initialize(oneToOneResource);
        this.mappedBy = oneToOneResource.getMappedBy();
    }

    @Override
    protected void update(OneToOneAnnotation oneToOneResource) {
        super.update(oneToOneResource);
        this.setMappedBy(oneToOneResource.getMappedBy());
    }

    @Override
    protected Boolean specifiedOptional(OneToOneAnnotation relationshipMapping) {
        return relationshipMapping.getOptional();
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        if (this.getMappedBy() != null) {
            this.addMappedByMessages(messages, astRoot);
        }
    }

    protected void addMappedByMessages(List<IMessage> messages, CompilationUnit astRoot) {
        NonOwningMapping mappedByMapping;
        String mappedBy = this.getMappedBy();
        Entity targetEntity = this.getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        PersistentAttribute attribute = targetEntity.getPersistentType().resolveAttribute(mappedBy);
        if (attribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_UNRESOLVED_MAPPED_BY", new String[]{mappedBy}, this, this.getMappedByTextRange(astRoot)));
            return;
        }
        if (!this.mappedByIsValid(attribute.getMapping())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_INVALID_MAPPED_BY", new String[]{mappedBy}, this, this.getMappedByTextRange(astRoot)));
            return;
        }
        try {
            mappedByMapping = (NonOwningMapping)attribute.getMapping();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (mappedByMapping.getMappedBy() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "MAPPING_MAPPED_BY_ON_BOTH_SIDES", this, this.getMappedByTextRange(astRoot)));
        }
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return super.joinColumns();
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return super.specifiedJoinColumns();
    }
}

