/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPersistentAttribute
extends AbstractJavaJpaContextNode
implements JavaPersistentAttribute {
    protected String name;
    protected JavaAttributeMapping defaultMapping;
    protected JavaAttributeMapping specifiedMapping;
    protected JavaResourcePersistentAttribute resourcePersistentAttribute;

    public GenericJavaPersistentAttribute(JavaPersistentType parent) {
        super(parent);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.java.persistentAttribute";
    }

    @Override
    public void initializeFromResource(JavaResourcePersistentAttribute persistentAttributeResource) {
        this.resourcePersistentAttribute = persistentAttributeResource;
        this.name = this.name(persistentAttributeResource);
        this.initializeDefaultMapping(persistentAttributeResource);
        this.initializeSpecifiedMapping(persistentAttributeResource);
    }

    protected void initializeDefaultMapping(JavaResourcePersistentAttribute persistentAttributeResource) {
        this.defaultMapping = this.getJpaPlatform().buildDefaultJavaAttributeMapping(this);
        this.defaultMapping.initializeFromResource(persistentAttributeResource);
    }

    protected void initializeSpecifiedMapping(JavaResourcePersistentAttribute persistentAttributeResource) {
        String javaMappingAnnotationName = this.javaMappingAnnotationName(persistentAttributeResource);
        this.specifiedMapping = this.createJavaAttributeMappingFromAnnotation(javaMappingAnnotationName, persistentAttributeResource);
    }

    @Override
    public JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.resourcePersistentAttribute;
    }

    @Override
    public JavaPersistentType getPersistentType() {
        return (JavaPersistentType)this.getParent();
    }

    @Override
    public JavaTypeMapping getTypeMapping() {
        return this.getPersistentType().getMapping();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.getMapping().getPrimaryKeyColumnName();
    }

    @Override
    public boolean isOverridableAttribute() {
        return this.getMapping().isOverridableAttributeMapping();
    }

    @Override
    public boolean isOverridableAssociation() {
        return this.getMapping().isOverridableAssociationMapping();
    }

    @Override
    public boolean isIdAttribute() {
        return this.getMapping().isIdMapping();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    public JavaAttributeMapping getDefaultMapping() {
        return this.defaultMapping;
    }

    protected void setDefaultMapping(JavaAttributeMapping newDefaultMapping) {
        JavaAttributeMapping oldMapping = this.defaultMapping;
        this.defaultMapping = newDefaultMapping;
        this.firePropertyChanged("defaultMappingProperty", oldMapping, newDefaultMapping);
    }

    @Override
    public JavaAttributeMapping getSpecifiedMapping() {
        return this.specifiedMapping;
    }

    protected void setSpecifiedMapping(JavaAttributeMapping newSpecifiedMapping) {
        JavaAttributeMapping oldMapping = this.specifiedMapping;
        this.specifiedMapping = newSpecifiedMapping;
        this.firePropertyChanged("specifiedMappingProperty", oldMapping, newSpecifiedMapping);
    }

    @Override
    public JavaAttributeMapping getMapping() {
        return this.specifiedMapping != null ? this.specifiedMapping : this.defaultMapping;
    }

    @Override
    public String getMappingKey() {
        return this.getMapping().getKey();
    }

    @Override
    public String getDefaultMappingKey() {
        return this.defaultMapping.getKey();
    }

    public String getSpecifiedMappingKey() {
        return this.specifiedMapping == null ? null : this.specifiedMapping.getKey();
    }

    @Override
    public void setSpecifiedMappingKey(String newKey) {
        JavaAttributeMapping newMapping;
        if (newKey == this.getSpecifiedMappingKey()) {
            return;
        }
        JavaAttributeMapping oldMapping = this.getMapping();
        this.specifiedMapping = newMapping = this.createJavaAttributeMappingFromMappingKey(newKey);
        if (newMapping != null) {
            this.resourcePersistentAttribute.setMappingAnnotation(newMapping.getAnnotationName());
        } else {
            this.resourcePersistentAttribute.setMappingAnnotation(null);
        }
        this.firePropertyChanged("specifiedMappingProperty", oldMapping, newMapping);
        if (oldMapping != null) {
            Collection annotationsToRemove = CollectionTools.collection(oldMapping.correspondingAnnotationNames());
            if (this.getMapping() != null) {
                CollectionTools.removeAll((Collection)annotationsToRemove, this.getMapping().correspondingAnnotationNames());
            }
            for (String annotationName : annotationsToRemove) {
                this.resourcePersistentAttribute.removeAnnotation(annotationName);
            }
        }
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.getFullTextRange(astRoot);
        if (fullTextRange == null) {
            return false;
        }
        return fullTextRange.includes(offset);
    }

    public TextRange getFullTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentAttribute.getTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    public TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentAttribute.getNameTextRange(astRoot);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.resourcePersistentAttribute.getMember().getAstRoot());
    }

    @Override
    public void update(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        this.resourcePersistentAttribute = resourcePersistentAttribute;
        this.setName(this.name(resourcePersistentAttribute));
        this.updateDefaultMapping(resourcePersistentAttribute);
        this.updateSpecifiedMapping(resourcePersistentAttribute);
    }

    protected String name(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        return resourcePersistentAttribute.getName();
    }

    public String specifiedMappingAnnotationName() {
        return this.specifiedMapping == null ? null : this.specifiedMapping.getAnnotationName();
    }

    protected void updateSpecifiedMapping(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        String javaMappingAnnotationName = this.javaMappingAnnotationName(resourcePersistentAttribute);
        if (this.specifiedMappingAnnotationName() != javaMappingAnnotationName) {
            this.setSpecifiedMapping(this.createJavaAttributeMappingFromAnnotation(javaMappingAnnotationName, resourcePersistentAttribute));
        } else if (this.getSpecifiedMapping() != null) {
            this.getSpecifiedMapping().update(resourcePersistentAttribute);
        }
    }

    protected void updateDefaultMapping(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        String defaultMappingKey = this.getJpaPlatform().defaultJavaAttributeMappingKey(this);
        if (this.getDefaultMapping().getKey() != defaultMappingKey) {
            JavaAttributeMapping oldDefaultMapping = this.defaultMapping;
            this.defaultMapping = this.getJpaPlatform().buildDefaultJavaAttributeMapping(this);
            this.defaultMapping.initializeFromResource(resourcePersistentAttribute);
            this.firePropertyChanged("defaultMappingProperty", oldDefaultMapping, this.defaultMapping);
        } else {
            this.getDefaultMapping().update(resourcePersistentAttribute);
        }
    }

    protected String javaMappingAnnotationName(JavaResourcePersistentAttribute resourcePersistentAttribute) {
        Annotation mappingAnnotation = (Annotation)resourcePersistentAttribute.getMappingAnnotation();
        if (mappingAnnotation != null) {
            return mappingAnnotation.getAnnotationName();
        }
        return null;
    }

    protected JavaAttributeMapping createJavaAttributeMappingFromMappingKey(String key) {
        if (key == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            return null;
        }
        return this.getJpaPlatform().buildJavaAttributeMappingFromMappingKey(key, this);
    }

    protected JavaAttributeMapping createJavaAttributeMappingFromAnnotation(String annotationName, JavaResourcePersistentAttribute resourcePersistentAttribute) {
        if (annotationName == null) {
            return null;
        }
        JavaAttributeMapping mapping = this.getJpaPlatform().buildJavaAttributeMappingFromAnnotation(annotationName, this);
        mapping.initializeFromResource(resourcePersistentAttribute);
        return mapping;
    }

    public boolean mappingIsDefault(JavaAttributeMapping mapping) {
        return this.defaultMapping == mapping;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return this.getMapping().javaCompletionProposals(pos, filter, astRoot);
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        super.addToMessages(messages, astRoot);
        if (this.specifiedMapping != null) {
            this.specifiedMapping.addToMessages(messages, astRoot);
        } else if (this.defaultMapping != null) {
            this.defaultMapping.addToMessages(messages, astRoot);
        }
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getName());
    }
}

