/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPersistentType
extends AbstractJavaJpaContextNode
implements JavaPersistentType {
    protected String name;
    protected JavaTypeMapping mapping;
    protected final List<JavaPersistentAttribute> attributes = new ArrayList<JavaPersistentAttribute>();
    protected AccessType access;
    protected PersistentType parentPersistentType;
    protected JavaResourcePersistentType resourcePersistentType;

    public GenericJavaPersistentType(JpaContextNode parent, JavaResourcePersistentType resourcePersistentType) {
        super(parent);
        this.initialize(resourcePersistentType);
    }

    @Override
    public IResource getResource() {
        return this.resourcePersistentType.getResourceModel().getResource().getCompilationUnit().getResource();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.java.persistentType";
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public JavaTypeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public String getMappingKey() {
        return this.getMapping().getKey();
    }

    @Override
    public void setMappingKey(String key) {
        JavaTypeMapping newMapping;
        if (key == this.getMapping().getKey()) {
            return;
        }
        JavaTypeMapping oldMapping = this.getMapping();
        this.mapping = newMapping = this.createJavaTypeMappingFromMappingKey(key);
        this.resourcePersistentType.setMappingAnnotation(newMapping.getAnnotationName());
        this.firePropertyChanged("mappingProperty", oldMapping, newMapping);
        if (oldMapping != null) {
            Collection annotationsToRemove = CollectionTools.collection(oldMapping.correspondingAnnotationNames());
            if (this.getMapping() != null) {
                CollectionTools.removeAll((Collection)annotationsToRemove, this.getMapping().correspondingAnnotationNames());
            }
            for (String annotationName : annotationsToRemove) {
                this.resourcePersistentType.removeAnnotation(annotationName);
            }
        }
    }

    protected void setMapping(JavaTypeMapping newMapping) {
        JavaTypeMapping oldMapping = this.mapping;
        this.mapping = newMapping;
        this.firePropertyChanged("mappingProperty", oldMapping, newMapping);
    }

    @Override
    public boolean isMapped() {
        return this.getMapping().isMapped();
    }

    @Override
    public AccessType getAccess() {
        return this.access;
    }

    protected void setAccess(AccessType newAccess) {
        AccessType oldAccess = this.access;
        this.access = newAccess;
        this.firePropertyChanged("accessProperty", (Object)oldAccess, (Object)newAccess);
    }

    protected Iterator<JavaPersistentAttribute> attributesNamed(final String attributeName) {
        return new FilteringIterator<JavaPersistentAttribute, JavaPersistentAttribute>(this.attributes()){

            protected boolean accept(JavaPersistentAttribute o) {
                return attributeName.equals(o.getName());
            }
        };
    }

    @Override
    public JavaPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.attributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public PersistentAttribute resolveAttribute(String attributeName) {
        Iterator<JavaPersistentAttribute> stream = this.attributesNamed(attributeName);
        if (stream.hasNext()) {
            JavaPersistentAttribute attribute = stream.next();
            return stream.hasNext() ? null : attribute;
        }
        return this.getParentPersistentType() == null ? null : this.getParentPersistentType().resolveAttribute(attributeName);
    }

    @Override
    public ListIterator<JavaPersistentAttribute> attributes() {
        return new CloneListIterator(this.attributes);
    }

    @Override
    public int attributesSize() {
        return this.attributes.size();
    }

    private void addAttribute(JavaPersistentAttribute attribute) {
        this.addItemToList(attribute, this.attributes, "specifiedAttributesList");
    }

    private void removeAttribute(JavaPersistentAttribute attribute) {
        this.removeItemFromList(attribute, this.attributes, "specifiedAttributesList");
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames(this.attributes());
    }

    protected Iterator<String> attributeNames(Iterator<? extends PersistentAttribute> attrs) {
        return new TransformationIterator<PersistentAttribute, String>(attrs){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    @Override
    public Iterator<PersistentAttribute> allAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<PersistentType, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(PersistentType pt) {
                return pt.attributes();
            }
        });
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.attributeNames(this.allAttributes());
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        Iterator values = this.mapping.javaCompletionProposals(pos, filter, astRoot);
        if (values != null) {
            return values;
        }
        ListIterator<JavaPersistentAttribute> stream = this.attributes();
        while (stream.hasNext()) {
            values = ((JavaPersistentAttribute)stream.next()).javaCompletionProposals(pos, filter, astRoot);
            if (values == null) continue;
            return values;
        }
        return EmptyIterator.instance();
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        CompilationUnit astRoot = this.resourcePersistentType.getMember().getAstRoot();
        ListIterator<JavaPersistentAttribute> i = this.attributes();
        while (i.hasNext()) {
            JavaPersistentAttribute persistentAttribute = (JavaPersistentAttribute)i.next();
            if (!persistentAttribute.contains(offset, astRoot)) continue;
            return persistentAttribute;
        }
        return this;
    }

    public boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.getFullTextRange(astRoot);
        if (fullTextRange == null) {
            return false;
        }
        return fullTextRange.includes(offset);
    }

    public TextRange getFullTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getSelectionTextRange(astRoot);
    }

    public TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getNameTextRange(astRoot);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.resourcePersistentType.getMember().getAstRoot());
    }

    @Override
    public Iterator<PersistentType> inheritanceHierarchy() {
        return new ChainIterator<PersistentType>((PersistentType)this){

            protected PersistentType nextLink(PersistentType pt) {
                return pt.getParentPersistentType();
            }
        };
    }

    @Override
    public PersistentType getParentPersistentType() {
        return this.parentPersistentType;
    }

    @Override
    public boolean hasAnyAttributeMappingAnnotations() {
        return this.resourcePersistentType.hasAnyAttributeAnnotations();
    }

    protected void initialize(JavaResourcePersistentType resourcePersistentType) {
        this.resourcePersistentType = resourcePersistentType;
        this.parentPersistentType = this.parentPersistentType(resourcePersistentType);
        this.access = this.access(resourcePersistentType);
        this.name = this.name(resourcePersistentType);
        this.initializeMapping(resourcePersistentType);
        this.initializePersistentAttributes(resourcePersistentType);
    }

    protected void initializeMapping(JavaResourcePersistentType persistentTypeResource) {
        this.mapping = this.getJpaPlatform().buildJavaTypeMappingFromAnnotation(this.javaMappingAnnotationName(persistentTypeResource), this);
        this.mapping.initializeFromResource(persistentTypeResource);
    }

    protected void initializePersistentAttributes(JavaResourcePersistentType persistentTypeResource) {
        Iterator<JavaResourcePersistentAttribute> resourceAttributes = persistentTypeResource.fields();
        if (this.getAccess() == AccessType.PROPERTY) {
            resourceAttributes = persistentTypeResource.properties();
        }
        while (resourceAttributes.hasNext()) {
            this.attributes.add(this.createAttribute(resourceAttributes.next()));
        }
    }

    @Override
    public void update(JavaResourcePersistentType resourcePersistentType) {
        this.resourcePersistentType = resourcePersistentType;
        this.resourcePersistentType.getResourceModel().addRootStructureNode(this);
        this.updateParentPersistentType(resourcePersistentType);
        this.updateAccess(resourcePersistentType);
        this.updateName(resourcePersistentType);
        this.updateMapping(resourcePersistentType);
        this.updatePersistentAttributes(resourcePersistentType);
    }

    protected void updateAccess(JavaResourcePersistentType resourcePersistentType) {
        this.setAccess(this.access(resourcePersistentType));
    }

    protected AccessType access(JavaResourcePersistentType resourcePersistentType) {
        AccessType javaAccess = null;
        boolean metadataComplete = false;
        if (this.getOrmPersistentType() != null) {
            javaAccess = this.getOrmPersistentType().getMapping().getSpecifiedAccess();
            metadataComplete = this.getOrmPersistentType().getMapping().isMetadataComplete();
        }
        if (javaAccess == null && !metadataComplete) {
            javaAccess = AccessType.fromJavaResourceModel(resourcePersistentType.getAccess());
        }
        if (javaAccess == null && this.getParentPersistentType() != null) {
            javaAccess = this.getParentPersistentType().getAccess();
        }
        if (javaAccess == null && this.getEntityMappings() != null) {
            javaAccess = this.getEntityMappings().getAccess();
        }
        if (javaAccess == null && this.getPersistenceUnit() != null) {
            javaAccess = this.getPersistenceUnit().getDefaultAccess();
        }
        if (javaAccess == null) {
            javaAccess = AccessType.FIELD;
        }
        return javaAccess;
    }

    protected void updateName(JavaResourcePersistentType resourcePersistentType) {
        this.setName(this.name(resourcePersistentType));
    }

    protected String name(JavaResourcePersistentType resourcePersistentType) {
        return resourcePersistentType.getQualifiedName();
    }

    protected void updateMapping(JavaResourcePersistentType resourcePersistentType) {
        String javaMappingAnnotationName = this.javaMappingAnnotationName(resourcePersistentType);
        if (this.getMapping().getAnnotationName() != javaMappingAnnotationName) {
            this.setMapping(this.createJavaTypeMappingFromAnnotation(javaMappingAnnotationName, resourcePersistentType));
        } else {
            this.getMapping().update(resourcePersistentType);
        }
    }

    protected JavaTypeMapping createJavaTypeMappingFromMappingKey(String key) {
        return this.getJpaPlatform().buildJavaTypeMappingFromMappingKey(key, this);
    }

    protected JavaTypeMapping createJavaTypeMappingFromAnnotation(String annotationName, JavaResourcePersistentType resourcePersistentType) {
        JavaTypeMapping mapping = this.getJpaPlatform().buildJavaTypeMappingFromAnnotation(annotationName, this);
        mapping.initializeFromResource(resourcePersistentType);
        return mapping;
    }

    protected String javaMappingAnnotationName(JavaResourcePersistentType resourcePersistentType) {
        Annotation mappingAnnotation = (Annotation)resourcePersistentType.getMappingAnnotation();
        if (mappingAnnotation != null) {
            return mappingAnnotation.getAnnotationName();
        }
        return null;
    }

    protected void updatePersistentAttributes(JavaResourcePersistentType resourcePersistentType) {
        ListIterator<JavaPersistentAttribute> contextAttributes = this.attributes();
        Iterator<JavaResourcePersistentAttribute> resourceAttributes = resourcePersistentType.fields();
        if (this.getAccess() == AccessType.PROPERTY) {
            resourceAttributes = resourcePersistentType.properties();
        }
        while (contextAttributes.hasNext()) {
            JavaPersistentAttribute persistentAttribute = contextAttributes.next();
            if (resourceAttributes.hasNext()) {
                persistentAttribute.update(resourceAttributes.next());
                continue;
            }
            this.removeAttribute(persistentAttribute);
        }
        while (resourceAttributes.hasNext()) {
            this.addAttribute(this.createAttribute(resourceAttributes.next()));
        }
    }

    protected JavaPersistentAttribute createAttribute(JavaResourcePersistentAttribute persistentAttributeResource) {
        JavaPersistentAttribute javaPersistentAttribute = this.getJpaFactory().buildJavaPersistentAttribute(this);
        javaPersistentAttribute.initializeFromResource(persistentAttributeResource);
        return javaPersistentAttribute;
    }

    public void updateParentPersistentType(JavaResourcePersistentType persistentTypeResource) {
        this.parentPersistentType = this.parentPersistentType(persistentTypeResource);
    }

    protected PersistentType parentPersistentType(JavaResourcePersistentType persistentTypeResource) {
        return this.parentPersistentType(persistentTypeResource.getSuperClassQualifiedName());
    }

    protected PersistentType parentPersistentType(String fullyQualifiedTypeName) {
        PersistentType possibleParent = this.possibleParent(fullyQualifiedTypeName);
        if (possibleParent == null) {
            return null;
        }
        if (possibleParent.isMapped()) {
            return possibleParent;
        }
        return possibleParent.getParentPersistentType();
    }

    protected PersistentType possibleParent(String fullyQualifiedTypeName) {
        PersistentType possibleParent = this.getPersistentType(fullyQualifiedTypeName);
        if (possibleParent != null) {
            return possibleParent;
        }
        JavaResourcePersistentType resourcePersistentType = this.getJpaProject().getJavaPersistentTypeResource(fullyQualifiedTypeName);
        if (resourcePersistentType != null) {
            return this.possibleParent(resourcePersistentType.getSuperClassQualifiedName());
        }
        return null;
    }

    protected PersistentType getPersistentType(String fullyQualifiedTypeName) {
        return this.getPersistenceUnit().getPersistentType(fullyQualifiedTypeName);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        this.addToMessages(messages, this.resourcePersistentType.getMember().getAstRoot());
    }

    @Override
    public void addToMessages(List<IMessage> messages, CompilationUnit astRoot) {
        this.mapping.addToMessages(messages, astRoot);
        this.addAttributeMessages(messages, astRoot);
    }

    protected void addAttributeMessages(List<IMessage> messages, CompilationUnit astRoot) {
        for (JavaPersistentAttribute attributeContext : this.attributes) {
            attributeContext.addToMessages(messages, astRoot);
        }
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getName());
    }
}

