/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaBaseJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPrimaryKeyJoinColumn
extends AbstractJavaNamedColumn<PrimaryKeyJoinColumnAnnotation>
implements JavaPrimaryKeyJoinColumn {
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;
    protected PrimaryKeyJoinColumnAnnotation primaryKeyJoinColumnResource;

    public GenericJavaPrimaryKeyJoinColumn(JavaJpaContextNode parent, JavaBaseJoinColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void initializeFromResource(PrimaryKeyJoinColumnAnnotation column) {
        this.primaryKeyJoinColumnResource = column;
        super.initializeFromResource(column);
        this.specifiedReferencedColumnName = this.specifiedReferencedColumnName(column);
        this.defaultReferencedColumnName = this.defaultReferencedColumnName();
    }

    @Override
    public JavaBaseJoinColumn.Owner getOwner() {
        return (JavaBaseJoinColumn.Owner)super.getOwner();
    }

    @Override
    protected PrimaryKeyJoinColumnAnnotation getColumnResource() {
        return this.primaryKeyJoinColumnResource;
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName == null ? this.defaultReferencedColumnName : this.specifiedReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.getColumnResource().setReferencedColumnName(newSpecifiedReferencedColumnName);
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    protected void setSpecifiedReferencedColumnName_(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        this.firePropertyChanged("defaultReferencedColumnName", oldDefaultReferencedColumnName, newDefaultReferencedColumnName);
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    protected String getTableName() {
        return this.getOwner().getTypeMapping().getTableName();
    }

    @Override
    public Column getDbReferencedColumn() {
        Table table = this.getDbReferencedColumnTable();
        return table == null ? null : table.columnNamed(this.getReferencedColumnName());
    }

    public Table getDbReferencedColumnTable() {
        return this.getOwner().getDbReferencedColumnTable();
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.getColumnResource().referencedColumnNameTouches(pos, astRoot);
    }

    private Iterator<String> candidateReferencedColumnNames() {
        Table table = this.getOwner().getDbReferencedColumnTable();
        return table != null ? table.columnNames() : EmptyIterator.instance();
    }

    private Iterator<String> candidateReferencedColumnNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateReferencedColumnNames(), filter);
    }

    private Iterator<String> quotedCandidateReferencedColumnNames(Filter<String> filter) {
        return StringTools.quote(this.candidateReferencedColumnNames(filter));
    }

    @Override
    public Iterator<String> connectedCandidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedCandidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos, astRoot)) {
            return this.quotedCandidateReferencedColumnNames(filter);
        }
        return null;
    }

    @Override
    public boolean isReferencedColumnResolved() {
        return this.getDbReferencedColumn() != null;
    }

    @Override
    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        return this.getColumnResource().getReferencedColumnNameTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getColumnResource().getTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    @Override
    public void update(PrimaryKeyJoinColumnAnnotation column) {
        this.primaryKeyJoinColumnResource = column;
        super.update(column);
        this.setSpecifiedReferencedColumnName_(this.specifiedReferencedColumnName(column));
        this.setDefaultReferencedColumnName(this.defaultReferencedColumnName());
    }

    protected String specifiedReferencedColumnName(PrimaryKeyJoinColumnAnnotation column) {
        return column.getReferencedColumnName();
    }

    protected String defaultReferencedColumnName() {
        return this.defaultName();
    }
}

