/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmBaseEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedIdMapping;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmMultiRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmSingleRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmTransientMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmAttributeMapping<T extends XmlAttributeMapping>
extends AbstractOrmJpaContextNode
implements OrmAttributeMapping {
    protected String name;
    protected T attributeMapping;
    protected JavaPersistentAttribute javaPersistentAttribute;

    protected AbstractOrmAttributeMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public JavaPersistentAttribute getJavaPersistentAttribute() {
        return this.javaPersistentAttribute;
    }

    protected void setJavaPersistentAttribute(JavaPersistentAttribute newJavaPersistentAttribute) {
        JavaPersistentAttribute oldJavaPersistentAttribute = this.javaPersistentAttribute;
        this.javaPersistentAttribute = newJavaPersistentAttribute;
        this.firePropertyChanged("javaPersistentAttributeProperty", oldJavaPersistentAttribute, newJavaPersistentAttribute);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.attributeMapping.setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
        this.getPersistentAttribute().nameChanged(oldName, newName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("nameProperty", oldName, newName);
        this.getPersistentAttribute().nameChanged(oldName, newName);
    }

    @Override
    public OrmPersistentAttribute getPersistentAttribute() {
        return (OrmPersistentAttribute)this.getParent();
    }

    public String getAttributeName() {
        return this.getPersistentAttribute().getName();
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public void initializeFromOrmAttributeMapping(OrmAttributeMapping oldMapping) {
        this.setName(oldMapping.getName());
    }

    public void initializeFromXmlColumnMapping(OrmColumnMapping oldMapping) {
        this.initializeFromOrmAttributeMapping((OrmAttributeMapping)((Object)oldMapping));
    }

    public void initializeFromXmlNonOwningMapping(NonOwningMapping oldMapping) {
        this.initializeFromOrmAttributeMapping((OrmAttributeMapping)((Object)oldMapping));
    }

    @Override
    public void initializeFromOrmBasicMapping(OrmBasicMapping oldMapping) {
        this.initializeFromXmlColumnMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmIdMapping(OrmIdMapping oldMapping) {
        this.initializeFromXmlColumnMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmTransientMapping(OrmTransientMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    public void initializeFromOrmBaseEmbeddedMapping(OrmBaseEmbeddedMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmEmbeddedMapping(OrmEmbeddedMapping oldMapping) {
        this.initializeFromOrmBaseEmbeddedMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmEmbeddedIdMapping(OrmEmbeddedIdMapping oldMapping) {
        this.initializeFromOrmBaseEmbeddedMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmVersionMapping(OrmVersionMapping oldMapping) {
        this.initializeFromXmlColumnMapping(oldMapping);
    }

    public void initializeFromXmlRelationshipMapping(OrmRelationshipMapping oldMapping) {
        this.initializeFromOrmAttributeMapping(oldMapping);
    }

    public void initializeFromXmlMulitRelationshipMapping(OrmMultiRelationshipMapping oldMapping) {
        this.initializeFromXmlRelationshipMapping(oldMapping);
    }

    public void initializeFromXmlSingleRelationshipMapping(OrmSingleRelationshipMapping oldMapping) {
        this.initializeFromXmlRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmOneToManyMapping(OrmOneToManyMapping oldMapping) {
        this.initializeFromXmlNonOwningMapping(oldMapping);
        this.initializeFromXmlMulitRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmManyToOneMapping(OrmManyToOneMapping oldMapping) {
        this.initializeFromXmlSingleRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmOneToOneMapping(OrmOneToOneMapping oldMapping) {
        this.initializeFromXmlNonOwningMapping(oldMapping);
        this.initializeFromXmlSingleRelationshipMapping(oldMapping);
    }

    @Override
    public void initializeFromOrmManyToManyMapping(OrmManyToManyMapping oldMapping) {
        this.initializeFromXmlNonOwningMapping(oldMapping);
        this.initializeFromXmlMulitRelationshipMapping(oldMapping);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public OrmTypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getTypeMapping();
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isIdMapping() {
        return false;
    }

    protected T getAttributeMapping() {
        return this.attributeMapping;
    }

    public void initialize(T attributeMapping) {
        this.attributeMapping = attributeMapping;
        this.name = attributeMapping.getName();
        this.javaPersistentAttribute = this.findJavaPersistentAttribute();
    }

    public void update(T attributeMapping) {
        this.attributeMapping = attributeMapping;
        this.setName_(attributeMapping.getName());
        this.setJavaPersistentAttribute(this.findJavaPersistentAttribute());
    }

    protected JavaPersistentAttribute findJavaPersistentAttribute() {
        JavaPersistentType javaPersistentType = this.getPersistentAttribute().getPersistentType().getJavaPersistentType();
        if (javaPersistentType != null && this.getName() != null) {
            return javaPersistentType.getAttributeNamed(this.getName());
        }
        return null;
    }

    protected boolean entityOwned() {
        return this.getTypeMapping().getKey() == "entity";
    }

    @Override
    public boolean contains(int textOffset) {
        return this.attributeMapping.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.attributeMapping.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getPersistentAttribute().isVirtual() ? this.getTypeMapping().getAttributesTextRange() : this.attributeMapping.getValidationTextRange();
    }

    public TextRange getNameTextRange() {
        return this.attributeMapping.getNameTextRange();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addAttributeMessages(messages);
        this.addInvalidMappingMessage(messages);
    }

    protected void addAttributeMessages(List<IMessage> messages) {
        this.addUnspecifiedAttributeMessage(messages);
        this.addUnresolvedAttributeMessage(messages);
        this.addModifierMessages(messages);
    }

    protected void addUnspecifiedAttributeMessage(List<IMessage> messages) {
        if (StringTools.stringIsEmpty((String)this.getName())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNSPECIFIED_NAME", this, this.getValidationTextRange()));
        }
    }

    protected void addUnresolvedAttributeMessage(List<IMessage> messages) {
        if (!StringTools.stringIsEmpty((String)this.getName()) && this.findJavaPersistentAttribute() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME", new String[]{this.getName(), this.getPersistentAttribute().getPersistentType().getMapping().getClass_()}, this, this.getNameTextRange()));
        }
    }

    protected void addModifierMessages(List<IMessage> messages) {
        if (this.getKey() == "transient") {
            return;
        }
        if (this.getJavaPersistentAttribute() == null) {
            return;
        }
        JavaResourcePersistentAttribute resourcePersistentAttribute = this.getJavaPersistentAttribute().getResourcePersistentAttribute();
        if (resourcePersistentAttribute == null) {
            return;
        }
        if (resourcePersistentAttribute.isForField()) {
            int flags;
            try {
                flags = resourcePersistentAttribute.getMember().getJdtMember().getFlags();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            if (Flags.isFinal((int)flags)) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_FINAL_FIELD", new String[]{this.getName()}, this.getPersistentAttribute(), this.getPersistentAttribute().getValidationTextRange()));
            }
            if (Flags.isPublic((int)flags)) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_PUBLIC_FIELD", new String[]{this.getName()}, this.getPersistentAttribute(), this.getPersistentAttribute().getValidationTextRange()));
            }
        }
    }

    protected void addInvalidMappingMessage(List<IMessage> messages) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{this.getName()}, this, this.getValidationTextRange()));
        }
    }
}

