/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmBaseEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.resource.orm.BaseXmlEmbedded;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverrideImpl;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmBaseEmbeddedMapping<T extends BaseXmlEmbedded>
extends AbstractOrmAttributeMapping<T>
implements OrmBaseEmbeddedMapping {
    protected final List<OrmAttributeOverride> specifiedAttributeOverrides = new ArrayList<OrmAttributeOverride>();
    protected final List<OrmAttributeOverride> virtualAttributeOverrides = new ArrayList<OrmAttributeOverride>();
    private Embeddable embeddable;

    protected AbstractOrmBaseEmbeddedMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void initializeFromOrmBaseEmbeddedMapping(OrmBaseEmbeddedMapping oldMapping) {
        super.initializeFromOrmBaseEmbeddedMapping(oldMapping);
        int index = 0;
        for (OrmAttributeOverride attributeOverride : CollectionTools.iterable(oldMapping.specifiedAttributeOverrides())) {
            OrmAttributeOverride newAttributeOverride = this.addSpecifiedAttributeOverride(index++);
            newAttributeOverride.setName(attributeOverride.getName());
            newAttributeOverride.getColumn().initializeFrom(attributeOverride.getColumn());
        }
    }

    @Override
    public ListIterator<OrmAttributeOverride> attributeOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributeOverrides(), this.virtualAttributeOverrides()});
    }

    @Override
    public int attributeOverridesSize() {
        return 0;
    }

    @Override
    public ListIterator<OrmAttributeOverride> virtualAttributeOverrides() {
        return new CloneListIterator(this.virtualAttributeOverrides);
    }

    @Override
    public int virtualAttributeOverridesSize() {
        return this.virtualAttributeOverrides.size();
    }

    @Override
    public ListIterator<OrmAttributeOverride> specifiedAttributeOverrides() {
        return new CloneListIterator(this.specifiedAttributeOverrides);
    }

    @Override
    public int specifiedAttributeOverridesSize() {
        return this.specifiedAttributeOverrides.size();
    }

    protected OrmAttributeOverride addSpecifiedAttributeOverride(int index) {
        XmlAttributeOverrideImpl xmlAttributeOverride = OrmFactory.eINSTANCE.createXmlAttributeOverrideImpl();
        OrmAttributeOverride attributeOverride = this.buildAttributeOverride(xmlAttributeOverride);
        this.specifiedAttributeOverrides.add(index, attributeOverride);
        ((BaseXmlEmbedded)this.getAttributeMapping()).getAttributeOverrides().add(index, (Object)xmlAttributeOverride);
        this.fireItemAdded("specifiedAttributeOverridesList", index, attributeOverride);
        return attributeOverride;
    }

    protected void addSpecifiedAttributeOverride(int index, OrmAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverridesList");
    }

    protected void removeSpecifiedAttributeOverride_(OrmAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverridesList");
    }

    @Override
    public void moveSpecifiedAttributeOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAttributeOverrides, (int)targetIndex, (int)sourceIndex);
        ((BaseXmlEmbedded)this.getAttributeMapping()).getAttributeOverrides().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedAttributeOverridesList", targetIndex, sourceIndex);
    }

    @Override
    public boolean isVirtual(BaseOverride override) {
        return this.virtualAttributeOverrides.contains(override);
    }

    @Override
    public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
        return null;
    }

    @Override
    public ColumnMapping getColumnMapping(String attributeName) {
        return MappingTools.getColumnMapping(attributeName, this.getEmbeddable());
    }

    public Embeddable getEmbeddable() {
        return this.embeddable;
    }

    public Iterator<String> allOverridableAttributeNames() {
        return new TransformationIterator<PersistentAttribute, String>(this.allOverridableAttributes()){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    public Iterator<PersistentAttribute> allOverridableAttributes() {
        if (this.getEmbeddable() == null) {
            return EmptyIterator.instance();
        }
        return new FilteringIterator<PersistentAttribute, PersistentAttribute>((Iterator)this.getEmbeddable().getPersistentType().attributes()){

            protected boolean accept(PersistentAttribute o) {
                return o.isOverridableAttribute();
            }
        };
    }

    @Override
    public void initialize(T embedded) {
        super.initialize(embedded);
        this.embeddable = AbstractOrmBaseEmbeddedMapping.embeddableFor(this.findJavaPersistentAttribute());
        this.initializeSpecifiedAttributeOverrides(embedded);
    }

    protected void initializeSpecifiedAttributeOverrides(T embedded) {
        for (XmlAttributeOverride attributeOverride : embedded.getAttributeOverrides()) {
            this.specifiedAttributeOverrides.add(this.buildAttributeOverride(attributeOverride));
        }
    }

    protected OrmAttributeOverride buildAttributeOverride(XmlAttributeOverride attributeOverride) {
        return this.getJpaFactory().buildOrmAttributeOverride(this, this, attributeOverride);
    }

    @Override
    public void update(T embedded) {
        super.update(embedded);
        this.embeddable = AbstractOrmBaseEmbeddedMapping.embeddableFor(this.findJavaPersistentAttribute());
        this.updateSpecifiedAttributeOverrides(embedded);
    }

    protected void updateSpecifiedAttributeOverrides(T embedded) {
        ListIterator<OrmAttributeOverride> attributeOverrides = this.specifiedAttributeOverrides();
        ListIterator resourceAttributeOverrides = embedded.getAttributeOverrides().listIterator();
        while (attributeOverrides.hasNext()) {
            OrmAttributeOverride attributeOverride = attributeOverrides.next();
            if (resourceAttributeOverrides.hasNext()) {
                attributeOverride.update((XmlAttributeOverride)resourceAttributeOverrides.next());
                continue;
            }
            this.removeSpecifiedAttributeOverride_(attributeOverride);
        }
        while (resourceAttributeOverrides.hasNext()) {
            this.addSpecifiedAttributeOverride(this.specifiedAttributeOverridesSize(), this.buildAttributeOverride((XmlAttributeOverride)resourceAttributeOverrides.next()));
        }
    }

    public static Embeddable embeddableFor(JavaPersistentAttribute javaPersistentAttribute) {
        if (javaPersistentAttribute == null) {
            return null;
        }
        return MappingTools.getEmbeddableFor(javaPersistentAttribute);
    }
}

