/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.QueryHint;
import org.eclipse.jpt.core.context.java.JavaQuery;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmQuery;
import org.eclipse.jpt.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlQuery;
import org.eclipse.jpt.core.resource.orm.XmlQueryHint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmQuery<E extends XmlQuery>
extends AbstractOrmJpaContextNode
implements OrmQuery {
    protected String name;
    protected String query;
    protected final List<OrmQueryHint> hints = new ArrayList<OrmQueryHint>();
    protected E queryResource;

    protected AbstractOrmQuery(OrmJpaContextNode parent) {
        super(parent);
    }

    protected E getQueryResource() {
        return this.queryResource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.getQueryResource().setName(newName);
        this.firePropertyChanged("nameProperty", oldName, newName);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String newQuery) {
        String oldQuery = this.query;
        this.query = newQuery;
        this.getQueryResource().setQuery(newQuery);
        this.firePropertyChanged("queryProperty", oldQuery, newQuery);
    }

    @Override
    public ListIterator<OrmQueryHint> hints() {
        return new CloneListIterator(this.hints);
    }

    @Override
    public int hintsSize() {
        return this.hints.size();
    }

    @Override
    public OrmQueryHint addHint(int index) {
        OrmQueryHint queryHint = this.getJpaFactory().buildOrmQueryHint(this);
        this.hints.add(index, queryHint);
        this.getQueryResource().getHints().add(index, (Object)OrmFactory.eINSTANCE.createXmlQueryHint());
        this.fireItemAdded("hintsList", index, queryHint);
        return queryHint;
    }

    protected void addHint(int index, OrmQueryHint queryHint) {
        this.addItemToList(index, queryHint, this.hints, "hintsList");
    }

    @Override
    public void removeHint(QueryHint queryHint) {
        this.removeHint(this.hints.indexOf(queryHint));
    }

    @Override
    public void removeHint(int index) {
        OrmQueryHint queryHint = this.hints.remove(index);
        this.queryResource.getHints().remove(index);
        this.fireItemRemoved("hintsList", index, queryHint);
    }

    protected void removeHint_(OrmQueryHint queryHint) {
        this.removeItemFromList(queryHint, this.hints, "hintsList");
    }

    @Override
    public void moveHint(int targetIndex, int sourceIndex) {
        this.queryResource.getHints().move(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.hints, "hintsList");
    }

    public void initialize(E queryResource) {
        this.queryResource = queryResource;
        this.name = queryResource.getName();
        this.query = queryResource.getQuery();
        this.initializeHints(queryResource);
    }

    protected void initializeHints(E queryResource) {
        for (XmlQueryHint queryhint : queryResource.getHints()) {
            this.hints.add(this.createHint(queryhint));
        }
    }

    protected OrmQueryHint createHint(XmlQueryHint queryHint) {
        OrmQueryHint ormQueryHint = this.getJpaFactory().buildOrmQueryHint(this);
        ormQueryHint.initialize(queryHint);
        return ormQueryHint;
    }

    public void update(E queryResource) {
        this.queryResource = queryResource;
        this.setName(queryResource.getName());
        this.setQuery(queryResource.getQuery());
        this.updateHints(queryResource);
    }

    protected void updateHints(E queryResource) {
        ListIterator<OrmQueryHint> hints = this.hints();
        ListIterator resourceHints = queryResource.getHints().listIterator();
        while (hints.hasNext()) {
            OrmQueryHint hint = hints.next();
            if (resourceHints.hasNext()) {
                hint.update((XmlQueryHint)resourceHints.next());
                continue;
            }
            this.removeHint_(hint);
        }
        while (resourceHints.hasNext()) {
            this.addHint(this.hintsSize(), this.createHint((XmlQueryHint)resourceHints.next()));
        }
    }

    @Override
    public boolean overrides(Query query) {
        if (this.getName() == null) {
            return false;
        }
        return this.getName().equals(query.getName()) && query instanceof JavaQuery;
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getQueryResource().getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getQueryResource().getNameTextRange();
    }
}

