/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.context.orm.OrmCascade;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.orm.XmlRelationshipMapping;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmRelationshipMapping<T extends XmlRelationshipMapping>
extends AbstractOrmAttributeMapping<T>
implements OrmRelationshipMapping {
    protected String specifiedTargetEntity;
    protected String defaultTargetEntity;
    protected Entity resolvedTargetEntity;
    protected FetchType specifiedFetch;
    protected final OrmCascade cascade = new OrmCascade(this);

    protected AbstractOrmRelationshipMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public String getTargetEntity() {
        return this.getSpecifiedTargetEntity() == null ? this.getDefaultTargetEntity() : this.getSpecifiedTargetEntity();
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String newSpecifiedTargetEntity) {
        String oldSpecifiedTargetEntity = this.specifiedTargetEntity;
        this.specifiedTargetEntity = newSpecifiedTargetEntity;
        ((XmlRelationshipMapping)this.getAttributeMapping()).setTargetEntity(newSpecifiedTargetEntity);
        this.firePropertyChanged("specifiedTargetEntityProperty", oldSpecifiedTargetEntity, newSpecifiedTargetEntity);
    }

    protected void setSpecifiedTargetEntity_(String newSpecifiedTargetEntity) {
        String oldSpecifiedTargetEntity = this.specifiedTargetEntity;
        this.specifiedTargetEntity = newSpecifiedTargetEntity;
        this.firePropertyChanged("specifiedTargetEntityProperty", oldSpecifiedTargetEntity, newSpecifiedTargetEntity);
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String newDefaultTargetEntity) {
        String oldDefaultTargetEntity = this.defaultTargetEntity;
        this.defaultTargetEntity = newDefaultTargetEntity;
        this.firePropertyChanged("defaultTargetEntityProperty", oldDefaultTargetEntity, newDefaultTargetEntity);
    }

    @Override
    public Entity getResolvedTargetEntity() {
        return this.resolvedTargetEntity;
    }

    protected void setResolvedTargetEntity(Entity newResolvedTargetEntity) {
        Entity oldResolvedTargetEntity = this.resolvedTargetEntity;
        this.resolvedTargetEntity = newResolvedTargetEntity;
        this.firePropertyChanged("resolvedTargetEntityProperty", oldResolvedTargetEntity, newResolvedTargetEntity);
    }

    @Override
    public FetchType getFetch() {
        return this.getSpecifiedFetch() == null ? this.getDefaultFetch() : this.getSpecifiedFetch();
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        ((XmlRelationshipMapping)this.getAttributeMapping()).setFetch(FetchType.toOrmResourceModel(newSpecifiedFetch));
        this.firePropertyChanged("specifiedFetchProperty", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected void setSpecifiedFetch_(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        this.firePropertyChanged("specifiedFetchProperty", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    @Override
    public OrmCascade getCascade() {
        return this.cascade;
    }

    @Override
    public void initializeFromXmlRelationshipMapping(OrmRelationshipMapping oldMapping) {
        super.initializeFromXmlRelationshipMapping(oldMapping);
        this.setSpecifiedTargetEntity(oldMapping.getSpecifiedTargetEntity());
        this.setSpecifiedFetch(oldMapping.getSpecifiedFetch());
        this.getCascade().initializeFrom(oldMapping.getCascade());
    }

    public Iterator<String> allTargetEntityAttributeNames() {
        Entity targetEntity = this.getResolvedTargetEntity();
        return targetEntity == null ? EmptyIterator.instance() : targetEntity.getPersistentType().allAttributeNames();
    }

    public Iterator<String> candidateMappedByAttributeNames() {
        return this.allTargetEntityAttributeNames();
    }

    @Override
    public Entity getEntity() {
        if (this.getTypeMapping() instanceof Entity) {
            return (Entity)((Object)this.getTypeMapping());
        }
        return null;
    }

    @Override
    public boolean targetEntityIsValid(String targetEntity) {
        return MappingTools.targetEntityIsValid(targetEntity);
    }

    @Override
    public void initialize(T relationshipMapping) {
        super.initialize(relationshipMapping);
        this.specifiedTargetEntity = relationshipMapping.getTargetEntity();
        this.defaultTargetEntity = this.defaultTargetEntity();
        this.resolvedTargetEntity = this.resolveTargetEntity();
        this.specifiedFetch = this.specifiedFetch((XmlRelationshipMapping)relationshipMapping);
        this.cascade.initialize((XmlRelationshipMapping)relationshipMapping);
    }

    @Override
    public void update(T relationshipMapping) {
        super.update(relationshipMapping);
        this.setSpecifiedTargetEntity_(relationshipMapping.getTargetEntity());
        this.setDefaultTargetEntity(this.defaultTargetEntity());
        this.setResolvedTargetEntity(this.resolveTargetEntity());
        this.setSpecifiedFetch_(this.specifiedFetch((XmlRelationshipMapping)relationshipMapping));
        this.cascade.update((XmlRelationshipMapping)relationshipMapping);
    }

    protected FetchType specifiedFetch(XmlRelationshipMapping relationshipMapping) {
        return FetchType.fromOrmResourceModel(relationshipMapping.getFetch());
    }

    protected RelationshipMapping javaRelationshipMapping() {
        if (this.findJavaPersistentAttribute() == null) {
            return null;
        }
        JavaAttributeMapping javaAttributeMapping = this.findJavaPersistentAttribute().getMapping();
        if (javaAttributeMapping instanceof RelationshipMapping) {
            return (RelationshipMapping)((Object)javaAttributeMapping);
        }
        return null;
    }

    protected String defaultTargetEntity() {
        RelationshipMapping javaMapping = this.javaRelationshipMapping();
        if (javaMapping != null && this.getPersistentAttribute().isVirtual() && !this.getTypeMapping().isMetadataComplete()) {
            return javaMapping.getTargetEntity();
        }
        if (this.findJavaPersistentAttribute() != null) {
            return this.defaultTargetEntity(this.findJavaPersistentAttribute().getResourcePersistentAttribute());
        }
        return null;
    }

    protected abstract String defaultTargetEntity(JavaResourcePersistentAttribute var1);

    protected Entity resolveTargetEntity() {
        String qualifiedTargetEntity = this.getDefaultTargetEntity();
        if (this.getSpecifiedTargetEntity() != null) {
            qualifiedTargetEntity = this.fullyQualifiedTargetEntity();
        }
        if (qualifiedTargetEntity == null) {
            return null;
        }
        PersistentType persistentType = this.getPersistenceUnit().getPersistentType(qualifiedTargetEntity);
        if (persistentType != null && persistentType.getMappingKey() == "entity") {
            return (Entity)persistentType.getMapping();
        }
        return null;
    }

    protected String fullyQualifiedTargetEntity() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        if (this.targetEntityIncludesPackage()) {
            return this.getTargetEntity();
        }
        String package_ = this.getEntityMappings().getPackage();
        if (package_ != null) {
            return String.valueOf(package_) + '.' + this.getTargetEntity();
        }
        return this.getTargetEntity();
    }

    private boolean targetEntityIncludesPackage() {
        return this.getTargetEntity().lastIndexOf(46) != -1;
    }
}

