/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.Nullable;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.SingleRelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmSingleRelationshipMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmRelationshipMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumnImpl;
import org.eclipse.jpt.core.resource.orm.XmlSingleRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmSingleRelationshipMapping<T extends XmlSingleRelationshipMapping>
extends AbstractOrmRelationshipMapping<T>
implements OrmSingleRelationshipMapping {
    protected final List<OrmJoinColumn> specifiedJoinColumns = new ArrayList<OrmJoinColumn>();
    protected OrmJoinColumn defaultJoinColumn;
    protected Boolean specifiedOptional;

    protected AbstractOrmSingleRelationshipMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void initializeFromXmlSingleRelationshipMapping(OrmSingleRelationshipMapping oldMapping) {
        super.initializeFromXmlSingleRelationshipMapping(oldMapping);
        int index = 0;
        for (JoinColumn joinColumn : CollectionTools.iterable(oldMapping.specifiedJoinColumns())) {
            OrmJoinColumn newJoinColumn = this.addSpecifiedJoinColumn(index++);
            newJoinColumn.initializeFrom(joinColumn);
        }
    }

    @Override
    public FetchType getDefaultFetch() {
        return SingleRelationshipMapping.DEFAULT_FETCH_TYPE;
    }

    @Override
    public ListIterator<OrmJoinColumn> joinColumns() {
        return this.specifiedJoinColumns.isEmpty() ? this.defaultJoinColumns() : this.specifiedJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.specifiedJoinColumns.isEmpty() ? this.defaultJoinColumnsSize() : this.specifiedJoinColumnsSize();
    }

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn newJoinColumn) {
        OrmJoinColumn oldJoinColumn = this.defaultJoinColumn;
        this.defaultJoinColumn = newJoinColumn;
        this.firePropertyChanged("defaultJoinColumn", oldJoinColumn, newJoinColumn);
    }

    protected ListIterator<OrmJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        OrmJoinColumn oldDefaultJoinColumn = this.getDefaultJoinColumn();
        if (oldDefaultJoinColumn != null) {
            this.defaultJoinColumn = null;
        }
        XmlJoinColumnImpl xmlJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumnImpl();
        OrmJoinColumn joinColumn = this.buildJoinColumn(xmlJoinColumn);
        this.specifiedJoinColumns.add(index, joinColumn);
        ((XmlSingleRelationshipMapping)this.getAttributeMapping()).getJoinColumns().add(index, (Object)xmlJoinColumn);
        this.fireItemAdded("specifiedJoinColumnsList", index, joinColumn);
        if (oldDefaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", oldDefaultJoinColumn, null);
        }
        return joinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (!this.containsSpecifiedJoinColumns()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
        ((XmlSingleRelationshipMapping)this.getAttributeMapping()).getJoinColumns().remove(index);
        this.fireItemRemoved("specifiedJoinColumnsList", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumnsList");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        ((XmlSingleRelationshipMapping)this.getAttributeMapping()).getJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public Boolean getOptional() {
        return this.getSpecifiedOptional() == null ? this.getDefaultOptional() : this.getSpecifiedOptional();
    }

    @Override
    public Boolean getDefaultOptional() {
        return Nullable.DEFAULT_OPTIONAL;
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean newSpecifiedOptional) {
        Boolean oldSpecifiedOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        ((XmlSingleRelationshipMapping)this.getAttributeMapping()).setOptional(newSpecifiedOptional);
        this.firePropertyChanged("specifiedOptionalProperty", oldSpecifiedOptional, newSpecifiedOptional);
    }

    protected void setSpecifiedOptional_(Boolean newSpecifiedOptional) {
        Boolean oldSpecifiedOptional = this.specifiedOptional;
        this.specifiedOptional = newSpecifiedOptional;
        this.firePropertyChanged("specifiedOptionalProperty", oldSpecifiedOptional, newSpecifiedOptional);
    }

    @Override
    public void initialize(T singleRelationshipMapping) {
        super.initialize(singleRelationshipMapping);
        this.specifiedOptional = singleRelationshipMapping.getOptional();
        this.initializeSpecifiedJoinColumns(singleRelationshipMapping);
        this.initializeDefaultJoinColumn();
    }

    protected void initializeSpecifiedJoinColumns(T singleRelationshipMapping) {
        if (singleRelationshipMapping == null) {
            return;
        }
        for (XmlJoinColumn joinColumn : singleRelationshipMapping.getJoinColumns()) {
            this.specifiedJoinColumns.add(this.buildJoinColumn(joinColumn));
        }
    }

    protected boolean shouldBuildDefaultJoinColumn() {
        return !this.containsSpecifiedJoinColumns() && this.isRelationshipOwner();
    }

    protected void initializeDefaultJoinColumn() {
        if (!this.shouldBuildDefaultJoinColumn()) {
            return;
        }
        this.defaultJoinColumn = this.buildJoinColumn(null);
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn joinColumn) {
        OrmJoinColumn ormJoinColumn = this.getJpaFactory().buildOrmJoinColumn(this, new JoinColumnOwner());
        ormJoinColumn.initialize(joinColumn);
        return ormJoinColumn;
    }

    @Override
    public void update(T singleRelationshipMapping) {
        super.update(singleRelationshipMapping);
        this.setSpecifiedOptional_(singleRelationshipMapping.getOptional());
        this.updateSpecifiedJoinColumns(singleRelationshipMapping);
        this.updateDefaultJoinColumn();
    }

    protected void updateSpecifiedJoinColumns(T singleRelationshipMapping) {
        ListIterator<OrmJoinColumn> joinColumns = this.specifiedJoinColumns();
        ListIterator resourceJoinColumns = EmptyListIterator.instance();
        if (singleRelationshipMapping != null) {
            resourceJoinColumns = singleRelationshipMapping.getJoinColumns().listIterator();
        }
        while (joinColumns.hasNext()) {
            OrmJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update((XmlJoinColumn)resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.specifiedJoinColumnsSize(), this.buildJoinColumn((XmlJoinColumn)resourceJoinColumns.next()));
        }
    }

    protected void updateDefaultJoinColumn() {
        if (!this.shouldBuildDefaultJoinColumn()) {
            this.setDefaultJoinColumn(null);
            return;
        }
        if (this.getDefaultJoinColumn() == null) {
            this.setDefaultJoinColumn(this.buildJoinColumn(null));
        } else {
            this.defaultJoinColumn.update(null);
        }
    }

    @Override
    protected String defaultTargetEntity(JavaResourcePersistentAttribute persistentAttributeResource) {
        if (persistentAttributeResource.typeIsContainer()) {
            return null;
        }
        return persistentAttributeResource.getQualifiedReferenceEntityTypeName();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.entityOwned() && this.isRelationshipOwner()) {
            this.addJoinColumnMessages(messages);
        }
    }

    protected void addJoinColumnMessages(List<IMessage> messages) {
        boolean doContinue = this.connectionProfileIsActive();
        for (OrmJoinColumn joinColumn : CollectionTools.iterable(this.joinColumns())) {
            String table = joinColumn.getTable();
            if (doContinue && this.getTypeMapping().tableNameIsInvalid(table)) {
                if (this.getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{this.getName(), table, joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{table, joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange()));
                }
                doContinue = false;
            }
            if (doContinue && !joinColumn.isResolved()) {
                if (this.getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange()));
                }
            }
            if (!doContinue || joinColumn.isReferencedColumnResolved()) continue;
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange()));
                continue;
            }
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange()));
        }
    }

    public class JoinColumnOwner
    implements OrmJoinColumn.Owner {
        public String getDefaultTableName() {
            return AbstractOrmSingleRelationshipMapping.this.getTypeMapping().getTableName();
        }

        public Entity getTargetEntity() {
            return AbstractOrmSingleRelationshipMapping.this.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return AbstractOrmSingleRelationshipMapping.this.getName();
        }

        public RelationshipMapping getRelationshipMapping() {
            return AbstractOrmSingleRelationshipMapping.this;
        }

        public boolean tableNameIsInvalid(String tableName) {
            return AbstractOrmSingleRelationshipMapping.this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        public boolean tableIsAllowed() {
            return true;
        }

        public TypeMapping getTypeMapping() {
            return AbstractOrmSingleRelationshipMapping.this.getTypeMapping();
        }

        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getDbReferencedColumnTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return AbstractOrmSingleRelationshipMapping.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return AbstractOrmSingleRelationshipMapping.this.joinColumnsSize();
        }

        public TextRange getValidationTextRange() {
            return AbstractOrmSingleRelationshipMapping.this.getValidationTextRange();
        }
    }
}

