/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmQuery;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.orm.PersistenceUnitDefaults;
import org.eclipse.jpt.core.context.orm.PersistenceUnitMetadata;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEmbeddable;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlMappedSuperclass;
import org.eclipse.jpt.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGeneratorImpl;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGeneratorImpl;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEntityMappings
extends AbstractOrmJpaContextNode
implements EntityMappings {
    protected XmlEntityMappings xmlEntityMappings;
    protected String version;
    protected String description;
    protected String package_;
    protected String defaultSchema;
    protected String specifiedSchema;
    protected String defaultCatalog;
    protected String specifiedCatalog;
    protected AccessType defaultAccess;
    protected AccessType specifiedAccess;
    protected final PersistenceUnitMetadata persistenceUnitMetadata;
    protected final List<OrmPersistentType> persistentTypes;
    protected final List<OrmSequenceGenerator> sequenceGenerators;
    protected final List<OrmTableGenerator> tableGenerators;
    protected final List<OrmNamedQuery> namedQueries;
    protected final List<OrmNamedNativeQuery> namedNativeQueries;

    public GenericEntityMappings(OrmXml parent, XmlEntityMappings xmlEntityMappings) {
        super(parent);
        this.persistenceUnitMetadata = this.getJpaFactory().buildPersistenceUnitMetadata(this, xmlEntityMappings);
        this.persistentTypes = new ArrayList<OrmPersistentType>();
        this.sequenceGenerators = new ArrayList<OrmSequenceGenerator>();
        this.tableGenerators = new ArrayList<OrmTableGenerator>();
        this.namedQueries = new ArrayList<OrmNamedQuery>();
        this.namedNativeQueries = new ArrayList<OrmNamedNativeQuery>();
        this.initialize(xmlEntityMappings);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.orm.entityMappings";
    }

    @Override
    public EntityMappings getEntityMappings() {
        return this;
    }

    @Override
    public OrmPersistentType getPersistentType(String fullyQualifiedTypeName) {
        for (OrmPersistentType ormPersistentType : CollectionTools.iterable(this.ormPersistentTypes())) {
            if (!ormPersistentType.isFor(fullyQualifiedTypeName)) continue;
            return ormPersistentType;
        }
        return null;
    }

    @Override
    public PersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.persistenceUnitMetadata;
    }

    @Override
    public String getPackage() {
        return this.package_;
    }

    @Override
    public void setPackage(String newPackage) {
        String oldPackage = this.package_;
        this.package_ = newPackage;
        this.xmlEntityMappings.setPackage(newPackage);
        this.firePropertyChanged("packageProperty", oldPackage, newPackage);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        this.xmlEntityMappings.setDescription(newDescription);
        this.firePropertyChanged("descriptionProperty", oldDescription, newDescription);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String newDefaultSchema) {
        String oldDefaultSchema = this.defaultSchema;
        this.defaultSchema = newDefaultSchema;
        this.firePropertyChanged("defaultSchemaProperty", oldDefaultSchema, newDefaultSchema);
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String newSpecifiedSchema) {
        String oldSpecifiedSchema = this.specifiedSchema;
        this.specifiedSchema = newSpecifiedSchema;
        this.xmlEntityMappings.setSchema(newSpecifiedSchema);
        this.firePropertyChanged("specifiedSchemaProperty", oldSpecifiedSchema, newSpecifiedSchema);
    }

    @Override
    public String getSchema() {
        return this.getSpecifiedSchema() == null ? this.getDefaultSchema() : this.getSpecifiedSchema();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String newDefaultCatalog) {
        String oldDefaultCatalog = this.defaultCatalog;
        this.defaultCatalog = newDefaultCatalog;
        this.firePropertyChanged("defaultCatalogProperty", oldDefaultCatalog, newDefaultCatalog);
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String newSpecifiedCatalog) {
        String oldSpecifiedCatalog = this.specifiedCatalog;
        this.specifiedCatalog = newSpecifiedCatalog;
        this.xmlEntityMappings.setCatalog(newSpecifiedCatalog);
        this.firePropertyChanged("specifiedCatalogProperty", oldSpecifiedCatalog, newSpecifiedCatalog);
    }

    @Override
    public String getCatalog() {
        return this.getSpecifiedCatalog() == null ? this.getDefaultCatalog() : this.getSpecifiedCatalog();
    }

    @Override
    public AccessType getAccess() {
        return this.getSpecifiedAccess() == null ? this.getDefaultAccess() : this.getSpecifiedAccess();
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType newDefaultAccess) {
        AccessType oldDefaultAccess = this.defaultAccess;
        this.defaultAccess = newDefaultAccess;
        this.firePropertyChanged("defaultAccessProperty", (Object)oldDefaultAccess, (Object)newDefaultAccess);
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType newSpecifiedAccess) {
        AccessType oldSpecifiedAccess = this.specifiedAccess;
        this.specifiedAccess = newSpecifiedAccess;
        this.xmlEntityMappings.setAccess(AccessType.toXmlResourceModel(newSpecifiedAccess));
        this.firePropertyChanged("specifiedAccessProperty", (Object)oldSpecifiedAccess, (Object)newSpecifiedAccess);
    }

    @Override
    public ListIterator<OrmPersistentType> ormPersistentTypes() {
        return new CloneListIterator(this.persistentTypes);
    }

    @Override
    public int ormPersistentTypesSize() {
        return this.persistentTypes.size();
    }

    @Override
    public OrmPersistentType addOrmPersistentType(String mappingKey, String className) {
        OrmPersistentType persistentType = this.getJpaFactory().buildOrmPersistentType(this, mappingKey);
        int index = this.insertionIndex(persistentType);
        this.persistentTypes.add(index, persistentType);
        if (className.startsWith(String.valueOf(this.getPackage()) + ".")) {
            className = className.substring(this.getPackage().length() + 1);
        }
        AbstractXmlTypeMapping typeMapping = persistentType.getMapping().addToResourceModel(this.xmlEntityMappings);
        typeMapping.setClassName(className);
        this.fireItemAdded("persistentTypes", index, persistentType);
        return persistentType;
    }

    protected void addOrmPersistentType(OrmPersistentType ormPersistentType) {
        this.addItemToList(ormPersistentType, this.persistentTypes, "persistentTypes");
    }

    protected int insertionIndex(OrmPersistentType ormPersistentType) {
        return CollectionTools.insertionIndexOf(this.persistentTypes, (Object)ormPersistentType, this.buildMappingComparator());
    }

    private Comparator<OrmPersistentType> buildMappingComparator() {
        return new Comparator<OrmPersistentType>(){

            @Override
            public int compare(OrmPersistentType o1, OrmPersistentType o2) {
                int o2Sequence;
                int o1Sequence = o1.getMapping().getXmlSequence();
                if (o1Sequence < (o2Sequence = o2.getMapping().getXmlSequence())) {
                    return -1;
                }
                if (o1Sequence == o2Sequence) {
                    return 0;
                }
                return 1;
            }
        };
    }

    @Override
    public void removeOrmPersistentType(int index) {
        OrmPersistentType ormPersistentType = this.persistentTypes.get(index);
        this.persistentTypes.remove(index);
        ormPersistentType.getMapping().removeFromResourceModel(this.xmlEntityMappings);
        this.fireItemRemoved("persistentTypes", index, ormPersistentType);
    }

    @Override
    public void removeOrmPersistentType(OrmPersistentType ormPersistentType) {
        this.removeOrmPersistentType(this.persistentTypes.indexOf(ormPersistentType));
    }

    protected void removeOrmPersistentType_(OrmPersistentType ormPersistentType) {
        this.removeItemFromList(ormPersistentType, this.persistentTypes, "persistentTypes");
    }

    @Override
    public void changeMapping(OrmPersistentType ormPersistentType, OrmTypeMapping oldMapping, OrmTypeMapping newMapping) {
        int sourceIndex = this.persistentTypes.indexOf(ormPersistentType);
        this.persistentTypes.remove(sourceIndex);
        oldMapping.removeFromResourceModel(this.xmlEntityMappings);
        int targetIndex = this.insertionIndex(ormPersistentType);
        this.persistentTypes.add(targetIndex, ormPersistentType);
        newMapping.addToResourceModel(this.xmlEntityMappings);
        newMapping.initializeFrom(oldMapping);
        this.fireItemMoved("persistentTypes", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmSequenceGenerator> sequenceGenerators() {
        return new CloneListIterator(this.sequenceGenerators);
    }

    @Override
    public int sequenceGeneratorsSize() {
        return this.sequenceGenerators.size();
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator(int index) {
        OrmSequenceGenerator ormSequenceGenerator = this.getJpaFactory().buildOrmSequenceGenerator(this);
        this.sequenceGenerators.add(index, ormSequenceGenerator);
        XmlSequenceGeneratorImpl sequenceGenerator = OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl();
        ormSequenceGenerator.initialize(sequenceGenerator);
        this.xmlEntityMappings.getSequenceGenerators().add(index, (Object)sequenceGenerator);
        this.fireItemAdded("sequenceGeneratorsList", index, ormSequenceGenerator);
        return ormSequenceGenerator;
    }

    protected void addSequenceGenerator(int index, OrmSequenceGenerator sequenceGenerator) {
        this.addItemToList(index, sequenceGenerator, this.sequenceGenerators, "sequenceGeneratorsList");
    }

    @Override
    public void removeSequenceGenerator(OrmSequenceGenerator sequenceGenerator) {
        this.removeSequenceGenerator(this.sequenceGenerators.indexOf(sequenceGenerator));
    }

    @Override
    public void removeSequenceGenerator(int index) {
        OrmSequenceGenerator removedSequenceGenerator = this.sequenceGenerators.remove(index);
        this.fireItemRemoved("sequenceGeneratorsList", index, removedSequenceGenerator);
        this.xmlEntityMappings.getSequenceGenerators().remove(index);
    }

    protected void removeSequenceGenerator_(OrmSequenceGenerator sequenceGenerator) {
        this.removeItemFromList(sequenceGenerator, this.sequenceGenerators, "sequenceGeneratorsList");
    }

    @Override
    public void moveSequenceGenerator(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.sequenceGenerators, (int)targetIndex, (int)sourceIndex);
        this.xmlEntityMappings.getSequenceGenerators().move(targetIndex, sourceIndex);
        this.fireItemMoved("sequenceGeneratorsList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmTableGenerator> tableGenerators() {
        return new CloneListIterator(this.tableGenerators);
    }

    @Override
    public int tableGeneratorsSize() {
        return this.tableGenerators.size();
    }

    @Override
    public OrmTableGenerator addTableGenerator(int index) {
        OrmTableGenerator xmlTableGenerator = this.getJpaFactory().buildOrmTableGenerator(this);
        this.tableGenerators.add(index, xmlTableGenerator);
        XmlTableGeneratorImpl tableGenerator = OrmFactory.eINSTANCE.createXmlTableGeneratorImpl();
        xmlTableGenerator.initialize(tableGenerator);
        this.xmlEntityMappings.getTableGenerators().add(index, (Object)tableGenerator);
        this.fireItemAdded("tableGeneratorsList", index, xmlTableGenerator);
        return xmlTableGenerator;
    }

    protected void addTableGenerator(int index, OrmTableGenerator tableGenerator) {
        this.addItemToList(index, tableGenerator, this.tableGenerators, "tableGeneratorsList");
    }

    @Override
    public void removeTableGenerator(OrmTableGenerator tableGenerator) {
        this.removeTableGenerator(this.tableGenerators.indexOf(tableGenerator));
    }

    @Override
    public void removeTableGenerator(int index) {
        OrmTableGenerator removedTableGenerator = this.tableGenerators.remove(index);
        this.xmlEntityMappings.getTableGenerators().remove(index);
        this.fireItemRemoved("tableGeneratorsList", index, removedTableGenerator);
    }

    protected void removeTableGenerator_(OrmTableGenerator tableGenerator) {
        this.removeItemFromList(tableGenerator, this.tableGenerators, "tableGeneratorsList");
    }

    @Override
    public void moveTableGenerator(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.tableGenerators, (int)targetIndex, (int)sourceIndex);
        this.xmlEntityMappings.getTableGenerators().move(targetIndex, sourceIndex);
        this.fireItemMoved("tableGeneratorsList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmNamedQuery> namedQueries() {
        return new CloneListIterator(this.namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.namedQueries.size();
    }

    @Override
    public OrmNamedQuery addNamedQuery(int index) {
        OrmNamedQuery namedQuery = this.getJpaFactory().buildOrmNamedQuery(this);
        this.namedQueries.add(index, namedQuery);
        this.xmlEntityMappings.getNamedQueries().add(index, (Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        this.fireItemAdded("namedQueriesList", index, namedQuery);
        return namedQuery;
    }

    protected void addNamedQuery(int index, OrmNamedQuery namedQuery) {
        this.addItemToList(index, namedQuery, this.namedQueries, "namedQueriesList");
    }

    @Override
    public void removeNamedQuery(NamedQuery namedQuery) {
        this.removeNamedQuery(this.namedQueries.indexOf(namedQuery));
    }

    @Override
    public void removeNamedQuery(int index) {
        OrmNamedQuery namedQuery = this.namedQueries.remove(index);
        this.xmlEntityMappings.getNamedQueries().remove(index);
        this.fireItemRemoved("namedQueriesList", index, namedQuery);
    }

    protected void removeNamedQuery_(OrmNamedQuery namedQuery) {
        this.removeItemFromList(namedQuery, this.namedQueries, "namedQueriesList");
    }

    @Override
    public void moveNamedQuery(int targetIndex, int sourceIndex) {
        this.xmlEntityMappings.getNamedQueries().move(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.namedQueries, "namedQueriesList");
    }

    @Override
    public ListIterator<OrmNamedNativeQuery> namedNativeQueries() {
        return new CloneListIterator(this.namedNativeQueries);
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.namedNativeQueries.size();
    }

    @Override
    public OrmNamedNativeQuery addNamedNativeQuery(int index) {
        OrmNamedNativeQuery namedNativeQuery = this.getJpaFactory().buildOrmNamedNativeQuery(this);
        this.namedNativeQueries.add(index, namedNativeQuery);
        this.xmlEntityMappings.getNamedNativeQueries().add(index, (Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        this.fireItemAdded("namedQueriesList", index, namedNativeQuery);
        return namedNativeQuery;
    }

    protected void addNamedNativeQuery(int index, OrmNamedNativeQuery namedNativeQuery) {
        this.addItemToList(index, namedNativeQuery, this.namedNativeQueries, "namedNativeQueriesList");
    }

    @Override
    public void removeNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.removeNamedNativeQuery(this.namedNativeQueries.indexOf(namedNativeQuery));
    }

    @Override
    public void removeNamedNativeQuery(int index) {
        OrmNamedNativeQuery namedNativeQuery = this.namedNativeQueries.remove(index);
        this.xmlEntityMappings.getNamedNativeQueries().remove(index);
        this.fireItemRemoved("namedNativeQueriesList", index, namedNativeQuery);
    }

    protected void removeNamedNativeQuery_(OrmNamedNativeQuery namedNativeQuery) {
        this.removeItemFromList(namedNativeQuery, this.namedNativeQueries, "namedNativeQueriesList");
    }

    @Override
    public void moveNamedNativeQuery(int targetIndex, int sourceIndex) {
        this.xmlEntityMappings.getNamedNativeQueries().move(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.namedNativeQueries, "namedNativeQueriesList");
    }

    @Override
    public boolean containsPersistentType(String className) {
        for (OrmPersistentType persistentType : CollectionTools.iterable(this.ormPersistentTypes())) {
            if (!persistentType.getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PersistenceUnitDefaults getPersistenceUnitDefaults() {
        return this.getPersistenceUnitMetadata().getPersistenceUnitDefaults();
    }

    protected void initialize(XmlEntityMappings entityMappings) {
        this.xmlEntityMappings = entityMappings;
        this.version = entityMappings.getVersion();
        this.description = entityMappings.getDescription();
        this.package_ = entityMappings.getPackage();
        this.specifiedSchema = entityMappings.getSchema();
        this.specifiedCatalog = entityMappings.getCatalog();
        this.specifiedAccess = this.specifiedAccess(entityMappings);
        this.defaultAccess = this.getPersistenceUnit().getDefaultAccess();
        this.defaultCatalog = this.getPersistenceUnit().getDefaultCatalog();
        this.defaultSchema = this.getPersistenceUnit().getDefaultSchema();
        this.initializePersistentTypes(entityMappings);
        this.initializeTableGenerators(entityMappings);
        this.initializeSequenceGenerators(entityMappings);
        this.initializeNamedQueries(entityMappings);
        this.initializeNamedNativeQueries(entityMappings);
        this.updatePersistenceUnitGeneratorsAndQueries();
    }

    protected void initializePersistentTypes(XmlEntityMappings entityMappings) {
        this.initializeMappedSuperclasses(entityMappings);
        this.initializeEntities(entityMappings);
        this.initializeEmbeddables(entityMappings);
    }

    protected void initializeMappedSuperclasses(XmlEntityMappings entityMappings) {
        for (XmlMappedSuperclass mappedSuperclass : entityMappings.getMappedSuperclasses()) {
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "mappedSuperclass");
            ormPersistentType.initialize(mappedSuperclass);
            this.persistentTypes.add(ormPersistentType);
        }
    }

    protected void initializeEntities(XmlEntityMappings entityMappings) {
        for (XmlEntity entity : entityMappings.getEntities()) {
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "entity");
            ormPersistentType.initialize(entity);
            this.persistentTypes.add(ormPersistentType);
        }
    }

    protected void initializeEmbeddables(XmlEntityMappings entityMappings) {
        for (XmlEmbeddable embeddable : entityMappings.getEmbeddables()) {
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "embeddable");
            ormPersistentType.initialize(embeddable);
            this.persistentTypes.add(ormPersistentType);
        }
    }

    protected void initializeTableGenerators(XmlEntityMappings entityMappings) {
        for (XmlTableGenerator tableGenerator : entityMappings.getTableGenerators()) {
            this.tableGenerators.add(this.buildTableGenerator(tableGenerator));
        }
    }

    protected void initializeSequenceGenerators(XmlEntityMappings entityMappings) {
        for (XmlSequenceGenerator sequenceGenerator : entityMappings.getSequenceGenerators()) {
            this.sequenceGenerators.add(this.buildSequenceGenerator(sequenceGenerator));
        }
    }

    protected void initializeNamedQueries(XmlEntityMappings entityMappings) {
        for (XmlNamedQuery namedQuery : entityMappings.getNamedQueries()) {
            this.namedQueries.add(this.buildNamedQuery(namedQuery));
        }
    }

    protected void initializeNamedNativeQueries(XmlEntityMappings entityMappings) {
        for (XmlNamedNativeQuery namedNativeQuery : entityMappings.getNamedNativeQueries()) {
            this.namedNativeQueries.add(this.buildNamedNativeQuery(namedNativeQuery));
        }
    }

    @Override
    public void update(XmlEntityMappings entityMappings) {
        this.xmlEntityMappings = entityMappings;
        this.setDescription(entityMappings.getDescription());
        this.setPackage(entityMappings.getPackage());
        this.setSpecifiedSchema(entityMappings.getSchema());
        this.setSpecifiedCatalog(entityMappings.getCatalog());
        this.setSpecifiedAccess(this.specifiedAccess(entityMappings));
        this.persistenceUnitMetadata.update(entityMappings);
        this.setDefaultAccess(this.getPersistenceUnit().getDefaultAccess());
        this.setDefaultCatalog(this.getPersistenceUnit().getDefaultCatalog());
        this.setDefaultSchema(this.getPersistenceUnit().getDefaultSchema());
        this.updatePersistentTypes(entityMappings);
        this.updateTableGenerators(entityMappings);
        this.updateSequenceGenerators(entityMappings);
        this.updateNamedQueries(entityMappings);
        this.updateNamedNativeQueries(entityMappings);
        this.updatePersistenceUnitGeneratorsAndQueries();
    }

    protected AccessType specifiedAccess(XmlEntityMappings entityMappings) {
        return AccessType.fromXmlResourceModel(entityMappings.getAccess());
    }

    protected void updatePersistentTypes(XmlEntityMappings entityMappings) {
        ListIterator<OrmPersistentType> ormPersistentTypes = this.ormPersistentTypes();
        this.updateMappedSuperclasses(entityMappings, ormPersistentTypes);
        this.updateEntities(entityMappings, ormPersistentTypes);
        this.updateEmbeddables(entityMappings, ormPersistentTypes);
        while (ormPersistentTypes.hasNext()) {
            this.removeOrmPersistentType(ormPersistentTypes.next());
        }
    }

    protected void updateMappedSuperclasses(XmlEntityMappings entityMappings, ListIterator<OrmPersistentType> ormPersistentTypes) {
        for (XmlMappedSuperclass mappedSuperclass : entityMappings.getMappedSuperclasses()) {
            if (ormPersistentTypes.hasNext()) {
                ormPersistentTypes.next().update(mappedSuperclass);
                continue;
            }
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "mappedSuperclass");
            ormPersistentType.initialize(mappedSuperclass);
            this.addOrmPersistentType(ormPersistentType);
        }
    }

    protected void updateEntities(XmlEntityMappings entityMappings, ListIterator<OrmPersistentType> ormPersistentTypes) {
        for (XmlEntity entity : entityMappings.getEntities()) {
            if (ormPersistentTypes.hasNext()) {
                ormPersistentTypes.next().update(entity);
                continue;
            }
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "entity");
            ormPersistentType.initialize(entity);
            this.addOrmPersistentType(ormPersistentType);
        }
    }

    protected void updateEmbeddables(XmlEntityMappings entityMappings, ListIterator<OrmPersistentType> ormPersistentTypes) {
        for (XmlEmbeddable embeddable : entityMappings.getEmbeddables()) {
            if (ormPersistentTypes.hasNext()) {
                ormPersistentTypes.next().update(embeddable);
                continue;
            }
            OrmPersistentType ormPersistentType = this.getJpaFactory().buildOrmPersistentType(this, "embeddable");
            ormPersistentType.initialize(embeddable);
            this.addOrmPersistentType(ormPersistentType);
        }
    }

    protected void updateTableGenerators(XmlEntityMappings entityMappings) {
        ListIterator<OrmTableGenerator> tableGenerators = this.tableGenerators();
        ListIterator resourceTableGenerators = entityMappings.getTableGenerators().listIterator();
        while (tableGenerators.hasNext()) {
            OrmTableGenerator tableGenerator = tableGenerators.next();
            if (resourceTableGenerators.hasNext()) {
                tableGenerator.update((XmlTableGenerator)resourceTableGenerators.next());
                continue;
            }
            this.removeTableGenerator_(tableGenerator);
        }
        while (resourceTableGenerators.hasNext()) {
            this.addTableGenerator(this.tableGeneratorsSize(), this.buildTableGenerator((XmlTableGenerator)resourceTableGenerators.next()));
        }
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator tableGeneratorResource) {
        OrmTableGenerator tableGenerator = this.getJpaFactory().buildOrmTableGenerator(this);
        tableGenerator.initialize(tableGeneratorResource);
        return tableGenerator;
    }

    protected void updateSequenceGenerators(XmlEntityMappings entityMappings) {
        ListIterator<OrmSequenceGenerator> sequenceGenerators = this.sequenceGenerators();
        ListIterator resourceSequenceGenerators = entityMappings.getSequenceGenerators().listIterator();
        while (sequenceGenerators.hasNext()) {
            OrmSequenceGenerator sequenceGenerator = sequenceGenerators.next();
            if (resourceSequenceGenerators.hasNext()) {
                sequenceGenerator.update((XmlSequenceGenerator)resourceSequenceGenerators.next());
                continue;
            }
            this.removeSequenceGenerator_(sequenceGenerator);
        }
        while (resourceSequenceGenerators.hasNext()) {
            this.addSequenceGenerator(this.sequenceGeneratorsSize(), this.buildSequenceGenerator((XmlSequenceGenerator)resourceSequenceGenerators.next()));
        }
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator sequenceGeneratorResource) {
        OrmSequenceGenerator sequenceGenerator = this.getJpaFactory().buildOrmSequenceGenerator(this);
        sequenceGenerator.initialize(sequenceGeneratorResource);
        return sequenceGenerator;
    }

    protected void updateNamedQueries(XmlEntityMappings entityMappings) {
        ListIterator<OrmNamedQuery> namedQueries = this.namedQueries();
        ListIterator resourceNamedQueries = entityMappings.getNamedQueries().listIterator();
        while (namedQueries.hasNext()) {
            OrmNamedQuery namedQuery = namedQueries.next();
            if (resourceNamedQueries.hasNext()) {
                namedQuery.update((XmlNamedQuery)resourceNamedQueries.next());
                continue;
            }
            this.removeNamedQuery_(namedQuery);
        }
        while (resourceNamedQueries.hasNext()) {
            this.addNamedQuery(this.namedQueriesSize(), this.buildNamedQuery((XmlNamedQuery)resourceNamedQueries.next()));
        }
    }

    protected OrmNamedQuery buildNamedQuery(XmlNamedQuery namedQuery) {
        OrmNamedQuery ormNamedQuery = this.getJpaFactory().buildOrmNamedQuery(this);
        ormNamedQuery.initialize(namedQuery);
        return ormNamedQuery;
    }

    protected void updateNamedNativeQueries(XmlEntityMappings entityMappings) {
        ListIterator<OrmNamedNativeQuery> namedNativeQueries = this.namedNativeQueries();
        ListIterator resourceNamedNativeQueries = entityMappings.getNamedNativeQueries().listIterator();
        while (namedNativeQueries.hasNext()) {
            OrmNamedNativeQuery namedQuery = namedNativeQueries.next();
            if (resourceNamedNativeQueries.hasNext()) {
                namedQuery.update((XmlNamedNativeQuery)resourceNamedNativeQueries.next());
                continue;
            }
            this.removeNamedNativeQuery_(namedQuery);
        }
        while (resourceNamedNativeQueries.hasNext()) {
            this.addNamedNativeQuery(this.namedNativeQueriesSize(), this.buildNamedNativeQuery((XmlNamedNativeQuery)resourceNamedNativeQueries.next()));
        }
    }

    protected OrmNamedNativeQuery buildNamedNativeQuery(XmlNamedNativeQuery namedQuery) {
        OrmNamedNativeQuery ormNamedNativeQuery = this.getJpaFactory().buildOrmNamedNativeQuery(this);
        ormNamedNativeQuery.initialize(namedQuery);
        return ormNamedNativeQuery;
    }

    protected void updatePersistenceUnitGeneratorsAndQueries() {
        for (Generator generator : CollectionTools.iterable(this.tableGenerators())) {
            this.getPersistenceUnit().addGenerator(generator);
        }
        for (Generator generator : CollectionTools.iterable(this.sequenceGenerators())) {
            this.getPersistenceUnit().addGenerator(generator);
        }
        for (Query query : CollectionTools.iterable(this.namedQueries())) {
            this.getPersistenceUnit().addQuery(query);
        }
        for (Query query : CollectionTools.iterable(this.namedNativeQueries())) {
            this.getPersistenceUnit().addQuery(query);
        }
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentType persistentType : CollectionTools.iterable(this.ormPersistentTypes())) {
            if (!persistentType.contains(textOffset)) continue;
            return persistentType.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        if (this.xmlEntityMappings == null) {
            return false;
        }
        return this.xmlEntityMappings.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlEntityMappings.getSelectionTextRange();
    }

    @Override
    public TextRange getValidationTextRange() {
        return null;
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addGeneratorMessages(messages);
        this.addQueryMessages(messages);
        for (OrmPersistentType ormPersistentType : CollectionTools.iterable(this.ormPersistentTypes())) {
            ormPersistentType.addToMessages(messages);
        }
    }

    protected void addGeneratorMessages(List<IMessage> messages) {
        List masterList = CollectionTools.list(this.getPersistenceUnit().allGenerators());
        CompositeIterator stream = new CompositeIterator(new Iterator[]{this.tableGenerators(), this.sequenceGenerators()});
        while (stream.hasNext()) {
            OrmGenerator current = (OrmGenerator)stream.next();
            masterList.remove(current);
            for (Generator each : masterList) {
                if (each.overrides(current) || each.getName() == null || !each.getName().equals(current.getName())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{current.getName()}, current, current.getNameTextRange()));
            }
            masterList.add(current);
        }
    }

    protected void addQueryMessages(List<IMessage> messages) {
        List masterList = CollectionTools.list(this.getPersistenceUnit().allQueries());
        CompositeIterator stream = new CompositeIterator(new Iterator[]{this.namedQueries(), this.namedNativeQueries()});
        while (stream.hasNext()) {
            OrmQuery current = (OrmQuery)stream.next();
            masterList.remove(current);
            for (Query each : masterList) {
                if (each.overrides(current) || each.getName() == null || !each.getName().equals(current.getName())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", new String[]{current.getName()}, current, current.getNameTextRange()));
            }
            masterList.add(current);
        }
    }
}

