/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.Generator;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.NamedNativeQuery;
import org.eclipse.jpt.core.context.NamedQuery;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.Query;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.Table;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmBaseJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmDiscriminatorColumn;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmNamedColumn;
import org.eclipse.jpt.core.context.orm.OrmNamedNativeQuery;
import org.eclipse.jpt.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmQuery;
import org.eclipse.jpt.core.context.orm.OrmSecondaryTable;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTable;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.internal.context.java.GenericJavaEntity;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.VirtualXmlSecondaryTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.Inheritance;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlIdClass;
import org.eclipse.jpt.core.resource.orm.XmlNamedNativeQuery;
import org.eclipse.jpt.core.resource.orm.XmlNamedQuery;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTable;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTableImpl;
import org.eclipse.jpt.core.resource.orm.XmlSequenceGenerator;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmEntity
extends AbstractOrmTypeMapping<XmlEntity>
implements OrmEntity {
    protected String specifiedName;
    protected String defaultName;
    protected String idClass;
    protected final OrmTable table = this.getJpaFactory().buildOrmTable(this);
    protected final List<OrmSecondaryTable> specifiedSecondaryTables = new ArrayList<OrmSecondaryTable>();
    protected final List<OrmSecondaryTable> virtualSecondaryTables = new ArrayList<OrmSecondaryTable>();
    protected final List<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns;
    protected final List<OrmPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns;
    protected InheritanceType specifiedInheritanceStrategy;
    protected InheritanceType defaultInheritanceStrategy;
    protected String defaultDiscriminatorValue;
    protected String specifiedDiscriminatorValue;
    protected boolean discriminatorValueAllowed;
    protected final OrmDiscriminatorColumn discriminatorColumn = this.buildDiscriminatorColumn();
    protected OrmSequenceGenerator sequenceGenerator;
    protected OrmTableGenerator tableGenerator;
    protected final List<OrmAttributeOverride> specifiedAttributeOverrides;
    protected final List<OrmAttributeOverride> defaultAttributeOverrides;
    protected final List<OrmAssociationOverride> specifiedAssociationOverrides;
    protected final List<OrmAssociationOverride> defaultAssociationOverrides;
    protected final List<OrmNamedQuery> namedQueries;
    protected final List<OrmNamedNativeQuery> namedNativeQueries;

    public GenericOrmEntity(OrmPersistentType parent) {
        super(parent);
        this.specifiedPrimaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();
        this.defaultPrimaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();
        this.specifiedAttributeOverrides = new ArrayList<OrmAttributeOverride>();
        this.defaultAttributeOverrides = new ArrayList<OrmAttributeOverride>();
        this.specifiedAssociationOverrides = new ArrayList<OrmAssociationOverride>();
        this.defaultAssociationOverrides = new ArrayList<OrmAssociationOverride>();
        this.namedQueries = new ArrayList<OrmNamedQuery>();
        this.namedNativeQueries = new ArrayList<OrmNamedNativeQuery>();
    }

    protected OrmDiscriminatorColumn buildDiscriminatorColumn() {
        return this.getJpaFactory().buildOrmDiscriminatorColumn(this, this.buildDiscriminatorColumnOwner());
    }

    protected OrmNamedColumn.Owner buildDiscriminatorColumnOwner() {
        return new OrmNamedColumn.Owner(){

            public org.eclipse.jpt.db.Table getDbTable(String tableName) {
                return GenericOrmEntity.this.getDbTable(tableName);
            }

            public TypeMapping getTypeMapping() {
                return GenericOrmEntity.this;
            }

            public String getDefaultColumnName() {
                return "DTYPE";
            }

            public TextRange getValidationTextRange() {
                return null;
            }
        };
    }

    @Override
    public String getKey() {
        return "entity";
    }

    @Override
    public String getTableName() {
        return this.getTable().getName();
    }

    @Override
    public org.eclipse.jpt.db.Table getPrimaryDbTable() {
        return this.getTable().getDbTable();
    }

    @Override
    public org.eclipse.jpt.db.Table getDbTable(String tableName) {
        Iterator<Table> stream = this.associatedTablesIncludingInherited();
        while (stream.hasNext()) {
            org.eclipse.jpt.db.Table dbTable = stream.next().getDbTable();
            if (dbTable == null || !dbTable.matchesShortJavaClassName(tableName)) continue;
            return dbTable;
        }
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return this.getTable().getDbSchema();
    }

    @Override
    public JavaEntity getJavaEntity() {
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        if (javaPersistentType != null && javaPersistentType.getMappingKey() == "entity") {
            return (JavaEntity)javaPersistentType.getMapping();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        ((XmlEntity)this.getTypeMappingResource()).setName(newSpecifiedName);
        this.firePropertyChanged("specifiedNameProperty", oldSpecifiedName, newSpecifiedName);
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        this.firePropertyChanged("defaultNameProperty", oldDefaultName, newDefaultName);
    }

    @Override
    public OrmTable getTable() {
        return this.table;
    }

    @Override
    public ListIterator<OrmSecondaryTable> secondaryTables() {
        if (this.specifiedSecondaryTablesSize() > 0) {
            return this.specifiedSecondaryTables();
        }
        return this.virtualSecondaryTables();
    }

    @Override
    public int secondaryTablesSize() {
        if (this.specifiedSecondaryTablesSize() > 0) {
            return this.specifiedSecondaryTablesSize();
        }
        return this.virtualSecondaryTablesSize();
    }

    @Override
    public ListIterator<OrmSecondaryTable> virtualSecondaryTables() {
        return new CloneListIterator(this.virtualSecondaryTables);
    }

    @Override
    public int virtualSecondaryTablesSize() {
        return this.virtualSecondaryTables.size();
    }

    protected void addVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.addItemToList(secondaryTable, this.virtualSecondaryTables, "virtualSecondaryTablesList");
    }

    protected void removeVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.virtualSecondaryTables, "virtualSecondaryTablesList");
    }

    @Override
    public ListIterator<OrmSecondaryTable> specifiedSecondaryTables() {
        return new CloneListIterator(this.specifiedSecondaryTables);
    }

    @Override
    public int specifiedSecondaryTablesSize() {
        return this.specifiedSecondaryTables.size();
    }

    @Override
    public OrmSecondaryTable addSpecifiedSecondaryTable(int index) {
        if (!this.secondaryTablesDefinedInXml()) {
            throw new IllegalStateException("Virtual secondary tables exist, must first call setSecondaryTablesDefinedInXml(true)");
        }
        XmlSecondaryTableImpl secondaryTableResource = OrmFactory.eINSTANCE.createXmlSecondaryTableImpl();
        OrmSecondaryTable secondaryTable = this.buildSecondaryTable(secondaryTableResource);
        this.specifiedSecondaryTables.add(index, secondaryTable);
        ((XmlEntity)this.getTypeMappingResource()).getSecondaryTables().add(index, (Object)secondaryTableResource);
        this.fireItemAdded("specifiedSecondaryTablesList", index, secondaryTable);
        return secondaryTable;
    }

    protected void addSpecifiedSecondaryTable(int index, OrmSecondaryTable secondaryTable) {
        this.addItemToList(index, secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTablesList");
    }

    @Override
    public void removeSpecifiedSecondaryTable(SecondaryTable secondaryTable) {
        this.removeSpecifiedSecondaryTable(this.specifiedSecondaryTables.indexOf(secondaryTable));
    }

    @Override
    public void removeSpecifiedSecondaryTable(int index) {
        OrmSecondaryTable removedSecondaryTable = this.specifiedSecondaryTables.remove(index);
        ((XmlEntity)this.getTypeMappingResource()).getSecondaryTables().remove(index);
        this.fireItemRemoved("specifiedSecondaryTablesList", index, removedSecondaryTable);
    }

    protected void removeSpecifiedSecondaryTable_(OrmSecondaryTable secondaryTable) {
        this.removeItemFromList(secondaryTable, this.specifiedSecondaryTables, "specifiedSecondaryTablesList");
    }

    @Override
    public void moveSpecifiedSecondaryTable(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedSecondaryTables, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getSecondaryTables().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedSecondaryTablesList", targetIndex, sourceIndex);
    }

    public boolean containsSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.secondaryTables());
    }

    public boolean containsSpecifiedSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.specifiedSecondaryTables());
    }

    public boolean containsVirtualSecondaryTable(String name) {
        return this.containsSecondaryTable(name, this.virtualSecondaryTables());
    }

    @Override
    public boolean containsVirtualSecondaryTable(OrmSecondaryTable secondaryTable) {
        return this.virtualSecondaryTables.contains(secondaryTable);
    }

    protected boolean containsSecondaryTable(String name, ListIterator<OrmSecondaryTable> secondaryTables) {
        for (OrmSecondaryTable secondaryTable : CollectionTools.iterable(secondaryTables)) {
            String secondaryTableName = secondaryTable.getName();
            if (secondaryTableName == null || !secondaryTableName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean secondaryTablesDefinedInXml() {
        return this.virtualSecondaryTablesSize() == 0;
    }

    @Override
    public void setSecondaryTablesDefinedInXml(boolean defineInXml) {
        if (defineInXml == this.secondaryTablesDefinedInXml()) {
            return;
        }
        if (defineInXml) {
            this.specifySecondaryTablesInXml();
        } else {
            this.removeSecondaryTablesFromXml();
        }
    }

    protected void specifySecondaryTablesInXml() {
        if (this.virtualSecondaryTablesSize() != 0) {
            List virtualSecondaryTables = CollectionTools.list(this.virtualSecondaryTables());
            List virtualSecondaryTable2 = CollectionTools.list(this.virtualSecondaryTables());
            for (OrmSecondaryTable virtualSecondaryTable : CollectionTools.iterable(this.virtualSecondaryTables())) {
                this.virtualSecondaryTables.remove(virtualSecondaryTable);
            }
            for (OrmSecondaryTable virtualSecondaryTable : virtualSecondaryTable2) {
                XmlSecondaryTableImpl secondaryTableResource = OrmFactory.eINSTANCE.createXmlSecondaryTableImpl();
                OrmSecondaryTable specifiedSecondaryTable = this.buildSecondaryTable(secondaryTableResource);
                this.specifiedSecondaryTables.add(specifiedSecondaryTable);
                ((XmlEntity)this.getTypeMappingResource()).getSecondaryTables().add((Object)secondaryTableResource);
                specifiedSecondaryTable.initializeFrom(virtualSecondaryTable);
            }
            this.fireItemsRemoved("virtualSecondaryTablesList", 0, virtualSecondaryTables);
            this.fireItemsAdded("specifiedSecondaryTablesList", 0, this.specifiedSecondaryTables);
        }
    }

    protected void removeSecondaryTablesFromXml() {
        if (this.specifiedSecondaryTablesSize() != 0) {
            List specifiedSecondaryTables = CollectionTools.list(this.specifiedSecondaryTables());
            for (OrmSecondaryTable specifiedSecondaryTable : CollectionTools.iterable(this.specifiedSecondaryTables())) {
                int index = this.specifiedSecondaryTables.indexOf(specifiedSecondaryTable);
                this.specifiedSecondaryTables.remove(specifiedSecondaryTable);
                if (this.specifiedSecondaryTables.size() == 0) {
                    this.initializeVirtualSecondaryTables();
                }
                ((XmlEntity)this.getTypeMappingResource()).getSecondaryTables().remove(index);
            }
            this.fireItemsRemoved("specifiedSecondaryTablesList", 0, specifiedSecondaryTables);
            if (this.virtualSecondaryTables.size() != 0) {
                this.fireItemsAdded("virtualSecondaryTablesList", 0, this.virtualSecondaryTables);
            }
        }
    }

    protected Iterator<String> tableNames(Iterator<Table> tables) {
        return new TransformationIterator<Table, String>(tables){

            protected String transform(Table t) {
                return t.getName();
            }
        };
    }

    @Override
    public Iterator<String> associatedTableNamesIncludingInherited() {
        return this.nonNullTableNames(this.associatedTablesIncludingInherited());
    }

    protected Iterator<String> nonNullTableNames(Iterator<Table> tables) {
        return new FilteringIterator<String, String>(this.tableNames(tables)){

            protected boolean accept(String o) {
                return o != null;
            }
        };
    }

    @Override
    public Iterator<Table> associatedTables() {
        return new SingleElementIterator((Object)this.getTable());
    }

    @Override
    public Iterator<Table> associatedTablesIncludingInherited() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<Table>>(this.inheritanceHierarchy()){

            protected Iterator<Table> transform(TypeMapping mapping) {
                return new FilteringIterator<Table, Table>(mapping.associatedTables()){

                    protected boolean accept(Table o) {
                        return true;
                    }
                };
            }
        });
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return !CollectionTools.contains(this.associatedTableNamesIncludingInherited(), (Object)tableName);
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return this.getSpecifiedInheritanceStrategy() == null ? this.getDefaultInheritanceStrategy() : this.getSpecifiedInheritanceStrategy();
    }

    @Override
    public InheritanceType getDefaultInheritanceStrategy() {
        return this.defaultInheritanceStrategy;
    }

    protected void setDefaultInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.defaultInheritanceStrategy;
        this.defaultInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("defaultInheritanceStrategyProperty", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    @Override
    public InheritanceType getSpecifiedInheritanceStrategy() {
        return this.specifiedInheritanceStrategy;
    }

    @Override
    public void setSpecifiedInheritanceStrategy(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        if (oldInheritanceType != newInheritanceType) {
            if (this.inheritanceResource() != null) {
                this.inheritanceResource().setStrategy(InheritanceType.toOrmResourceModel(newInheritanceType));
                if (this.inheritanceResource().isAllFeaturesUnset()) {
                    this.removeInheritanceResource();
                }
            } else if (newInheritanceType != null) {
                this.addInheritanceResource();
                this.inheritanceResource().setStrategy(InheritanceType.toOrmResourceModel(newInheritanceType));
            }
        }
        this.firePropertyChanged("specifiedInheritanceStrategyProperty", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected void setSpecifiedInheritanceStrategy_(InheritanceType newInheritanceType) {
        InheritanceType oldInheritanceType = this.specifiedInheritanceStrategy;
        this.specifiedInheritanceStrategy = newInheritanceType;
        this.firePropertyChanged("specifiedInheritanceStrategyProperty", (Object)oldInheritanceType, (Object)newInheritanceType);
    }

    protected Inheritance inheritanceResource() {
        return ((XmlEntity)this.getTypeMappingResource()).getInheritance();
    }

    protected void addInheritanceResource() {
        ((XmlEntity)this.getTypeMappingResource()).setInheritance(OrmFactory.eINSTANCE.createInheritance());
    }

    protected void removeInheritanceResource() {
        ((XmlEntity)this.getTypeMappingResource()).setInheritance(null);
    }

    @Override
    public OrmDiscriminatorColumn getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    @Override
    public OrmSequenceGenerator addSequenceGenerator() {
        if (this.getSequenceGenerator() != null) {
            throw new IllegalStateException("sequenceGenerator already exists");
        }
        this.sequenceGenerator = this.getJpaFactory().buildOrmSequenceGenerator(this);
        ((XmlEntity)this.getTypeMappingResource()).setSequenceGenerator(OrmFactory.eINSTANCE.createXmlSequenceGeneratorImpl());
        this.firePropertyChanged("sequenceGeneratorProperty", null, this.sequenceGenerator);
        return this.sequenceGenerator;
    }

    @Override
    public void removeSequenceGenerator() {
        if (this.getSequenceGenerator() == null) {
            throw new IllegalStateException("sequenceGenerator does not exist, cannot be removed");
        }
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = null;
        ((XmlEntity)this.getTypeMappingResource()).setSequenceGenerator(null);
        this.firePropertyChanged("sequenceGeneratorProperty", oldSequenceGenerator, null);
    }

    @Override
    public OrmSequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    protected void setSequenceGenerator(OrmSequenceGenerator newSequenceGenerator) {
        OrmSequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        this.firePropertyChanged("sequenceGeneratorProperty", oldSequenceGenerator, newSequenceGenerator);
    }

    @Override
    public OrmTableGenerator addTableGenerator() {
        if (this.getTableGenerator() != null) {
            throw new IllegalStateException("tableGenerator already exists");
        }
        this.tableGenerator = this.getJpaFactory().buildOrmTableGenerator(this);
        ((XmlEntity)this.getTypeMappingResource()).setTableGenerator(OrmFactory.eINSTANCE.createXmlTableGeneratorImpl());
        this.firePropertyChanged("tableGeneratorProperty", null, this.tableGenerator);
        return this.tableGenerator;
    }

    @Override
    public void removeTableGenerator() {
        if (this.getTableGenerator() == null) {
            throw new IllegalStateException("tableGenerator does not exist, cannot be removed");
        }
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = null;
        ((XmlEntity)this.getTypeMappingResource()).setTableGenerator(null);
        this.firePropertyChanged("tableGeneratorProperty", oldTableGenerator, null);
    }

    @Override
    public OrmTableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    protected void setTableGenerator(OrmTableGenerator newTableGenerator) {
        OrmTableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        this.firePropertyChanged("tableGeneratorProperty", oldTableGenerator, newTableGenerator);
    }

    protected Iterator<OrmGenerator> generators() {
        return new CompositeIterator(new Iterator[]{this.getSequenceGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getSequenceGenerator()), this.getTableGenerator() == null ? EmptyIterator.instance() : new SingleElementIterator((Object)this.getTableGenerator())});
    }

    @Override
    public String getDefaultDiscriminatorValue() {
        return this.defaultDiscriminatorValue;
    }

    protected void setDefaultDiscriminatorValue(String newDefaultDiscriminatorValue) {
        String oldDefaultDiscriminatorValue = this.defaultDiscriminatorValue;
        this.defaultDiscriminatorValue = newDefaultDiscriminatorValue;
        this.firePropertyChanged("defaultDiscriminatorValueProperty", oldDefaultDiscriminatorValue, newDefaultDiscriminatorValue);
    }

    @Override
    public String getSpecifiedDiscriminatorValue() {
        return this.specifiedDiscriminatorValue;
    }

    @Override
    public void setSpecifiedDiscriminatorValue(String newSpecifiedDiscriminatorValue) {
        String oldSpecifiedDiscriminatorValue = this.specifiedDiscriminatorValue;
        this.specifiedDiscriminatorValue = newSpecifiedDiscriminatorValue;
        ((XmlEntity)this.getTypeMappingResource()).setDiscriminatorValue(newSpecifiedDiscriminatorValue);
        this.firePropertyChanged("specifiedDiscriminatorValueProperty", oldSpecifiedDiscriminatorValue, newSpecifiedDiscriminatorValue);
    }

    @Override
    public String getDiscriminatorValue() {
        return this.getSpecifiedDiscriminatorValue() == null ? this.getDefaultDiscriminatorValue() : this.getSpecifiedDiscriminatorValue();
    }

    @Override
    public boolean isDiscriminatorValueAllowed() {
        return this.discriminatorValueAllowed;
    }

    protected void setDiscriminatorValueAllowed(boolean newDiscriminatorValueAllowed) {
        boolean oldDiscriminatorValueAllowed = this.discriminatorValueAllowed;
        this.discriminatorValueAllowed = newDiscriminatorValueAllowed;
        this.firePropertyChanged("discriminatorValueAllowedProperty", oldDiscriminatorValueAllowed, newDiscriminatorValueAllowed);
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.defaultPrimaryKeyJoinColumns);
    }

    public int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumns.size();
    }

    @Override
    public OrmPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return null;
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.specifiedPrimaryKeyJoinColumns.isEmpty() ? this.defaultPrimaryKeyJoinColumns() : this.specifiedPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.isEmpty() ? this.defaultPrimaryKeyJoinColumnsSize() : this.specifiedPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    @Override
    public OrmPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn primaryKeyJoinColumn = this.getJpaFactory().buildOrmPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner());
        this.specifiedPrimaryKeyJoinColumns.add(index, primaryKeyJoinColumn);
        ((XmlEntity)this.getTypeMappingResource()).getPrimaryKeyJoinColumns().add(index, (Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumnImpl());
        this.fireItemAdded("specifiedPrimaryKeyJoinColumnsList", index, primaryKeyJoinColumn);
        return primaryKeyJoinColumn;
    }

    protected OrmBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(int index, OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumnsList");
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(primaryKeyJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn removedPrimaryKeyJoinColumn = this.specifiedPrimaryKeyJoinColumns.remove(index);
        ((XmlEntity)this.getTypeMappingResource()).getPrimaryKeyJoinColumns().remove(index);
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumnsList", index, removedPrimaryKeyJoinColumn);
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeItemFromList(primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumnsList");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedPrimaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedPrimaryKeyJoinColumnsList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmAttributeOverride> attributeOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributeOverrides(), this.virtualAttributeOverrides()});
    }

    @Override
    public int attributeOverridesSize() {
        return this.specifiedAttributeOverridesSize() + this.virtualAttributeOverridesSize();
    }

    @Override
    public ListIterator<OrmAttributeOverride> virtualAttributeOverrides() {
        return new CloneListIterator(this.defaultAttributeOverrides);
    }

    @Override
    public int virtualAttributeOverridesSize() {
        return this.defaultAttributeOverrides.size();
    }

    @Override
    public ListIterator<OrmAttributeOverride> specifiedAttributeOverrides() {
        return new CloneListIterator(this.specifiedAttributeOverrides);
    }

    @Override
    public int specifiedAttributeOverridesSize() {
        return this.specifiedAttributeOverrides.size();
    }

    protected void addSpecifiedAttributeOverride(int index, OrmAttributeOverride attributeOverride) {
        this.addItemToList(index, attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverridesList");
    }

    protected void removeSpecifiedAttributeOverride_(OrmAttributeOverride attributeOverride) {
        this.removeItemFromList(attributeOverride, this.specifiedAttributeOverrides, "specifiedAttributeOverridesList");
    }

    @Override
    public void moveSpecifiedAttributeOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAttributeOverrides, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getAttributeOverrides().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedAttributeOverridesList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmAssociationOverride> associationOverrides() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAssociationOverrides(), this.virtualAssociationOverrides()});
    }

    @Override
    public int associationOverridesSize() {
        return this.specifiedAssociationOverridesSize() + this.virtualAssociationOverridesSize();
    }

    @Override
    public ListIterator<OrmAssociationOverride> virtualAssociationOverrides() {
        return new CloneListIterator(this.defaultAssociationOverrides);
    }

    @Override
    public int virtualAssociationOverridesSize() {
        return this.defaultAssociationOverrides.size();
    }

    @Override
    public ListIterator<OrmAssociationOverride> specifiedAssociationOverrides() {
        return new CloneListIterator(this.specifiedAssociationOverrides);
    }

    @Override
    public int specifiedAssociationOverridesSize() {
        return this.specifiedAssociationOverrides.size();
    }

    protected void addSpecifiedAssociationOverride(int index, OrmAssociationOverride associationOverride) {
        this.addItemToList(index, associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverridesList");
    }

    protected void removeSpecifiedAssociationOverride_(OrmAssociationOverride associationOverride) {
        this.removeItemFromList(associationOverride, this.specifiedAssociationOverrides, "specifiedAssociationOverridesList");
    }

    @Override
    public void moveSpecifiedAssociationOverride(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedAssociationOverrides, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getAssociationOverrides().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedAssociationOverridesList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmNamedQuery> namedQueries() {
        return new CloneListIterator(this.namedQueries);
    }

    @Override
    public int namedQueriesSize() {
        return this.namedQueries.size();
    }

    @Override
    public OrmNamedQuery addNamedQuery(int index) {
        OrmNamedQuery namedQuery = this.getJpaFactory().buildOrmNamedQuery(this);
        this.namedQueries.add(index, namedQuery);
        ((XmlEntity)this.getTypeMappingResource()).getNamedQueries().add(index, (Object)OrmFactory.eINSTANCE.createXmlNamedQuery());
        this.fireItemAdded("namedQueriesList", index, namedQuery);
        return namedQuery;
    }

    protected void addNamedQuery(int index, OrmNamedQuery namedQuery) {
        this.addItemToList(index, namedQuery, this.namedQueries, "namedQueriesList");
    }

    @Override
    public void removeNamedQuery(NamedQuery namedQuery) {
        this.removeNamedQuery(this.namedQueries.indexOf(namedQuery));
    }

    @Override
    public void removeNamedQuery(int index) {
        OrmNamedQuery namedQuery = this.namedQueries.remove(index);
        ((XmlEntity)this.getTypeMappingResource()).getNamedQueries().remove(index);
        this.fireItemRemoved("namedQueriesList", index, namedQuery);
    }

    protected void removeNamedQuery_(OrmNamedQuery namedQuery) {
        this.removeItemFromList(namedQuery, this.namedQueries, "namedQueriesList");
    }

    @Override
    public void moveNamedQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedQueries, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getNamedQueries().move(targetIndex, sourceIndex);
        this.fireItemMoved("namedQueriesList", targetIndex, sourceIndex);
    }

    @Override
    public ListIterator<OrmNamedNativeQuery> namedNativeQueries() {
        return new CloneListIterator(this.namedNativeQueries);
    }

    @Override
    public int namedNativeQueriesSize() {
        return this.namedNativeQueries.size();
    }

    @Override
    public OrmNamedNativeQuery addNamedNativeQuery(int index) {
        OrmNamedNativeQuery namedNativeQuery = this.getJpaFactory().buildOrmNamedNativeQuery(this);
        this.namedNativeQueries.add(index, namedNativeQuery);
        ((XmlEntity)this.getTypeMappingResource()).getNamedNativeQueries().add(index, (Object)OrmFactory.eINSTANCE.createXmlNamedNativeQuery());
        this.fireItemAdded("namedNativeQueriesList", index, namedNativeQuery);
        return namedNativeQuery;
    }

    protected void addNamedNativeQuery(int index, OrmNamedNativeQuery namedNativeQuery) {
        this.addItemToList(index, namedNativeQuery, this.namedNativeQueries, "namedNativeQueriesList");
    }

    @Override
    public void removeNamedNativeQuery(NamedNativeQuery namedNativeQuery) {
        this.removeNamedNativeQuery(this.namedNativeQueries.indexOf(namedNativeQuery));
    }

    @Override
    public void removeNamedNativeQuery(int index) {
        OrmNamedNativeQuery namedNativeQuery = this.namedNativeQueries.remove(index);
        ((XmlEntity)this.getTypeMappingResource()).getNamedNativeQueries().remove(index);
        this.fireItemRemoved("namedNativeQueriesList", index, namedNativeQuery);
    }

    protected void removeNamedNativeQuery_(OrmNamedNativeQuery namedNativeQuery) {
        this.removeItemFromList(namedNativeQuery, this.namedNativeQueries, "namedNativeQueriesList");
    }

    @Override
    public void moveNamedNativeQuery(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.namedNativeQueries, (int)targetIndex, (int)sourceIndex);
        ((XmlEntity)this.getTypeMappingResource()).getNamedNativeQueries().move(targetIndex, sourceIndex);
        this.fireItemMoved("namedNativeQueriesList", targetIndex, sourceIndex);
    }

    protected Iterator<OrmQuery> queries() {
        return new CompositeIterator(new Iterator[]{this.namedQueries(), this.namedNativeQueries()});
    }

    @Override
    public String getIdClass() {
        return this.idClass;
    }

    @Override
    public void setIdClass(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        if (oldIdClass != newIdClass) {
            if (this.idClassResource() != null) {
                this.idClassResource().setClassName(newIdClass);
                if (this.idClassResource().isAllFeaturesUnset()) {
                    this.removeIdClassResource();
                }
            } else if (newIdClass != null) {
                this.addIdClassResource();
                this.idClassResource().setClassName(newIdClass);
            }
        }
        this.firePropertyChanged("idClassProperty", oldIdClass, newIdClass);
    }

    protected void setIdClass_(String newIdClass) {
        String oldIdClass = this.idClass;
        this.idClass = newIdClass;
        this.firePropertyChanged("idClassProperty", oldIdClass, newIdClass);
    }

    protected XmlIdClass idClassResource() {
        return ((XmlEntity)this.getTypeMappingResource()).getIdClass();
    }

    protected void addIdClassResource() {
        ((XmlEntity)this.getTypeMappingResource()).setIdClass(OrmFactory.eINSTANCE.createXmlIdClass());
    }

    protected void removeIdClassResource() {
        ((XmlEntity)this.getTypeMappingResource()).setIdClass(null);
    }

    @Override
    public Entity getParentEntity() {
        Iterator<PersistentType> i = this.getPersistentType().inheritanceHierarchy();
        while (i.hasNext()) {
            TypeMapping typeMapping = i.next().getMapping();
            if (typeMapping == this || !(typeMapping instanceof Entity)) continue;
            return (Entity)typeMapping;
        }
        return this;
    }

    @Override
    public Entity getRootEntity() {
        Entity rootEntity = null;
        Iterator<PersistentType> i = this.getPersistentType().inheritanceHierarchy();
        while (i.hasNext()) {
            PersistentType persistentType = i.next();
            if (!(persistentType.getMapping() instanceof Entity)) continue;
            rootEntity = (Entity)persistentType.getMapping();
        }
        return rootEntity;
    }

    @Override
    public int getXmlSequence() {
        return 1;
    }

    protected Iterator<TypeMapping> inheritanceHierarchy() {
        return new TransformationIterator<PersistentType, TypeMapping>(this.getPersistentType().inheritanceHierarchy()){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public Iterator<PersistentAttribute> allOverridableAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(TypeMapping mapping) {
                return mapping.overridableAttributes();
            }
        });
    }

    @Override
    public Iterator<String> allOverridableAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<String>>(this.inheritanceHierarchy()){

            protected Iterator<String> transform(TypeMapping mapping) {
                return mapping.overridableAttributeNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverridableAssociationNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<TypeMapping, Iterator<String>>(this.inheritanceHierarchy()){

            protected Iterator<String> transform(TypeMapping mapping) {
                return mapping.overridableAssociationNames();
            }
        });
    }

    @Override
    public void initialize(XmlEntity entity) {
        super.initialize(entity);
        this.specifiedName = entity.getName();
        this.defaultName = this.defaultName();
        this.initializeInheritance(this.inheritanceResource());
        this.discriminatorColumn.initialize(entity);
        this.specifiedDiscriminatorValue = entity.getDiscriminatorValue();
        this.defaultDiscriminatorValue = this.defaultDiscriminatorValue();
        this.discriminatorValueAllowed = this.discriminatorValueIsAllowed();
        this.table.initialize(entity);
        this.initializeSpecifiedSecondaryTables(entity);
        this.initializeVirtualSecondaryTables();
        this.initializeSequenceGenerator(entity);
        this.initializeTableGenerator(entity);
        this.initializeSpecifiedPrimaryKeyJoinColumns(entity);
        this.initializeSpecifiedAttributeOverrides(entity);
        this.initializeSpecifiedAssociationOverrides(entity);
        this.initializeNamedQueries(entity);
        this.initializeNamedNativeQueries(entity);
        this.initializeIdClass(this.idClassResource());
        this.updatePersistenceUnitGeneratorsAndQueries();
    }

    protected void initializeInheritance(Inheritance inheritanceResource) {
        this.specifiedInheritanceStrategy = this.specifiedInheritanceStrategy(inheritanceResource);
        this.defaultInheritanceStrategy = this.defaultInheritanceStrategy();
    }

    protected void initializeSpecifiedSecondaryTables(XmlEntity entity) {
        for (XmlSecondaryTable secondaryTable : entity.getSecondaryTables()) {
            this.specifiedSecondaryTables.add(this.buildSecondaryTable(secondaryTable));
        }
    }

    protected void initializeVirtualSecondaryTables() {
        if (this.isMetadataComplete()) {
            return;
        }
        if (this.getJavaEntity() == null) {
            return;
        }
        if (this.specifiedSecondaryTablesSize() > 0) {
            return;
        }
        ListIterator<JavaSecondaryTable> javaSecondaryTables = this.getJavaEntity().secondaryTables();
        while (javaSecondaryTables.hasNext()) {
            JavaSecondaryTable javaSecondaryTable = javaSecondaryTables.next();
            if (javaSecondaryTable.getName() == null) continue;
            this.virtualSecondaryTables.add(this.buildVirtualSecondaryTable(javaSecondaryTable));
        }
    }

    protected void initializeTableGenerator(XmlEntity entity) {
        if (entity.getTableGenerator() != null) {
            this.tableGenerator = this.buildTableGenerator(entity.getTableGenerator());
        }
    }

    protected OrmTableGenerator buildTableGenerator(XmlTableGenerator tableGeneratorResource) {
        OrmTableGenerator tableGenerator = this.getJpaFactory().buildOrmTableGenerator(this);
        tableGenerator.initialize(tableGeneratorResource);
        return tableGenerator;
    }

    protected void initializeSequenceGenerator(XmlEntity entity) {
        if (entity.getSequenceGenerator() != null) {
            this.sequenceGenerator = this.buildSequenceGenerator(entity.getSequenceGenerator());
        }
    }

    protected OrmSequenceGenerator buildSequenceGenerator(XmlSequenceGenerator xmlSequenceGenerator) {
        OrmSequenceGenerator sequenceGenerator = this.getJpaFactory().buildOrmSequenceGenerator(this);
        sequenceGenerator.initialize(xmlSequenceGenerator);
        return sequenceGenerator;
    }

    protected void initializeSpecifiedPrimaryKeyJoinColumns(XmlEntity entity) {
        for (XmlPrimaryKeyJoinColumn primaryKeyJoinColumn : entity.getPrimaryKeyJoinColumns()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.createPrimaryKeyJoinColumn(primaryKeyJoinColumn));
        }
    }

    protected void initializeSpecifiedAttributeOverrides(XmlEntity entity) {
        for (XmlAttributeOverride attributeOverride : entity.getAttributeOverrides()) {
            this.specifiedAttributeOverrides.add(this.buildAttributeOverride(attributeOverride));
        }
    }

    protected void initializeSpecifiedAssociationOverrides(XmlEntity entity) {
        for (XmlAssociationOverride associationOverride : entity.getAssociationOverrides()) {
            this.specifiedAssociationOverrides.add(this.buildAssociationOverride(associationOverride));
        }
    }

    protected void initializeNamedQueries(XmlEntity entity) {
        for (XmlNamedQuery namedQuery : entity.getNamedQueries()) {
            this.namedQueries.add(this.buildNamedQuery(namedQuery));
        }
    }

    protected void initializeNamedNativeQueries(XmlEntity entity) {
        for (XmlNamedNativeQuery namedNativeQuery : entity.getNamedNativeQueries()) {
            this.namedNativeQueries.add(this.buildNamedNativeQuery(namedNativeQuery));
        }
    }

    protected void initializeIdClass(XmlIdClass idClassResource) {
        this.idClass = this.idClass(idClassResource);
    }

    protected String idClass(XmlIdClass idClassResource) {
        return idClassResource == null ? null : idClassResource.getClassName();
    }

    @Override
    public void update(XmlEntity entity) {
        super.update(entity);
        this.setSpecifiedName(entity.getName());
        this.setDefaultName(this.defaultName());
        this.updateInheritance(this.inheritanceResource());
        this.discriminatorColumn.update(entity);
        this.setSpecifiedDiscriminatorValue(entity.getDiscriminatorValue());
        this.setDefaultDiscriminatorValue(this.defaultDiscriminatorValue());
        this.setDiscriminatorValueAllowed(this.discriminatorValueIsAllowed());
        this.table.update(entity);
        this.updateSpecifiedSecondaryTables(entity);
        this.updateVirtualSecondaryTables();
        this.updateSequenceGenerator(entity);
        this.updateTableGenerator(entity);
        this.updateSpecifiedPrimaryKeyJoinColumns(entity);
        this.updateSpecifiedAttributeOverrides(entity);
        this.updateSpecifiedAssociationOverrides(entity);
        this.updateNamedQueries(entity);
        this.updateNamedNativeQueries(entity);
        this.updateIdClass(this.idClassResource());
        this.updatePersistenceUnitGeneratorsAndQueries();
    }

    protected String defaultName() {
        String className = this.getClass_();
        if (className != null) {
            return ClassTools.shortNameForClassNamed((String)className);
        }
        return null;
    }

    protected String defaultDiscriminatorValue() {
        return null;
    }

    protected boolean discriminatorValueIsAllowed() {
        return this.getJavaEntity() == null ? false : this.getJavaEntity().isDiscriminatorValueAllowed();
    }

    protected void updateInheritance(Inheritance inheritanceResource) {
        this.setSpecifiedInheritanceStrategy_(this.specifiedInheritanceStrategy(inheritanceResource));
        this.setDefaultInheritanceStrategy(this.defaultInheritanceStrategy());
    }

    protected void updateSpecifiedSecondaryTables(XmlEntity entity) {
        ListIterator<OrmSecondaryTable> secondaryTables = this.specifiedSecondaryTables();
        ListIterator resourceSecondaryTables = entity.getSecondaryTables().listIterator();
        while (secondaryTables.hasNext()) {
            OrmSecondaryTable secondaryTable = secondaryTables.next();
            if (resourceSecondaryTables.hasNext()) {
                secondaryTable.update((XmlSecondaryTable)resourceSecondaryTables.next());
                continue;
            }
            this.removeSpecifiedSecondaryTable_(secondaryTable);
        }
        while (resourceSecondaryTables.hasNext()) {
            this.addSpecifiedSecondaryTable(this.specifiedSecondaryTablesSize(), this.buildSecondaryTable((XmlSecondaryTable)resourceSecondaryTables.next()));
        }
    }

    protected void updateVirtualSecondaryTables() {
        ListIterator<OrmSecondaryTable> secondaryTables = this.virtualSecondaryTables();
        ListIterator<JavaSecondaryTable> javaSecondaryTables = EmptyListIterator.instance();
        if (this.getJavaEntity() != null && !this.isMetadataComplete() && this.specifiedSecondaryTablesSize() == 0) {
            javaSecondaryTables = this.getJavaEntity().secondaryTables();
        }
        while (secondaryTables.hasNext()) {
            OrmSecondaryTable virtualSecondaryTable = secondaryTables.next();
            if (javaSecondaryTables.hasNext()) {
                JavaSecondaryTable javaSecondaryTable = javaSecondaryTables.next();
                virtualSecondaryTable.update(new VirtualXmlSecondaryTable(javaSecondaryTable));
                continue;
            }
            this.removeVirtualSecondaryTable(virtualSecondaryTable);
        }
        while (javaSecondaryTables.hasNext()) {
            JavaSecondaryTable javaSecondaryTable = (JavaSecondaryTable)javaSecondaryTables.next();
            this.addVirtualSecondaryTable(this.buildVirtualSecondaryTable(javaSecondaryTable));
        }
    }

    protected OrmSecondaryTable buildSecondaryTable(XmlSecondaryTable xmlSecondaryTable) {
        return this.getJpaFactory().buildOrmSecondaryTable(this, xmlSecondaryTable);
    }

    protected OrmSecondaryTable buildVirtualSecondaryTable(JavaSecondaryTable javaSecondaryTable) {
        return this.buildSecondaryTable(new VirtualXmlSecondaryTable(javaSecondaryTable));
    }

    protected void updateTableGenerator(XmlEntity entity) {
        if (entity.getTableGenerator() == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else if (this.getTableGenerator() == null) {
            this.setTableGenerator(this.buildTableGenerator(entity.getTableGenerator()));
        } else {
            this.getTableGenerator().update(entity.getTableGenerator());
        }
    }

    protected void updateSequenceGenerator(XmlEntity entity) {
        if (entity.getSequenceGenerator() == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else if (this.getSequenceGenerator() == null) {
            this.setSequenceGenerator(this.buildSequenceGenerator(entity.getSequenceGenerator()));
        } else {
            this.getSequenceGenerator().update(entity.getSequenceGenerator());
        }
    }

    protected InheritanceType specifiedInheritanceStrategy(Inheritance inheritanceResource) {
        if (inheritanceResource == null) {
            return null;
        }
        return InheritanceType.fromOrmResourceModel(inheritanceResource.getStrategy());
    }

    protected InheritanceType defaultInheritanceStrategy() {
        if (this.inheritanceResource() == null && !this.isMetadataComplete() && this.getJavaEntity() != null) {
            return this.getJavaEntity().getInheritanceStrategy();
        }
        if (this.getRootEntity() == this) {
            return InheritanceType.SINGLE_TABLE;
        }
        return this.getRootEntity().getInheritanceStrategy();
    }

    protected void updateSpecifiedPrimaryKeyJoinColumns(XmlEntity entity) {
        ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns = this.specifiedPrimaryKeyJoinColumns();
        ListIterator resourcePrimaryKeyJoinColumns = entity.getPrimaryKeyJoinColumns().listIterator();
        while (primaryKeyJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn primaryKeyJoinColumn = primaryKeyJoinColumns.next();
            if (resourcePrimaryKeyJoinColumns.hasNext()) {
                primaryKeyJoinColumn.update((XmlPrimaryKeyJoinColumn)resourcePrimaryKeyJoinColumns.next());
                continue;
            }
            this.removeSpecifiedPrimaryKeyJoinColumn_(primaryKeyJoinColumn);
        }
        while (resourcePrimaryKeyJoinColumns.hasNext()) {
            this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumnsSize(), this.createPrimaryKeyJoinColumn((XmlPrimaryKeyJoinColumn)resourcePrimaryKeyJoinColumns.next()));
        }
    }

    protected OrmPrimaryKeyJoinColumn createPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        OrmPrimaryKeyJoinColumn ormPrimaryKeyJoinColumn = this.getJpaFactory().buildOrmPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner());
        ormPrimaryKeyJoinColumn.initialize(primaryKeyJoinColumn);
        return ormPrimaryKeyJoinColumn;
    }

    protected void updateSpecifiedAttributeOverrides(XmlEntity entity) {
        ListIterator<OrmAttributeOverride> attributeOverrides = this.specifiedAttributeOverrides();
        ListIterator resourceAttributeOverrides = entity.getAttributeOverrides().listIterator();
        while (attributeOverrides.hasNext()) {
            OrmAttributeOverride attributeOverride = attributeOverrides.next();
            if (resourceAttributeOverrides.hasNext()) {
                attributeOverride.update((XmlAttributeOverride)resourceAttributeOverrides.next());
                continue;
            }
            this.removeSpecifiedAttributeOverride_(attributeOverride);
        }
        while (resourceAttributeOverrides.hasNext()) {
            this.addSpecifiedAttributeOverride(this.specifiedAttributeOverridesSize(), this.buildAttributeOverride((XmlAttributeOverride)resourceAttributeOverrides.next()));
        }
    }

    protected OrmAttributeOverride buildAttributeOverride(XmlAttributeOverride attributeOverride) {
        return this.getJpaFactory().buildOrmAttributeOverride(this, this.createAttributeOverrideOwner(), attributeOverride);
    }

    protected AttributeOverride.Owner createAttributeOverrideOwner() {
        return new AttributeOverrideOwner();
    }

    protected void updateSpecifiedAssociationOverrides(XmlEntity entity) {
        ListIterator<OrmAssociationOverride> associationOverrides = this.specifiedAssociationOverrides();
        ListIterator resourceAssociationOverrides = entity.getAssociationOverrides().listIterator();
        while (associationOverrides.hasNext()) {
            OrmAssociationOverride associationOverride = associationOverrides.next();
            if (resourceAssociationOverrides.hasNext()) {
                associationOverride.update((XmlAssociationOverride)resourceAssociationOverrides.next());
                continue;
            }
            this.removeSpecifiedAssociationOverride_(associationOverride);
        }
        while (resourceAssociationOverrides.hasNext()) {
            this.addSpecifiedAssociationOverride(this.specifiedAssociationOverridesSize(), this.buildAssociationOverride((XmlAssociationOverride)resourceAssociationOverrides.next()));
        }
    }

    protected OrmAssociationOverride buildAssociationOverride(XmlAssociationOverride associationOverride) {
        return this.getJpaFactory().buildOrmAssociationOverride(this, this.createAssociationOverrideOwner(), associationOverride);
    }

    protected AssociationOverride.Owner createAssociationOverrideOwner() {
        return new AssociationOverrideOwner();
    }

    protected void updateNamedQueries(XmlEntity entity) {
        ListIterator<OrmNamedQuery> namedQueries = this.namedQueries();
        ListIterator resourceNamedQueries = entity.getNamedQueries().listIterator();
        while (namedQueries.hasNext()) {
            OrmNamedQuery namedQuery = namedQueries.next();
            if (resourceNamedQueries.hasNext()) {
                namedQuery.update((XmlNamedQuery)resourceNamedQueries.next());
                continue;
            }
            this.removeNamedQuery_(namedQuery);
        }
        while (resourceNamedQueries.hasNext()) {
            this.addNamedQuery(this.namedQueriesSize(), this.buildNamedQuery((XmlNamedQuery)resourceNamedQueries.next()));
        }
    }

    protected OrmNamedQuery buildNamedQuery(XmlNamedQuery namedQuery) {
        OrmNamedQuery ormNamedQuery = this.getJpaFactory().buildOrmNamedQuery(this);
        ormNamedQuery.initialize(namedQuery);
        return ormNamedQuery;
    }

    protected void updateNamedNativeQueries(XmlEntity entity) {
        ListIterator<OrmNamedNativeQuery> namedNativeQueries = this.namedNativeQueries();
        ListIterator resourceNamedNativeQueries = entity.getNamedNativeQueries().listIterator();
        while (namedNativeQueries.hasNext()) {
            OrmNamedNativeQuery namedQuery = namedNativeQueries.next();
            if (resourceNamedNativeQueries.hasNext()) {
                namedQuery.update((XmlNamedNativeQuery)resourceNamedNativeQueries.next());
                continue;
            }
            this.removeNamedNativeQuery_(namedQuery);
        }
        while (resourceNamedNativeQueries.hasNext()) {
            this.addNamedNativeQuery(this.namedNativeQueriesSize(), this.buildNamedNativeQuery((XmlNamedNativeQuery)resourceNamedNativeQueries.next()));
        }
    }

    protected OrmNamedNativeQuery buildNamedNativeQuery(XmlNamedNativeQuery namedQuery) {
        OrmNamedNativeQuery ormNamedNativeQuery = this.getJpaFactory().buildOrmNamedNativeQuery(this);
        ormNamedNativeQuery.initialize(namedQuery);
        return ormNamedNativeQuery;
    }

    protected void updateIdClass(XmlIdClass idClassResource) {
        this.setIdClass_(this.idClass(idClassResource));
    }

    protected void updatePersistenceUnitGeneratorsAndQueries() {
        if (this.getTableGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getTableGenerator());
        }
        if (this.getSequenceGenerator() != null) {
            this.getPersistenceUnit().addGenerator(this.getSequenceGenerator());
        }
        for (Query query : CollectionTools.iterable(this.namedQueries())) {
            this.getPersistenceUnit().addQuery(query);
        }
        for (Query query : CollectionTools.iterable(this.namedNativeQueries())) {
            this.getPersistenceUnit().addQuery(query);
        }
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return GenericJavaEntity.primaryKeyColumnName(this.getPersistentType().allAttributes());
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.getTable().addToMessages(messages);
        this.addIdMessages(messages);
        this.addGeneratorMessages(messages);
        this.addQueryMessages(messages);
        for (OrmSecondaryTable secondaryTable : CollectionTools.iterable(this.secondaryTables())) {
            secondaryTable.addToMessages(messages);
        }
        for (OrmAttributeOverride attributeOverride : CollectionTools.iterable(this.attributeOverrides())) {
            attributeOverride.addToMessages(messages);
        }
        for (OrmAssociationOverride associationOverride : CollectionTools.iterable(this.associationOverrides())) {
            associationOverride.addToMessages(messages);
        }
    }

    protected void addIdMessages(List<IMessage> messages) {
        this.addNoIdMessage(messages);
    }

    protected void addNoIdMessage(List<IMessage> messages) {
        if (this.entityHasNoId()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NO_ID", new String[]{this.getName()}, this, this.getValidationTextRange()));
        }
    }

    private boolean entityHasNoId() {
        return !this.entityHasId();
    }

    protected void addGeneratorMessages(List<IMessage> messages) {
        List masterList = CollectionTools.list(this.getPersistenceUnit().allGenerators());
        Iterator<OrmGenerator> stream = this.generators();
        while (stream.hasNext()) {
            OrmGenerator current = stream.next();
            masterList.remove(current);
            for (Generator each : masterList) {
                if (each.overrides(current) || each.getName() == null || !each.getName().equals(current.getName())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", new String[]{current.getName()}, current, current.getNameTextRange()));
            }
            masterList.add(current);
        }
    }

    protected void addQueryMessages(List<IMessage> messages) {
        List masterList = CollectionTools.list(this.getPersistenceUnit().allQueries());
        Iterator<OrmQuery> stream = this.queries();
        while (stream.hasNext()) {
            OrmQuery current = stream.next();
            masterList.remove(current);
            for (Query each : masterList) {
                if (each.overrides(current) || each.getName() == null || !each.getName().equals(current.getName())) continue;
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", new String[]{current.getName()}, current, current.getNameTextRange()));
            }
            masterList.add(current);
        }
    }

    private boolean entityHasId() {
        Iterator<PersistentAttribute> stream = this.getPersistentType().allAttributes();
        while (stream.hasNext()) {
            if (!stream.next().isIdAttribute()) continue;
            return true;
        }
        return false;
    }

    public TypeMapping typeMapping() {
        return this;
    }

    @Override
    public void removeFromResourceModel(XmlEntityMappings entityMappings) {
        entityMappings.getEntities().remove(this.getTypeMappingResource());
    }

    @Override
    public XmlEntity addToResourceModel(XmlEntityMappings entityMappings) {
        XmlEntity entity = OrmFactory.eINSTANCE.createXmlEntity();
        this.getPersistentType().initialize(entity);
        entityMappings.getEntities().add((Object)entity);
        return entity;
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getName());
    }

    class AssociationOverrideOwner
    implements AssociationOverride.Owner {
        AssociationOverrideOwner() {
        }

        public RelationshipMapping getRelationshipMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<PersistentAttribute> stream = GenericOrmEntity.this.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                PersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof RelationshipMapping)) continue;
                return (RelationshipMapping)persAttribute.getMapping();
            }
            return null;
        }

        public boolean isVirtual(BaseOverride override) {
            return GenericOrmEntity.this.defaultAssociationOverrides.contains(override);
        }

        public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
            return null;
        }

        public TypeMapping getTypeMapping() {
            return GenericOrmEntity.this;
        }
    }

    class AttributeOverrideOwner
    implements AttributeOverride.Owner {
        AttributeOverrideOwner() {
        }

        public ColumnMapping getColumnMapping(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            Iterator<PersistentAttribute> stream = GenericOrmEntity.this.getPersistentType().allAttributes();
            while (stream.hasNext()) {
                PersistentAttribute persAttribute = stream.next();
                if (!attributeName.equals(persAttribute.getName()) || !(persAttribute.getMapping() instanceof ColumnMapping)) continue;
                return (ColumnMapping)((Object)persAttribute.getMapping());
            }
            return null;
        }

        public boolean isVirtual(BaseOverride override) {
            return GenericOrmEntity.this.defaultAttributeOverrides.contains(override);
        }

        public BaseOverride setVirtual(boolean virtual, BaseOverride override) {
            return null;
        }

        public TypeMapping getTypeMapping() {
            return GenericOrmEntity.this;
        }
    }

    class PrimaryKeyJoinColumnOwner
    implements OrmBaseJoinColumn.Owner {
        PrimaryKeyJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return GenericOrmEntity.this;
        }

        public org.eclipse.jpt.db.Table getDbTable(String tableName) {
            return GenericOrmEntity.this.getDbTable(tableName);
        }

        public org.eclipse.jpt.db.Table getDbReferencedColumnTable() {
            Entity parentEntity = GenericOrmEntity.this.getParentEntity();
            return parentEntity == null ? null : parentEntity.getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return GenericOrmEntity.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmEntity.this.defaultPrimaryKeyJoinColumns.contains(joinColumn);
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            return GenericOrmEntity.this.getParentEntity().getPrimaryKeyColumnName();
        }

        public TextRange getValidationTextRange() {
            return null;
        }
    }
}

