/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.GeneratedValue;
import org.eclipse.jpt.core.context.GenerationType;
import org.eclipse.jpt.core.context.orm.OrmGeneratedValue;
import org.eclipse.jpt.core.context.orm.OrmJpaContextNode;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.XmlGeneratedValue;
import org.eclipse.jpt.core.utility.TextRange;

public class GenericOrmGeneratedValue
extends AbstractOrmJpaContextNode
implements OrmGeneratedValue {
    protected GenerationType specifiedStrategy;
    protected String specifiedGenerator;
    protected String defaultGenerator;
    protected XmlGeneratedValue generatedValue;

    public GenericOrmGeneratedValue(OrmJpaContextNode parent) {
        super(parent);
    }

    public GenerationType getStrategy() {
        return this.getSpecifiedStrategy() == null ? this.getDefaultStrategy() : this.getSpecifiedStrategy();
    }

    public GenerationType getDefaultStrategy() {
        return GeneratedValue.DEFAULT_STRATEGY;
    }

    public GenerationType getSpecifiedStrategy() {
        return this.specifiedStrategy;
    }

    public void setSpecifiedStrategy(GenerationType newSpecifiedStrategy) {
        GenerationType oldStrategy = this.specifiedStrategy;
        this.specifiedStrategy = newSpecifiedStrategy;
        this.generatedValue.setStrategy(GenerationType.toOrmResourceModel(newSpecifiedStrategy));
        this.firePropertyChanged("specifiedStrategyProperty", (Object)oldStrategy, (Object)newSpecifiedStrategy);
    }

    protected void setSpecifiedStrategy_(GenerationType newSpecifiedStrategy) {
        GenerationType oldStrategy = this.specifiedStrategy;
        this.specifiedStrategy = newSpecifiedStrategy;
        this.firePropertyChanged("specifiedStrategyProperty", (Object)oldStrategy, (Object)newSpecifiedStrategy);
    }

    public String getGenerator() {
        return this.getSpecifiedGenerator() == null ? this.getDefaultGenerator() : this.getSpecifiedGenerator();
    }

    public String getDefaultGenerator() {
        return this.defaultGenerator;
    }

    protected void setDefaultGenerator(String newDefaultGenerator) {
        String oldGenerator = this.defaultGenerator;
        this.defaultGenerator = newDefaultGenerator;
        this.firePropertyChanged("defaultGeneratorProperty", oldGenerator, newDefaultGenerator);
    }

    public String getSpecifiedGenerator() {
        return this.specifiedGenerator;
    }

    public void setSpecifiedGenerator(String newSpecifiedGenerator) {
        String oldGenerator = this.specifiedGenerator;
        this.specifiedGenerator = newSpecifiedGenerator;
        this.generatedValue.setGenerator(newSpecifiedGenerator);
        this.firePropertyChanged("specifiedGeneratorProperty", oldGenerator, newSpecifiedGenerator);
    }

    protected void setSpecifiedGenerator_(String newSpecifiedGenerator) {
        String oldGenerator = this.specifiedGenerator;
        this.specifiedGenerator = newSpecifiedGenerator;
        this.firePropertyChanged("specifiedGeneratorProperty", oldGenerator, newSpecifiedGenerator);
    }

    public TextRange getGeneratorTextRange() {
        return this.generatedValue.getGeneratorTextRange();
    }

    public void initialize(XmlGeneratedValue generatedValue) {
        this.generatedValue = generatedValue;
        this.specifiedStrategy = this.strategy(generatedValue);
        this.specifiedGenerator = this.generator(generatedValue);
        this.defaultGenerator = null;
    }

    public void update(XmlGeneratedValue generatedValue) {
        this.generatedValue = generatedValue;
        this.setSpecifiedStrategy_(this.strategy(generatedValue));
        this.setSpecifiedGenerator_(this.generator(generatedValue));
        this.setDefaultGenerator(null);
    }

    protected GenerationType strategy(XmlGeneratedValue generatedValue) {
        return GenerationType.fromOrmResourceModel(generatedValue.getStrategy());
    }

    protected String generator(XmlGeneratedValue generatedValue) {
        return generatedValue.getGenerator();
    }

    public TextRange getValidationTextRange() {
        return this.generatedValue.getValidationTextRange();
    }
}

