/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.NonOwningMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmSingleRelationshipMapping;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.core.resource.orm.XmlOneToOneImpl;
import org.eclipse.jpt.core.utility.TextRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmOneToOneMapping
extends AbstractOrmSingleRelationshipMapping<XmlOneToOne>
implements OrmOneToOneMapping {
    protected String mappedBy;

    public GenericOrmOneToOneMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmOneToOneMapping(this);
    }

    @Override
    public void initializeFromXmlNonOwningMapping(NonOwningMapping oldMapping) {
        super.initializeFromXmlNonOwningMapping(oldMapping);
        this.setMappedBy(oldMapping.getMappedBy());
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.getMappedBy() == null;
    }

    @Override
    public String getMappedBy() {
        return this.mappedBy;
    }

    @Override
    public void setMappedBy(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        ((XmlOneToOne)this.getAttributeMapping()).setMappedBy(newMappedBy);
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    protected void setMappedBy_(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        this.firePropertyChanged("mappedByProperty", oldMappedBy, newMappedBy);
    }

    @Override
    public boolean mappedByIsValid(AttributeMapping mappedByMapping) {
        String mappedByKey = mappedByMapping.getKey();
        return mappedByKey == "oneToOne";
    }

    public TextRange getMappedByTextRange() {
        return null;
    }

    @Override
    public int getXmlSequence() {
        return 5;
    }

    @Override
    public String getKey() {
        return "oneToOne";
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return true;
    }

    @Override
    public XmlOneToOne addToResourceModel(AbstractXmlTypeMapping typeMapping) {
        XmlOneToOneImpl oneToOne = OrmFactory.eINSTANCE.createXmlOneToOneImpl();
        this.getPersistentAttribute().initialize(oneToOne);
        typeMapping.getAttributes().getOneToOnes().add((Object)oneToOne);
        return oneToOne;
    }

    @Override
    public void removeFromResourceModel(AbstractXmlTypeMapping typeMapping) {
        typeMapping.getAttributes().getOneToOnes().remove(this.getAttributeMapping());
        if (typeMapping.getAttributes().isAllFeaturesUnset()) {
            typeMapping.setAttributes(null);
        }
    }

    @Override
    public void initialize(XmlOneToOne oneToOne) {
        super.initialize(oneToOne);
        this.mappedBy = oneToOne.getMappedBy();
    }

    @Override
    public void update(XmlOneToOne oneToOne) {
        super.update(oneToOne);
        this.setMappedBy_(oneToOne.getMappedBy());
    }
}

