/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmVersionMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.AbstractXmlTypeMapping;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlColumn;
import org.eclipse.jpt.core.resource.orm.XmlVersion;
import org.eclipse.jpt.core.resource.orm.XmlVersionImpl;
import org.eclipse.jpt.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmVersionMapping
extends AbstractOrmAttributeMapping<XmlVersion>
implements OrmVersionMapping {
    protected final OrmColumn column = this.getJpaFactory().buildOrmColumn(this, this);
    protected TemporalType temporal;

    public GenericOrmVersionMapping(OrmPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public int getXmlSequence() {
        return 2;
    }

    @Override
    public String getKey() {
        return "version";
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmVersionMapping(this);
    }

    @Override
    public void initializeFromXmlColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromXmlColumnMapping(oldMapping);
        this.setTemporal(oldMapping.getTemporal());
        this.getColumn().initializeFrom(oldMapping.getColumn());
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    @Override
    public TemporalType getTemporal() {
        return this.temporal;
    }

    @Override
    public void setTemporal(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        ((XmlVersion)this.getAttributeMapping()).setTemporal(TemporalType.toOrmResourceModel(newTemporal));
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    protected void setTemporal_(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        this.temporal = newTemporal;
        this.firePropertyChanged("temporalProperty", (Object)oldTemporal, (Object)newTemporal);
    }

    @Override
    public XmlVersion addToResourceModel(AbstractXmlTypeMapping typeMapping) {
        XmlVersionImpl version = OrmFactory.eINSTANCE.createXmlVersionImpl();
        this.getPersistentAttribute().initialize(version);
        typeMapping.getAttributes().getVersions().add((Object)version);
        return version;
    }

    @Override
    public void removeFromResourceModel(AbstractXmlTypeMapping typeMapping) {
        typeMapping.getAttributes().getVersions().remove(this.getAttributeMapping());
        if (typeMapping.getAttributes().isAllFeaturesUnset()) {
            typeMapping.setAttributes(null);
        }
    }

    @Override
    public String getDefaultColumnName() {
        return this.getAttributeName();
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getTableName();
    }

    @Override
    public Table getDbTable(String tableName) {
        return this.getTypeMapping().getDbTable(tableName);
    }

    @Override
    public void initialize(XmlVersion version) {
        super.initialize(version);
        this.temporal = this.specifiedTemporal(version);
        this.column.initialize(version.getColumn());
    }

    @Override
    public void update(XmlVersion version) {
        super.update(version);
        this.setTemporal_(this.specifiedTemporal(version));
        this.column.update(version.getColumn());
    }

    protected TemporalType specifiedTemporal(XmlVersion version) {
        return TemporalType.fromOrmResourceModel(version.getTemporal());
    }

    @Override
    public XmlColumn getColumnResource() {
        return ((XmlVersion)this.getAttributeMapping()).getColumn();
    }

    @Override
    public void addColumnResource() {
        ((XmlVersion)this.getAttributeMapping()).setColumn(OrmFactory.eINSTANCE.createXmlColumnImpl());
    }

    @Override
    public void removeColumnResource() {
        ((XmlVersion)this.getAttributeMapping()).setColumn(null);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.entityOwned()) {
            this.addColumnMessages(messages);
        }
    }

    protected void addColumnMessages(List<IMessage> messages) {
        boolean doContinue;
        OrmColumn column = this.getColumn();
        String table = column.getTable();
        boolean bl = doContinue = this.entityOwned() && this.connectionProfileIsActive();
        if (doContinue && this.getTypeMapping().tableNameIsInvalid(table)) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_TABLE", new String[]{this.getPersistentAttribute().getName(), table, column.getName()}, column, column.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_TABLE", new String[]{table, column.getName()}, column, column.getTableTextRange()));
            }
            doContinue = false;
        }
        if (doContinue && !column.isResolved()) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_COLUMN_UNRESOLVED_NAME", new String[]{this.getPersistentAttribute().getName(), column.getName()}, column, column.getNameTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName()}, column, column.getNameTextRange()));
            }
        }
    }
}

