/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.orm.PersistenceUnitDefaults;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmJpaContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.OrmResource;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmXmlImpl
extends AbstractOrmJpaContextNode
implements OrmXml {
    protected OrmResource ormResource;
    protected EntityMappings entityMappings;

    public OrmXmlImpl(MappingFileRef parent, OrmResource ormResource) {
        super(parent);
        this.initialize(ormResource);
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public OrmPersistentType getPersistentType(String fullyQualifiedTypeName) {
        if (this.getEntityMappings() != null) {
            return this.getEntityMappings().getPersistentType(fullyQualifiedTypeName);
        }
        return null;
    }

    @Override
    public IResource getResource() {
        return this.ormResource.getFile();
    }

    @Override
    public EntityMappings getEntityMappings() {
        return this.entityMappings;
    }

    protected void setEntityMappings(EntityMappings newEntityMappings) {
        EntityMappings oldEntityMappings = this.entityMappings;
        this.entityMappings = newEntityMappings;
        this.firePropertyChanged("entityMappingsProperty", oldEntityMappings, newEntityMappings);
    }

    @Override
    public EntityMappings addEntityMappings() {
        if (this.entityMappings != null) {
            throw new IllegalStateException();
        }
        XmlEntityMappings xmlEntityMappings = OrmFactory.eINSTANCE.createXmlEntityMappings();
        this.entityMappings = this.buildEntityMappings(xmlEntityMappings);
        this.ormResource.getContents().add((Object)xmlEntityMappings);
        this.firePropertyChanged("entityMappingsProperty", null, this.entityMappings);
        return this.entityMappings;
    }

    @Override
    public void removeEntityMappings() {
        if (this.entityMappings == null) {
            throw new IllegalStateException();
        }
        EntityMappings oldEntityMappings = this.entityMappings;
        this.entityMappings = null;
        XmlEntityMappings xmlEntityMappings = this.ormResource.getEntityMappings();
        this.ormResource.getContents().remove((Object)xmlEntityMappings);
        this.firePropertyChanged("entityMappingsProperty", oldEntityMappings, null);
    }

    @Override
    public PersistenceUnitDefaults getPersistenceUnitDefaults() {
        if (this.getEntityMappings() != null) {
            return this.getEntityMappings().getPersistenceUnitDefaults();
        }
        return null;
    }

    protected void initialize(OrmResource ormResource) {
        this.ormResource = ormResource;
        if (ormResource.getEntityMappings() != null) {
            this.entityMappings = this.buildEntityMappings(ormResource.getEntityMappings());
        }
    }

    @Override
    public void update(OrmResource ormResource) {
        this.ormResource = ormResource;
        if (ormResource.getEntityMappings() != null) {
            if (this.entityMappings != null) {
                this.entityMappings.update(ormResource.getEntityMappings());
            } else {
                this.setEntityMappings(this.buildEntityMappings(ormResource.getEntityMappings()));
            }
            ormResource.getResourceModel().addRootStructureNode(this.getEntityMappings());
        } else {
            ormResource.getResourceModel().removeRootStructureNode(this.getEntityMappings());
            this.setEntityMappings(null);
        }
    }

    protected EntityMappings buildEntityMappings(XmlEntityMappings xmlEntityMappings) {
        return this.getJpaFactory().buildEntityMappings(this, xmlEntityMappings);
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        if (this.entityMappings.containsOffset(textOffset)) {
            return this.entityMappings.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public TextRange getValidationTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        if (this.getEntityMappings() != null) {
            this.getEntityMappings().addToMessages(messages);
        }
    }
}

